/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.client.gui.GuiFusionReactorInfo;
import mekanism.generators.client.gui.element.GuiFusionReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiFusionReactorStats
extends GuiFusionReactorInfo {
    public GuiFusionReactorStats(EmptyTileContainer<TileEntityFusionReactorController> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.HEAT));
        this.addRenderableWidget((GuiElement)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.FUEL));
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
        if (multiblock.isFormed()) {
            this.drawString(guiGraphics, (Component)GeneratorsLang.REACTOR_PASSIVE.translateColored(EnumColor.DARK_GREEN), 6, 26, this.titleTextColor());
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_MIN_INJECTION.translate(new Object[]{multiblock.getMinInjectionRate(false)}), 16.0f, 36.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_IGNITION.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getIgnitionTemperature(false), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16.0f, 46.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_MAX_PLASMA.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getMaxPlasmaTemperature(false), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16.0f, 56.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_MAX_CASING.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getMaxCasingTemperature(false), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16.0f, 66.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_PASSIVE_RATE.translate(new Object[]{EnergyDisplay.of((FloatingLong)multiblock.getPassiveGeneration(false, false))}), 16.0f, 76.0f, this.titleTextColor(), 156.0f);
            this.drawString(guiGraphics, (Component)GeneratorsLang.REACTOR_ACTIVE.translateColored(EnumColor.DARK_BLUE), 6, 92, this.titleTextColor());
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_MIN_INJECTION.translate(new Object[]{multiblock.getMinInjectionRate(true)}), 16.0f, 102.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_IGNITION.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getIgnitionTemperature(true), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16.0f, 112.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_MAX_PLASMA.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getMaxPlasmaTemperature(true), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16.0f, 122.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_MAX_CASING.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getMaxCasingTemperature(true), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16.0f, 132.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_PASSIVE_RATE.translate(new Object[]{EnergyDisplay.of((FloatingLong)multiblock.getPassiveGeneration(true, false))}), 16.0f, 142.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_STEAM_PRODUCTION.translate(new Object[]{TextUtils.format((long)multiblock.getSteamPerTick(false))}), 16.0f, 152.0f, this.titleTextColor(), 156.0f);
        }
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

