/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.button.ToggleButton;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.generators.client.gui.element.button.ReactorLogicButton;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.network.to_server.PacketGeneratorsGuiInteract;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorLogicAdapter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiFusionReactorLogicAdapter
extends GuiMekanismTile<TileEntityFusionReactorLogicAdapter, EmptyTileContainer<TileEntityFusionReactorLogicAdapter>> {
    private static final int DISPLAY_COUNT = 4;
    private GuiScrollBar scrollBar;

    public GuiFusionReactorLogicAdapter(EmptyTileContainer<TileEntityFusionReactorLogicAdapter> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiElementHolder((IGuiWrapper)this, 16, 31, 130, 90));
        ((ToggleButton)this.addRenderableWidget((GuiElement)new ToggleButton((IGuiWrapper)this, 16, 19, 11, ((TileEntityFusionReactorLogicAdapter)this.tile)::isActiveCooled, (element, mouseX, mouseY) -> PacketUtils.sendToServer((CustomPacketPayload)new PacketGuiInteract(PacketGuiInteract.GuiInteraction.NEXT_MODE, (BlockEntity)((GuiFusionReactorLogicAdapter)element.gui()).tile))))).setTooltip((ILangEntry)GeneratorsLang.REACTOR_LOGIC_TOGGLE_COOLING);
        this.scrollBar = (GuiScrollBar)this.addRenderableWidget((GuiElement)new GuiScrollBar((IGuiWrapper)this, 146, 31, 90, () -> ((TileEntityFusionReactorLogicAdapter)this.tile).getModes().length, () -> 4));
        for (int i = 0; i < 4; ++i) {
            int typeShift = 22 * i;
            this.addRenderableWidget((GuiElement)new ReactorLogicButton<TileEntityFusionReactorLogicAdapter.FusionReactorLogic>((IGuiWrapper)this, 17, 32 + typeShift, i, (IReactorLogic)this.tile, TileEntityFusionReactorLogicAdapter.FusionReactorLogic.class, () -> ((GuiScrollBar)this.scrollBar).getCurrentSelection(), ((TileEntityFusionReactorLogicAdapter)this.tile)::getModes, this::changeLogic));
        }
    }

    private void changeLogic(TileEntityFusionReactorLogicAdapter.FusionReactorLogic type) {
        if (type != null) {
            PacketUtils.sendToServer((CustomPacketPayload)new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.LOGIC_TYPE, (BlockEntity)this.tile, (double)type.ordinal()));
        }
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_LOGIC_ACTIVE_COOLING.translate(new Object[]{EnumColor.RED, BooleanStateDisplay.OnOff.of((boolean)((TileEntityFusionReactorLogicAdapter)this.tile).isActiveCooled())}), 29.0f, 20.0f, this.titleTextColor(), 117.0f);
        this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.REACTOR_LOGIC_REDSTONE_MODE.translate(new Object[]{EnumColor.RED, ((TileEntityFusionReactorLogicAdapter)this.tile).logicType}), 16.0f, 123.0f, this.titleTextColor(), 144.0f);
        this.drawCenteredText(guiGraphics, (Component)MekanismLang.STATUS.translate(new Object[]{EnumColor.RED, ((TileEntityFusionReactorLogicAdapter)this.tile).checkMode() ? GeneratorsLang.REACTOR_LOGIC_OUTPUTTING : MekanismLang.IDLE}), 0.0f, this.imageWidth, 136.0f, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY) || this.scrollBar.adjustScroll(deltaY);
    }
}

