/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.integration.stages.StageHelper;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StageTask
extends AbstractBooleanTask {
    private String stage = "";

    public StageTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.STAGE;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("stage", this.stage);
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.stage = nbt.getString("stage");
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.stage, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.stage = buffer.readUtf(Short.MAX_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("stage", this.stage, v -> {
            this.stage = v;
        }, "").setNameKey("ftbquests.task.ftbquests.gamestage");
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.translatable((String)"ftbquests.task.ftbquests.gamestage").append(": ").append((Component)Component.literal((String)this.stage).withStyle(ChatFormatting.YELLOW));
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        return StageHelper.INSTANCE.getProvider().has((Player)player, this.stage);
    }

    public static void checkStages(ServerPlayer player) {
        TeamData data;
        TeamData teamData = data = ServerQuestFile.INSTANCE == null || PlayerHooks.isFake((Player)player) ? null : ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)player);
        if (data == null || data.isLocked()) {
            return;
        }
        ServerQuestFile.INSTANCE.withPlayerContext(player, () -> {
            for (Task task : ServerQuestFile.INSTANCE.getAllTasks()) {
                if (!(task instanceof StageTask) || !data.canStartTasks(task.getQuest())) continue;
                task.submitTask(data, player);
            }
        });
    }
}

