/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.integration.stages.StageHelper;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StageReward
extends Reward {
    private String stage = "";
    private boolean remove = false;

    public StageReward(long id, Quest quest) {
        super(id, quest);
        this.autoclaim = RewardAutoClaim.INVISIBLE;
    }

    @Override
    public RewardType getType() {
        return RewardTypes.STAGE;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("stage", this.stage);
        if (this.remove) {
            nbt.putBoolean("remove", true);
        }
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.stage = nbt.getString("stage");
        this.remove = nbt.getBoolean("remove");
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.stage, Short.MAX_VALUE);
        buffer.writeBoolean(this.remove);
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.stage = buffer.readUtf(Short.MAX_VALUE);
        this.remove = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("stage", this.stage, v -> {
            this.stage = v;
        }, "").setNameKey("ftbquests.reward.ftbquests.gamestage");
        config.addBool("remove", this.remove, v -> {
            this.remove = v;
        }, false);
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        if (this.remove) {
            StageHelper.INSTANCE.getProvider().remove(player, this.stage);
        } else {
            StageHelper.INSTANCE.getProvider().add(player, this.stage);
        }
        if (notify) {
            if (this.remove) {
                player.sendSystemMessage((Component)Component.translatable((String)"commands.gamestage.remove.target", (Object[])new Object[]{this.stage}), true);
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"commands.gamestage.add.target", (Object[])new Object[]{this.stage}), true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.translatable((String)"ftbquests.reward.ftbquests.gamestage").append(": ").append((Component)Component.literal((String)this.stage).withStyle(ChatFormatting.YELLOW));
    }

    @Override
    public boolean ignoreRewardBlocking() {
        return true;
    }

    @Override
    protected boolean isIgnoreRewardBlockingHardcoded() {
        return true;
    }
}

