/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CommandReward
extends Reward {
    private String command = "/say Hi, @p!";
    private boolean elevatePerms;
    private boolean silent;

    public CommandReward(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.COMMAND;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("command", this.command);
        if (this.elevatePerms) {
            nbt.putBoolean("elevate_perms", true);
        }
        if (this.silent) {
            nbt.putBoolean("silent", true);
        }
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.command = nbt.getString("command");
        this.elevatePerms = nbt.getBoolean("elevate_perms");
        this.silent = nbt.getBoolean("silent");
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.command, Short.MAX_VALUE);
        buffer.writeBoolean(this.elevatePerms);
        buffer.writeBoolean(this.silent);
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.command = buffer.readUtf(Short.MAX_VALUE);
        this.elevatePerms = buffer.readBoolean();
        this.silent = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("command", this.command, v -> {
            this.command = v;
        }, "/say Hi, @team!").setNameKey("ftbquests.reward.ftbquests.command");
        config.addBool("elevate", this.elevatePerms, v -> {
            this.elevatePerms = v;
        }, false);
        config.addBool("silent", this.silent, v -> {
            this.silent = v;
        }, false);
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        HashMap<String, Comparable<Integer>> overrides = new HashMap<String, Comparable<Integer>>();
        BlockPos pos = player.blockPosition();
        overrides.put("x", Integer.valueOf(pos.getX()));
        overrides.put("y", Integer.valueOf(pos.getY()));
        overrides.put("z", Integer.valueOf(pos.getZ()));
        if (this.getQuestChapter() != null) {
            overrides.put("chapter", this.getQuestChapter());
        }
        overrides.put("quest", this.quest);
        String cmd = this.command;
        for (Map.Entry entry : overrides.entrySet()) {
            if (entry.getValue() == null) continue;
            cmd = cmd.replace("{" + (String)entry.getKey() + "}", entry.getValue().toString());
        }
        CommandSourceStack source = player.createCommandSourceStack();
        if (this.elevatePerms) {
            source = source.withPermission(2);
        }
        if (this.silent) {
            source = source.withSuppressedOutput();
        }
        player.server.getCommands().performPrefixedCommand(source, cmd);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.translatable((String)"ftbquests.reward.ftbquests.command").append(": ").append((Component)Component.literal((String)this.command).withStyle(ChatFormatting.RED));
    }
}

