/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.KnownServerRegistries;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AdvancementReward
extends Reward {
    private ResourceLocation advancement = ResourceLocation.withDefaultNamespace((String)"story/root");
    private String criterion = "";

    public AdvancementReward(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.ADVANCEMENT;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("advancement", this.advancement.toString());
        nbt.putString("criterion", this.criterion);
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.advancement = ResourceLocation.tryParse((String)nbt.getString("advancement"));
        this.criterion = nbt.getString("criterion");
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeResourceLocation(this.advancement);
        buffer.writeUtf(this.criterion, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.advancement = buffer.readResourceLocation();
        this.criterion = buffer.readUtf(Short.MAX_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        if (KnownServerRegistries.client != null && !KnownServerRegistries.client.advancements().isEmpty()) {
            Map advancements = KnownServerRegistries.client.advancements();
            config.addEnum("advancement", (Object)this.advancement, v -> {
                this.advancement = v;
            }, NameMap.of((Object)((ResourceLocation)advancements.keySet().iterator().next()), (Object[])advancements.keySet().toArray(new ResourceLocation[0])).icon(resourceLocation -> ItemIcon.getItemIcon((ItemStack)((KnownServerRegistries.AdvancementInfo)advancements.get(resourceLocation)).icon())).name(resourceLocation -> ((KnownServerRegistries.AdvancementInfo)advancements.get(resourceLocation)).name()).create()).setNameKey("ftbquests.reward.ftbquests.advancement");
        } else {
            config.addString("advancement", this.advancement.toString(), v -> {
                this.advancement = ResourceLocation.tryParse((String)v);
            }, "minecraft:story/root").setNameKey("ftbquests.reward.ftbquests.advancement");
        }
        config.addString("criterion", this.criterion, v -> {
            this.criterion = v;
        }, "");
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        AdvancementHolder advancementHolder = player.server.getAdvancements().get(this.advancement);
        if (advancementHolder != null) {
            if (this.criterion.isEmpty()) {
                for (String s : advancementHolder.value().criteria().keySet()) {
                    player.getAdvancements().award(advancementHolder, s);
                }
            } else {
                player.getAdvancements().award(advancementHolder, this.criterion);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements().get(this.advancement);
        if (info != null && info.name().getContents() != PlainTextContents.EMPTY) {
            return Component.translatable((String)"ftbquests.reward.ftbquests.advancement").append(": ").append((Component)info.name().copy().withStyle(ChatFormatting.YELLOW));
        }
        return super.getAltTitle();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements().get(this.advancement);
        if (info != null && !info.icon().isEmpty()) {
            return ItemIcon.getItemIcon((ItemStack)info.icon());
        }
        return super.getAltIcon();
    }
}

