/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import com.mojang.datafixers.util.Either;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.translation.TranslationKey;
import dev.ftb.mods.ftbquests.util.NetUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record SyncTranslationMessageToClient(long id, String locale, TranslationKey subKey, Either<String, List<String>> val) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncTranslationMessageToClient> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("sync_translation_to_client"));
    public static StreamCodec<FriendlyByteBuf, SyncTranslationMessageToClient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, SyncTranslationMessageToClient::id, (StreamCodec)ByteBufCodecs.STRING_UTF8, SyncTranslationMessageToClient::locale, (StreamCodec)NetworkHelper.enumStreamCodec(TranslationKey.class), SyncTranslationMessageToClient::subKey, (StreamCodec)ByteBufCodecs.either((StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.collection(ArrayList::new))), SyncTranslationMessageToClient::val, SyncTranslationMessageToClient::new);

    public static SyncTranslationMessageToClient create(QuestObjectBase obj, String locale, TranslationKey subKey, String text) {
        return new SyncTranslationMessageToClient(obj.id, locale, subKey, (Either<String, List<String>>)Either.left((Object)text));
    }

    public static SyncTranslationMessageToClient create(QuestObjectBase obj, String locale, TranslationKey subKey, List<String> list) {
        return new SyncTranslationMessageToClient(obj.id, locale, subKey, (Either<String, List<String>>)Either.right(list));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncTranslationMessageToClient message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            QuestObjectBase object;
            ClientQuestFile file = ClientQuestFile.INSTANCE;
            if (file.isValid() && NetUtils.canEdit(context) && (object = file.getBase(message.id)) != null) {
                message.val.ifLeft(str -> file.getTranslationManager().addTranslation(object, message.locale, message.subKey, (String)str)).ifRight(list -> file.getTranslationManager().addTranslation(object, message.locale, message.subKey, (List<String>)list));
                object.clearCachedData();
            }
        });
    }
}

