/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class TypeUtils {
    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            Class clz = (Class)type;
            return clz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            if (rawType instanceof Class) {
                Class clz = (Class)rawType;
                return clz;
            }
        } else {
            if (type instanceof GenericArrayType) {
                GenericArrayType arrType = (GenericArrayType)type;
                Type componentType = arrType.getGenericComponentType();
                return Array.newInstance(TypeUtils.getRawType(componentType), 0).getClass();
            }
            if (type instanceof TypeVariable) {
                return Object.class;
            }
            if (type instanceof WildcardType) {
                WildcardType wildcard = (WildcardType)type;
                return TypeUtils.getRawType(wildcard.getUpperBounds()[0]);
            }
        }
        return null;
    }

    public static Type getComponentType(Type type, Type fallback) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c.getComponentType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arr = (GenericArrayType)type;
            return arr.getGenericComponentType();
        }
        return fallback;
    }
}

