/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.type.ArrayTypeInfo;
import dev.latvian.mods.rhino.type.BasicClassTypeInfo;
import dev.latvian.mods.rhino.type.EnumTypeInfo;
import dev.latvian.mods.rhino.type.InterfaceTypeInfo;
import dev.latvian.mods.rhino.type.JSOrTypeInfo;
import dev.latvian.mods.rhino.type.NoTypeInfo;
import dev.latvian.mods.rhino.type.ParameterizedTypeInfo;
import dev.latvian.mods.rhino.type.PrimitiveClassTypeInfo;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeStringContext;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public interface TypeInfo {
    public static final TypeInfo NONE = new NoTypeInfo();
    public static final TypeInfo[] EMPTY_ARRAY = new TypeInfo[0];
    public static final TypeInfo OBJECT = new BasicClassTypeInfo(Object.class);
    public static final TypeInfo OBJECT_ARRAY = OBJECT.asArray();
    public static final TypeInfo PRIMITIVE_VOID = new PrimitiveClassTypeInfo(Void.TYPE, null);
    public static final TypeInfo PRIMITIVE_BOOLEAN = new PrimitiveClassTypeInfo(Boolean.TYPE, false);
    public static final TypeInfo PRIMITIVE_BYTE = new PrimitiveClassTypeInfo(Byte.TYPE, (byte)0);
    public static final TypeInfo PRIMITIVE_SHORT = new PrimitiveClassTypeInfo(Short.TYPE, (short)0);
    public static final TypeInfo PRIMITIVE_INT = new PrimitiveClassTypeInfo(Integer.TYPE, 0);
    public static final TypeInfo PRIMITIVE_LONG = new PrimitiveClassTypeInfo(Long.TYPE, 0L);
    public static final TypeInfo PRIMITIVE_FLOAT = new PrimitiveClassTypeInfo(Float.TYPE, Float.valueOf(0.0f));
    public static final TypeInfo PRIMITIVE_DOUBLE = new PrimitiveClassTypeInfo(Double.TYPE, 0.0);
    public static final TypeInfo PRIMITIVE_CHARACTER = new PrimitiveClassTypeInfo(Character.TYPE, Character.valueOf('\u0000'));
    public static final TypeInfo VOID = new BasicClassTypeInfo(Void.class);
    public static final TypeInfo BOOLEAN = new BasicClassTypeInfo(Boolean.class);
    public static final TypeInfo BYTE = new BasicClassTypeInfo(Byte.class);
    public static final TypeInfo SHORT = new BasicClassTypeInfo(Short.class);
    public static final TypeInfo INT = new BasicClassTypeInfo(Integer.class);
    public static final TypeInfo LONG = new BasicClassTypeInfo(Long.class);
    public static final TypeInfo FLOAT = new BasicClassTypeInfo(Float.class);
    public static final TypeInfo DOUBLE = new BasicClassTypeInfo(Double.class);
    public static final TypeInfo CHARACTER = new BasicClassTypeInfo(Character.class);
    public static final TypeInfo NUMBER = new BasicClassTypeInfo(Number.class);
    public static final TypeInfo STRING = new BasicClassTypeInfo(String.class);
    public static final TypeInfo STRING_ARRAY = STRING.asArray();
    public static final TypeInfo CLASS = new BasicClassTypeInfo(Class.class);
    public static final TypeInfo DATE = new BasicClassTypeInfo(Date.class);
    public static final TypeInfo RUNNABLE = new InterfaceTypeInfo(Runnable.class, Boolean.TRUE);
    public static final TypeInfo RAW_CONSUMER = new InterfaceTypeInfo(Consumer.class, Boolean.TRUE);
    public static final TypeInfo RAW_SUPPLIER = new InterfaceTypeInfo(Supplier.class, Boolean.TRUE);
    public static final TypeInfo RAW_FUNCTION = new InterfaceTypeInfo(Function.class, Boolean.TRUE);
    public static final TypeInfo RAW_PREDICATE = new InterfaceTypeInfo(Predicate.class, Boolean.TRUE);
    public static final TypeInfo RAW_LIST = new InterfaceTypeInfo(List.class, Boolean.FALSE);
    public static final TypeInfo RAW_SET = new InterfaceTypeInfo(Set.class, Boolean.FALSE);
    public static final TypeInfo RAW_MAP = new InterfaceTypeInfo(Map.class, Boolean.FALSE);
    public static final TypeInfo RAW_OPTIONAL = new BasicClassTypeInfo(Optional.class);

    public Class<?> asClass();

    default public TypeInfo param(int index) {
        return NONE;
    }

    default public boolean is(TypeInfo info) {
        return this == info;
    }

    default public boolean isPrimitive() {
        return false;
    }

    default public boolean shouldConvert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeInfo of(Class<?> c) {
        if (c == null || c == Object.class) {
            return OBJECT;
        }
        if (c == Void.TYPE) {
            return PRIMITIVE_VOID;
        }
        if (c == Boolean.TYPE) {
            return PRIMITIVE_BOOLEAN;
        }
        if (c == Byte.TYPE) {
            return PRIMITIVE_BYTE;
        }
        if (c == Short.TYPE) {
            return PRIMITIVE_SHORT;
        }
        if (c == Integer.TYPE) {
            return PRIMITIVE_INT;
        }
        if (c == Long.TYPE) {
            return PRIMITIVE_LONG;
        }
        if (c == Float.TYPE) {
            return PRIMITIVE_FLOAT;
        }
        if (c == Double.TYPE) {
            return PRIMITIVE_DOUBLE;
        }
        if (c == Character.TYPE) {
            return PRIMITIVE_CHARACTER;
        }
        if (c == Void.class) {
            return VOID;
        }
        if (c == Boolean.class) {
            return BOOLEAN;
        }
        if (c == Byte.class) {
            return BYTE;
        }
        if (c == Short.class) {
            return SHORT;
        }
        if (c == Integer.class) {
            return INT;
        }
        if (c == Long.class) {
            return LONG;
        }
        if (c == Float.class) {
            return FLOAT;
        }
        if (c == Double.class) {
            return DOUBLE;
        }
        if (c == Character.class) {
            return CHARACTER;
        }
        if (c == Number.class) {
            return NUMBER;
        }
        if (c == String.class) {
            return STRING;
        }
        if (c == Class.class) {
            return CLASS;
        }
        if (c == Date.class) {
            return DATE;
        }
        if (c == Optional.class) {
            return RAW_OPTIONAL;
        }
        if (c == Runnable.class) {
            return RUNNABLE;
        }
        if (c == Consumer.class) {
            return RAW_CONSUMER;
        }
        if (c == Supplier.class) {
            return RAW_SUPPLIER;
        }
        if (c == Function.class) {
            return RAW_FUNCTION;
        }
        if (c == Predicate.class) {
            return RAW_PREDICATE;
        }
        if (c == List.class) {
            return RAW_LIST;
        }
        if (c == Set.class) {
            return RAW_SET;
        }
        if (c == Map.class) {
            return RAW_MAP;
        }
        if (c == Object[].class) {
            return OBJECT_ARRAY;
        }
        if (c == String[].class) {
            return STRING_ARRAY;
        }
        if (c.isArray()) {
            return TypeInfo.of(c.getComponentType()).asArray();
        }
        if (c.isEnum()) {
            Map<Class<?>, EnumTypeInfo> map = EnumTypeInfo.CACHE;
            synchronized (map) {
                return EnumTypeInfo.CACHE.computeIfAbsent(c, EnumTypeInfo::new);
            }
        }
        if (c.isRecord()) {
            Map<Class<?>, RecordTypeInfo> map = RecordTypeInfo.CACHE;
            synchronized (map) {
                return RecordTypeInfo.CACHE.computeIfAbsent(c, RecordTypeInfo::new);
            }
        }
        if (c.isInterface()) {
            Map<Class<?>, InterfaceTypeInfo> map = InterfaceTypeInfo.CACHE;
            synchronized (map) {
                return InterfaceTypeInfo.CACHE.computeIfAbsent(c, InterfaceTypeInfo::new);
            }
        }
        Map<Class<?>, BasicClassTypeInfo> map = BasicClassTypeInfo.CACHE;
        synchronized (map) {
            return BasicClassTypeInfo.CACHE.computeIfAbsent(c, BasicClassTypeInfo::new);
        }
    }

    public static TypeInfo of(Type type) {
        Type type2 = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, ParameterizedType.class, GenericArrayType.class, TypeVariable.class, WildcardType.class}, (Object)type2, n)) {
            case 0 -> {
                Class clz = (Class)type2;
                yield TypeInfo.of(clz);
            }
            case 1 -> {
                ParameterizedType paramType = (ParameterizedType)type2;
                yield TypeInfo.of(paramType.getRawType()).withParams(TypeInfo.ofArray(paramType.getActualTypeArguments()));
            }
            case 2 -> {
                GenericArrayType arrType = (GenericArrayType)type2;
                yield TypeInfo.of(arrType.getGenericComponentType()).asArray();
            }
            case 3 -> {
                TypeVariable ignore = (TypeVariable)type2;
                yield NONE;
            }
            case 4 -> {
                WildcardType wildcard = (WildcardType)type2;
                Type[] lower = wildcard.getLowerBounds();
                if (lower.length == 0) {
                    Type[] upper = wildcard.getUpperBounds();
                    if (upper.length == 0 || upper[0] == Object.class) {
                        yield NONE;
                    }
                    yield TypeInfo.of(upper[0]);
                }
                yield TypeInfo.of(lower[0]);
            }
            default -> NONE;
        };
    }

    public static TypeInfo[] ofArray(Type[] array) {
        if (array.length == 0) {
            return EMPTY_ARRAY;
        }
        TypeInfo[] arr = new TypeInfo[array.length];
        for (int i = 0; i < array.length; ++i) {
            arr[i] = TypeInfo.of(array[i]);
        }
        return arr;
    }

    default public String signature() {
        return this.toString();
    }

    default public TypeInfo componentType() {
        return NONE;
    }

    default public Object newArray(int length) {
        return Array.newInstance(this.asClass(), length);
    }

    default public TypeInfo asArray() {
        return new ArrayTypeInfo(this);
    }

    default public TypeInfo withParams(TypeInfo ... params) {
        if (params.length == 0) {
            return this;
        }
        return new ParameterizedTypeInfo(this, params);
    }

    default public boolean isFunctionalInterface() {
        return false;
    }

    default public Map<String, RecordTypeInfo.Component> recordComponents() {
        return Map.of();
    }

    default public List<Object> enumConstants() {
        return List.of();
    }

    default public TypeInfo or(TypeInfo info) {
        return new JSOrTypeInfo(List.of(this, info));
    }

    default public void append(TypeStringContext ctx, StringBuilder sb) {
        sb.append(this);
    }

    @Nullable
    default public Object createDefaultValue() {
        return null;
    }

    default public boolean isVoid() {
        return false;
    }

    default public boolean isBoolean() {
        return false;
    }

    default public boolean isByte() {
        return false;
    }

    default public boolean isShort() {
        return false;
    }

    default public boolean isInt() {
        return false;
    }

    default public boolean isLong() {
        return false;
    }

    default public boolean isFloat() {
        return false;
    }

    default public boolean isDouble() {
        return false;
    }

    default public boolean isCharacter() {
        return false;
    }
}

