/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.inventory;

import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ArmoryCabinetInventoryHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    public List<ItemStack> stackList = this.create();

    public int getSlots() {
        return FunctionalStorageConfig.ARMORY_CABINET_SIZE;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot < this.stackList.size()) {
            return this.stackList.get(slot);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.isValid(slot, stack)) {
            if (!simulate) {
                this.stackList.set(slot, stack);
                this.onChange();
            }
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public abstract void onChange();

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!simulate) {
            ItemStack stack = this.stackList.set(slot, ItemStack.EMPTY);
            this.onChange();
            return stack;
        }
        return this.stackList.get(slot);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.isCertifiedStack(stack);
    }

    private boolean isValid(int slot, @NotNull ItemStack stack) {
        return !stack.isEmpty() && this.stackList.get(slot).isEmpty() && this.isCertifiedStack(stack);
    }

    private boolean isCertifiedStack(ItemStack stack) {
        if (stack.getCapability(Capabilities.ItemHandler.ITEM) != null) {
            return false;
        }
        if (stack.getMaxStackSize() > 1) {
            return false;
        }
        return stack.isDamageableItem() || stack.isEnchantable() || stack.has(DataComponents.JUKEBOX_PLAYABLE) || stack.getItem() instanceof AnimalArmorItem;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        for (int i = 0; i < this.stackList.size(); ++i) {
            ItemStack stack = this.stackList.get(i);
            if (stack.isEmpty()) continue;
            compoundTag.put(String.valueOf(i), stack.saveOptional(provider));
        }
        return compoundTag;
    }

    private List<ItemStack> create() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < FunctionalStorageConfig.ARMORY_CABINET_SIZE; ++i) {
            stackList.add(ItemStack.EMPTY);
        }
        return stackList;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.stackList = this.create();
        for (String allKey : nbt.getAllKeys()) {
            int pos = Integer.parseInt(allKey);
            if (pos >= this.stackList.size()) continue;
            this.stackList.set(pos, (ItemStack)((Pair)ItemStack.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)provider), (Object)nbt.getCompound(allKey)).getOrThrow()).getFirst());
        }
    }
}

