/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.client.FluidDrawerRenderer;
import com.buuz135.functionalstorage.client.item.FunctionalStorageISTER;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.util.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidDrawerISTER
extends FunctionalStorageISTER {
    public static final FluidDrawerISTER SLOT_1 = new FluidDrawerISTER(FunctionalStorage.DrawerType.X_1);
    public static final FluidDrawerISTER SLOT_2 = new FluidDrawerISTER(FunctionalStorage.DrawerType.X_2);
    public static final FluidDrawerISTER SLOT_4 = new FluidDrawerISTER(FunctionalStorage.DrawerType.X_4);
    private final FunctionalStorage.DrawerType type;

    public FluidDrawerISTER(FunctionalStorage.DrawerType type) {
        this.type = type;
    }

    @Override
    public void onResourceManagerReload(@NotNull ResourceManager resourceManager) {
    }

    @Override
    public void renderByItem(HolderLookup.Provider access, @NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight) {
        ModelData modelData = this.getData(stack);
        this.renderBlockItem(stack, displayContext, matrix, renderer, light, overlayLight, modelData);
        if (stack.has(FSAttachments.TILE)) {
            ControllableDrawerTile.DrawerOptions options = new ControllableDrawerTile.DrawerOptions();
            options.deserializeNBT(access, ((CompoundTag)stack.get(FSAttachments.TILE)).getCompound("drawerOptions"));
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
            matrix.translate(-1.0f, 0.0f, -1.0f);
            CompoundTag tileTag = ((CompoundTag)stack.get(FSAttachments.TILE)).getCompound("fluidHandler");
            if (this.type == FunctionalStorage.DrawerType.X_1) {
                FluidStack fluidStack = FluidDrawerISTER.deserialize(access, tileTag, 0);
                if (!fluidStack.isEmpty()) {
                    int displayAmount = fluidStack.getAmount();
                    AABB bounds = new AABB(0.0625, 0.078125, 0.0625, 0.9375, 0.078125 + (double)fluidStack.getAmount() / (double)fluidStack.getAmount() * 0.78125, 0.9375);
                    FluidDrawerRenderer.renderFluidStack(matrix, renderer, light, overlayLight, fluidStack, displayAmount, fluidStack.getAmount(), 0.007f, options, bounds, false, false);
                }
            } else if (this.type == FunctionalStorage.DrawerType.X_2) {
                AABB bounds;
                int displayAmount;
                FluidStack fluidStack = FluidDrawerISTER.deserialize(access, tileTag, 0);
                if (!fluidStack.isEmpty()) {
                    displayAmount = fluidStack.getAmount();
                    bounds = new AABB(0.0625, 0.078125, 0.0625, 0.9375, 0.078125 + (double)fluidStack.getAmount() / (double)fluidStack.getAmount() * 0.34375, 0.9375);
                    FluidDrawerRenderer.renderFluidStack(matrix, renderer, light, overlayLight, fluidStack, displayAmount, fluidStack.getAmount(), 0.007f, options, bounds, false, true);
                }
                if (!(fluidStack = FluidDrawerISTER.deserialize(access, tileTag, 1)).isEmpty()) {
                    matrix.pushPose();
                    matrix.translate(0.0, 0.5, 0.0);
                    displayAmount = fluidStack.getAmount();
                    bounds = new AABB(0.0625, 0.078125, 0.0625, 0.9375, 0.078125 + (double)fluidStack.getAmount() / (double)fluidStack.getAmount() * 0.34375, 0.9375);
                    FluidDrawerRenderer.renderFluidStack(matrix, renderer, light, overlayLight, fluidStack, displayAmount, fluidStack.getAmount(), 0.007f, options, bounds, false, true);
                    matrix.popPose();
                }
            } else if (this.type == FunctionalStorage.DrawerType.X_4) {
                AABB bounds;
                int displayAmount;
                FluidStack fluidStack = FluidDrawerISTER.deserialize(access, tileTag, 0);
                if (!fluidStack.isEmpty()) {
                    matrix.pushPose();
                    matrix.translate(0.5, 0.0, 0.0);
                    displayAmount = fluidStack.getAmount();
                    bounds = new AABB(0.0625, 0.078125, 0.0625, 0.5, 0.078125 + (double)fluidStack.getAmount() / (double)fluidStack.getAmount() * 0.34375, 0.9375);
                    FluidDrawerRenderer.renderFluidStack(matrix, renderer, light, overlayLight, fluidStack, displayAmount, fluidStack.getAmount(), 0.007f, options, bounds, true, true);
                    matrix.popPose();
                }
                if (!(fluidStack = FluidDrawerISTER.deserialize(access, tileTag, 1)).isEmpty()) {
                    matrix.pushPose();
                    displayAmount = fluidStack.getAmount();
                    bounds = new AABB(0.0625, 0.078125, 0.0625, 0.5, 0.078125 + (double)fluidStack.getAmount() / (double)fluidStack.getAmount() * 0.34375, 0.9375);
                    FluidDrawerRenderer.renderFluidStack(matrix, renderer, light, overlayLight, fluidStack, displayAmount, fluidStack.getAmount(), 0.007f, options, bounds, true, true);
                    matrix.popPose();
                }
                if (!(fluidStack = FluidDrawerISTER.deserialize(access, tileTag, 2)).isEmpty()) {
                    matrix.pushPose();
                    matrix.translate(0.5, 0.5, 0.0);
                    displayAmount = fluidStack.getAmount();
                    bounds = new AABB(0.0625, 0.078125, 0.0625, 0.5, 0.078125 + (double)fluidStack.getAmount() / (double)fluidStack.getAmount() * 0.34375, 0.9375);
                    FluidDrawerRenderer.renderFluidStack(matrix, renderer, light, overlayLight, fluidStack, displayAmount, fluidStack.getAmount(), 0.007f, options, bounds, true, true);
                    matrix.popPose();
                }
                if (!(fluidStack = FluidDrawerISTER.deserialize(access, tileTag, 3)).isEmpty()) {
                    matrix.pushPose();
                    matrix.translate(0.0, 0.5, 0.0);
                    displayAmount = fluidStack.getAmount();
                    bounds = new AABB(0.0625, 0.078125, 0.0625, 0.5, 0.078125 + (double)fluidStack.getAmount() / (double)fluidStack.getAmount() * 0.34375, 0.9375);
                    FluidDrawerRenderer.renderFluidStack(matrix, renderer, light, overlayLight, fluidStack, displayAmount, fluidStack.getAmount(), 0.007f, options, bounds, true, true);
                    matrix.popPose();
                }
            }
        }
    }

    public static FluidStack deserialize(HolderLookup.Provider access, CompoundTag tileTag, int i) {
        CompoundTag fluidTag = tileTag.getCompound(String.valueOf(i));
        return Utils.deserializeFluid(access, fluidTag.getCompound("Fluid"));
    }
}

