/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client.gui;

import com.buuz135.functionalstorage.fluid.BigFluidHandler;
import com.buuz135.functionalstorage.util.NumberUtils;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FluidDrawerInfoGuiAddon
extends BasicScreenAddon {
    private final ResourceLocation gui;
    private final int slotAmount;
    private final Function<Integer, Pair<Integer, Integer>> slotPosition;
    private final Supplier<BigFluidHandler> fluidHandlerSupplier;
    private final Function<Integer, Integer> slotMaxAmount;

    public FluidDrawerInfoGuiAddon(int posX, int posY, ResourceLocation gui, int slotAmount, Function<Integer, Pair<Integer, Integer>> slotPosition, Supplier<BigFluidHandler> fluidHandlerSupplier, Function<Integer, Integer> slotMaxAmount) {
        super(posX, posY);
        this.gui = gui;
        this.slotAmount = slotAmount;
        this.slotPosition = slotPosition;
        this.fluidHandlerSupplier = fluidHandlerSupplier;
        this.slotMaxAmount = slotMaxAmount;
    }

    public static Rect2i getSizeForSlots(int currentSlot, int slotAmount) {
        if (slotAmount == 1) {
            return new Rect2i(9, 9, 30, 30);
        }
        if (slotAmount == 2) {
            if (currentSlot == 0) {
                return new Rect2i(0, 30, 48, 13);
            }
            if (currentSlot == 1) {
                return new Rect2i(0, 6, 48, 13);
            }
        }
        if (slotAmount == 4) {
            if (currentSlot == 0) {
                return new Rect2i(30, 30, 16, 16);
            }
            if (currentSlot == 1) {
                return new Rect2i(2, 30, 16, 16);
            }
            if (currentSlot == 2) {
                return new Rect2i(30, 2, 16, 16);
            }
            if (currentSlot == 3) {
                return new Rect2i(2, 2, 16, 16);
            }
        }
        return new Rect2i(0, 0, 0, 0);
    }

    public static Rect2i getSizeForHoverSlots(int currentSlot, int slotAmount) {
        if (slotAmount == 1) {
            return new Rect2i(9, 9, 30, 30);
        }
        if (slotAmount == 2) {
            if (currentSlot == 0) {
                return new Rect2i(6, 30, 36, 12);
            }
            if (currentSlot == 1) {
                return new Rect2i(6, 6, 36, 12);
            }
        }
        if (slotAmount == 4) {
            if (currentSlot == 0) {
                return new Rect2i(30, 30, 12, 12);
            }
            if (currentSlot == 1) {
                return new Rect2i(6, 30, 12, 12);
            }
            if (currentSlot == 2) {
                return new Rect2i(30, 6, 12, 12);
            }
            if (currentSlot == 3) {
                return new Rect2i(6, 6, 12, 12);
            }
        }
        return new Rect2i(0, 0, 0, 0);
    }

    public int getXSize() {
        return 0;
    }

    public int getYSize() {
        return 0;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.slotAmount; ++i) {
            FluidStack fluidStack = this.fluidHandlerSupplier.get().getFluidInTank(i);
            if (fluidStack.isEmpty() && this.fluidHandlerSupplier.get().isDrawerLocked()) {
                fluidStack = this.fluidHandlerSupplier.get().getFilterStack()[i];
            }
            if (fluidStack.isEmpty()) continue;
            this.renderFluid(guiGraphics, screen, guiX, guiY, fluidStack, i, this.slotAmount);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.gui);
        int size = 48;
        guiGraphics.blit(this.gui, guiX + this.getPosX(), guiY + this.getPosY(), 0.0f, 0.0f, size, size, size, size);
        for (int i = 0; i < this.slotAmount; ++i) {
            FluidStack fluidStack = this.fluidHandlerSupplier.get().getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            int x = guiX + (Integer)this.slotPosition.apply(i).getLeft() + this.getPosX();
            int y = guiY + (Integer)this.slotPosition.apply(i).getRight() + this.getPosY();
            String amount = NumberUtils.getFormatedFluidBigNumber(fluidStack.getAmount()) + "/" + NumberUtils.getFormatedFluidBigNumber(this.slotMaxAmount.apply(i));
            float scale = 0.5f;
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            guiGraphics.pose().scale(scale, scale, scale);
            guiGraphics.drawString(Minecraft.getInstance().font, amount, (float)(x + 17 - Minecraft.getInstance().font.width(amount) / 2) * (1.0f / scale), (float)(y + 12) * (1.0f / scale), 0xFFFFFF, true);
            guiGraphics.pose().scale(1.0f / scale, 1.0f / scale, 1.0f / scale);
            guiGraphics.pose().translate(0.0f, 0.0f, -200.0f);
        }
    }

    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.slotAmount; ++i) {
            Rect2i rect = FluidDrawerInfoGuiAddon.getSizeForHoverSlots(i, this.slotAmount);
            int x = rect.getX() + this.getPosX() + guiX;
            int y = rect.getY() + this.getPosY() + guiY;
            if (mouseX <= x || mouseX >= x + rect.getWidth() || mouseY <= y || mouseY >= y + rect.getHeight()) continue;
            x = this.getPosX() + rect.getX();
            y = this.getPosY() + rect.getY();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            guiGraphics.fill(x, y, x + rect.getWidth(), y + rect.getHeight(), -2130706433);
            guiGraphics.pose().translate(0.0f, 0.0f, -200.0f);
            ArrayList<MutableComponent> componentList = new ArrayList<MutableComponent>();
            FluidStack over = this.fluidHandlerSupplier.get().getFluidInTank(i);
            if (over.isEmpty()) {
                componentList.add(Component.translatable((String)"gui.functionalstorage.fluid").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"Empty").withStyle(ChatFormatting.WHITE)));
            } else {
                componentList.add(Component.translatable((String)"gui.functionalstorage.fluid").withStyle(ChatFormatting.GOLD).append((Component)over.getHoverName().copy().withStyle(ChatFormatting.WHITE)));
                String amount = NumberUtils.getFormatedFluidBigNumber(over.getAmount()) + "/" + NumberUtils.getFormatedFluidBigNumber(this.slotMaxAmount.apply(i));
                componentList.add(Component.translatable((String)"gui.functionalstorage.amount").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)amount).withStyle(ChatFormatting.WHITE)));
            }
            componentList.add(Component.translatable((String)"gui.functionalstorage.slot").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)("" + i)).withStyle(ChatFormatting.WHITE)));
            guiGraphics.renderTooltip(Minecraft.getInstance().font, componentList, Optional.empty(), mouseX - guiX, mouseY - guiY);
        }
    }

    public void renderFluid(GuiGraphics guiGraphics, Screen screen, int guiX, int guiY, FluidStack fluidStack, int slot, int slotAmount) {
        TextureAtlasSprite sprite;
        AbstractTexture texture;
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation flowing = renderProperties.getStillTexture(fluidStack);
        if (flowing != null && (texture = screen.getMinecraft().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS)) instanceof TextureAtlas && (sprite = ((TextureAtlas)texture).getSprite(flowing)) != null) {
            Color color = new Color(renderProperties.getTintColor(fluidStack));
            Rect2i rect = FluidDrawerInfoGuiAddon.getSizeForSlots(slot, slotAmount);
            RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
            RenderSystem.enableBlend();
            for (int x = 0; x < rect.getWidth(); x += 16) {
                for (int y = 0; y < rect.getHeight(); y += 16) {
                    guiGraphics.blit(this.getPosX() + guiX + rect.getX() + x, this.getPosY() + guiY + rect.getY() + y, 0, Math.min(16, rect.getWidth() - x), Math.min(16, rect.getHeight() - y), sprite);
                }
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

