/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client;

import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.StorageControllerTile;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class ControllerRenderer
implements BlockEntityRenderer<StorageControllerTile<?>> {
    public static RenderType TYPE = RenderType.create((String)"custom_lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getRendertypeLinesShader)).setDepthTestState(new RenderStateShard.DepthTestStateShard("always", 519)).setLayeringState(new RenderStateShard.LayeringStateShard("view_offset_z_layering", () -> {
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.pushMatrix();
        posestack.scale(0.99975586f, 0.99975586f, 0.99975586f);
        RenderSystem.applyModelViewMatrix();
    }, () -> {
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    })).setCullState(new RenderStateShard.CullStateShard(false)).createCompositeState(false));
    private static RenderType AREA_TYPE = ControllerRenderer.createRenderType();

    private static void renderShape(PoseStack p_109783_, VertexConsumer p_109784_, VoxelShape p_109785_, double p_109786_, double p_109787_, double p_109788_, float p_109789_, float p_109790_, float p_109791_, float p_109792_) {
        PoseStack.Pose posestack$pose = p_109783_.last();
        p_109785_.forAllEdges((p_194324_, p_194325_, p_194326_, p_194327_, p_194328_, p_194329_) -> {
            float f = (float)(p_194327_ - p_194324_);
            float f1 = (float)(p_194328_ - p_194325_);
            float f2 = (float)(p_194329_ - p_194326_);
            float f3 = Mth.sqrt((float)(f * f + f1 * f1 + f2 * f2));
            p_109784_.addVertex(posestack$pose.pose(), (float)(p_194324_ + p_109786_), (float)(p_194325_ + p_109787_), (float)(p_194326_ + p_109788_)).setColor(p_109789_, p_109790_, p_109791_, p_109792_).setNormal(posestack$pose, f /= f3, f1 /= f3, f2 /= f3);
            p_109784_.addVertex(posestack$pose.pose(), (float)(p_194327_ + p_109786_), (float)(p_194328_ + p_109787_), (float)(p_194329_ + p_109788_)).setColor(p_109789_, p_109790_, p_109791_, p_109792_).setNormal(posestack$pose, f, f1, f2);
        });
    }

    public void render(StorageControllerTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack stack = Minecraft.getInstance().player.getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        if (stack.getItem() instanceof LinkingToolItem) {
            VoxelShape shape;
            BlockPos controller = FSAttachments.CONTROLLER.get(stack);
            if (!controller.equals((Object)tile.getBlockPos())) {
                return;
            }
            if (stack.has(FSAttachments.FIRST_POSITION)) {
                BlockPos firstPos = (BlockPos)stack.get(FSAttachments.FIRST_POSITION);
                HitResult result = RayTraceUtils.rayTraceSimple((Level)Minecraft.getInstance().level, (LivingEntity)Minecraft.getInstance().player, (double)8.0, (float)partialTicks);
                if (result.getType() == HitResult.Type.BLOCK) {
                    BlockPos hit = ((BlockHitResult)result).getBlockPos();
                    AABB aabb = new AABB((double)Math.min(firstPos.getX(), hit.getX()), (double)Math.min(firstPos.getY(), hit.getY()), (double)Math.min(firstPos.getZ(), hit.getZ()), (double)(Math.max(firstPos.getX(), hit.getX()) + 1), (double)(Math.max(firstPos.getY(), hit.getY()) + 1), (double)(Math.max(firstPos.getZ(), hit.getZ()) + 1));
                    VoxelShape shape2 = Shapes.create((AABB)aabb);
                    ControllerRenderer.renderShape(matrixStack, bufferIn.getBuffer(TYPE), shape2, -controller.getX(), -controller.getY(), -controller.getZ(), 1.0f, 1.0f, 1.0f, 1.0f);
                    return;
                }
            }
            if ((shape = tile.getConnectedDrawers().getCachedVoxelShape()) == null || tile.getLevel().getGameTime() % 400L == 0L) {
                tile.getConnectedDrawers().rebuildShapes();
                shape = tile.getConnectedDrawers().getCachedVoxelShape();
            }
            List list = shape.toAabbs();
            int i = Mth.ceil((double)((double)list.size() / 3.0));
            for (int j = 0; j < list.size(); ++j) {
                AABB aabb = (AABB)list.get(j);
                float f = ((float)j % (float)i + 1.0f) / (float)i;
                float f1 = j / i;
                float f2 = 1.0f;
                float f3 = 1.0f;
                float f4 = 1.0f;
                ControllerRenderer.renderShape(matrixStack, bufferIn.getBuffer(TYPE), Shapes.create((AABB)aabb.move(0.0, 0.0, 0.0)), -tile.getBlockPos().getX(), -tile.getBlockPos().getY(), -tile.getBlockPos().getZ(), f2, f3, f4, 1.0f);
            }
            int extraRange = tile.getStorageMultiplier();
            if (extraRange == 1) {
                extraRange = 0;
            }
            AABB area = new AABB(tile.getBlockPos()).inflate((double)(FunctionalStorageConfig.DRAWER_CONTROLLER_LINKING_RANGE + extraRange));
            ControllerRenderer.renderShape(matrixStack, bufferIn.getBuffer(TYPE), Shapes.create((AABB)area), -tile.getBlockPos().getX(), -tile.getBlockPos().getY(), -tile.getBlockPos().getZ(), 0.5f, 1.0f, 0.5f, 1.0f);
            this.renderFaces(matrixStack, bufferIn, area, -tile.getBlockPos().getX(), -tile.getBlockPos().getY(), -tile.getBlockPos().getZ(), 0.5f, 1.0f, 0.5f, 0.25f);
        }
    }

    public boolean shouldRender(StorageControllerTile p_173568_, Vec3 p_173569_) {
        return true;
    }

    public boolean shouldRenderOffScreen(StorageControllerTile p_112306_) {
        return true;
    }

    public AABB getRenderBoundingBox(StorageControllerTile<?> blockEntity) {
        return AABB.INFINITE;
    }

    public static RenderType createRenderType() {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorShader)).setTransparencyState(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        })).setDepthTestState(new RenderStateShard.DepthTestStateShard("<=", 515)).createCompositeState(true);
        return RenderType.create((String)"controller_area", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
    }

    private void renderFaces(PoseStack stack, MultiBufferSource renderTypeBuffer, AABB pos, double x, double y, double z, float red, float green, float blue, float alpha) {
        float x1 = (float)(pos.minX + x);
        float x2 = (float)(pos.maxX + x);
        float y1 = (float)(pos.minY + y);
        float y2 = (float)(pos.maxY + y);
        float z1 = (float)(pos.minZ + z);
        float z2 = (float)(pos.maxZ + z);
        Matrix4f matrix = stack.last().pose();
        VertexConsumer buffer = renderTypeBuffer.getBuffer(AREA_TYPE);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
    }
}

