/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client;

import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.client.DrawerRenderer;
import com.buuz135.functionalstorage.client.FunctionalStorageClientConfig;
import com.buuz135.functionalstorage.util.MathUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Vector3f;

public abstract class BaseDrawerRenderer<T extends ControllableDrawerTile<T>>
implements BlockEntityRenderer<T> {
    public final void render(T tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (Minecraft.getInstance().player != null && !tile.getBlockPos().closerThan((Vec3i)Minecraft.getInstance().player.getOnPos(), (double)FunctionalStorageClientConfig.DRAWER_RENDER_RANGE)) {
            return;
        }
        matrixStack.pushPose();
        Direction facing = tile.getFacingDirection();
        matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        if (facing == Direction.NORTH) {
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f), 1.0f));
        } else if (facing == Direction.EAST) {
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(0.0f, -90.0f, 0.0f), 1.0f));
        } else if (facing == Direction.SOUTH) {
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        } else if (facing == Direction.WEST) {
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 90.0f, 0.0f), 1.0f));
        }
        matrixStack.translate(0.0, 0.0, -0.03125);
        combinedLightIn = LevelRenderer.getLightColor((BlockAndTintGetter)tile.getLevel(), (BlockPos)tile.getBlockPos().relative(facing));
        DrawerRenderer.renderUpgrades(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        this.renderItems(tile, partialTicks, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    public abstract void renderItems(T var1, float var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);
}

