/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.StorageControllerBlock;
import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.fluid.ControllerFluidHandler;
import com.buuz135.functionalstorage.inventory.ControllerInventoryHandler;
import com.buuz135.functionalstorage.inventory.ILockable;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.buuz135.functionalstorage.util.ConnectedDrawers;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class StorageControllerTile<T extends StorageControllerTile<T>>
extends ItemControllableDrawerTile<T> {
    protected static HashMap<UUID, Long> INTERACTION_LOGGER = new HashMap();
    @Save
    protected ConnectedDrawers connectedDrawers = new ConnectedDrawers(null, this);
    public ControllerInventoryHandler inventoryHandler = new ControllerInventoryHandler(){

        @Override
        public ConnectedDrawers getDrawers() {
            return StorageControllerTile.this.connectedDrawers;
        }
    };
    public ControllerFluidHandler fluidHandler = new ControllerFluidHandler(){

        @Override
        public ConnectedDrawers getDrawers() {
            return StorageControllerTile.this.connectedDrawers;
        }
    };

    public StorageControllerTile(BasicTileBlock<T> base, BlockEntityType<T> entityType, BlockPos pos, BlockState state) {
        super(base, entityType, pos, state);
    }

    @Override
    public int getStorageSlotAmount() {
        return 4;
    }

    @Override
    public double getStorageDiv() {
        return FunctionalStorageConfig.RANGE_DIVISOR;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (this.connectedDrawers.getConnectedDrawers().size() != this.connectedDrawers.getItemHandlers().size() + this.connectedDrawers.getFluidHandlers().size() + this.connectedDrawers.getExtensions()) {
            this.connectedDrawers.getConnectedDrawers().removeIf(aLong -> !(this.getLevel().getBlockEntity(BlockPos.of((long)aLong)) instanceof ControllableDrawerTile));
            this.connectedDrawers.setLevel(this.getLevel());
            this.connectedDrawers.rebuild();
            this.markForUpdate();
            this.updateNeigh();
        }
    }

    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (stack.getItem().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.getItem().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (this.isServer()) {
            int slot;
            if (playerIn.isCrouching()) {
                this.openGui(playerIn);
            } else {
                playerIn.displayClientMessage((Component)Component.translatable((String)"gui.functionalstorage.open_gui").withStyle(ChatFormatting.GRAY), true);
            }
            for (IItemHandler iItemHandler : this.connectedDrawers.getItemHandlers()) {
                if (!(iItemHandler instanceof ILockable) || !((ILockable)iItemHandler).isLocked()) continue;
                for (slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                    if (!stack.isEmpty() && iItemHandler.insertItem(slot, stack, true).getCount() != stack.getCount()) {
                        playerIn.setItemInHand(hand, iItemHandler.insertItem(slot, stack, false));
                        return InteractionResult.SUCCESS;
                    }
                    if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault(playerIn.getUUID(), System.currentTimeMillis()) >= 300L) continue;
                    for (ItemStack itemStack : playerIn.getInventory().items) {
                        if (itemStack.isEmpty() || iItemHandler.insertItem(slot, itemStack, true).getCount() == itemStack.getCount()) continue;
                        itemStack.setCount(iItemHandler.insertItem(slot, itemStack.copy(), false).getCount());
                    }
                }
            }
            for (IItemHandler iItemHandler : this.connectedDrawers.getItemHandlers()) {
                if (!(iItemHandler instanceof ILockable) || ((ILockable)iItemHandler).isLocked()) continue;
                for (slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                    if (!stack.isEmpty() && !iItemHandler.getStackInSlot(slot).isEmpty() && iItemHandler.insertItem(slot, stack, true).getCount() != stack.getCount()) {
                        playerIn.setItemInHand(hand, iItemHandler.insertItem(slot, stack, false));
                        return InteractionResult.SUCCESS;
                    }
                    if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault(playerIn.getUUID(), System.currentTimeMillis()) >= 300L) continue;
                    for (ItemStack itemStack : playerIn.getInventory().items) {
                        if (itemStack.isEmpty() || iItemHandler.getStackInSlot(slot).isEmpty() || iItemHandler.insertItem(slot, itemStack, true).getCount() == itemStack.getCount()) continue;
                        itemStack.setCount(iItemHandler.insertItem(slot, itemStack.copy(), false).getCount());
                    }
                }
            }
            INTERACTION_LOGGER.put(playerIn.getUUID(), System.currentTimeMillis());
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        if (this.getStorageSlotAmount() > 0) {
            this.addGuiAddonFactory(() -> new TextScreenAddon(this, "gui.functionalstorage.storage_range", 10, 59, false, ChatFormatting.DARK_GRAY.getColor()){

                public String getText() {
                    return Component.translatable((String)"gui.functionalstorage.storage_range").getString();
                }
            });
        }
        this.addGuiAddonFactory(() -> new TextScreenAddon(this, "key.categories.inventory", 8, 92, false, ChatFormatting.DARK_GRAY.getColor()){

            public String getText() {
                return Component.translatable((String)"key.categories.inventory").getString();
            }
        });
    }

    @Override
    public IItemHandler getStorage() {
        return this.inventoryHandler;
    }

    @Override
    public int getBaseSize(int lost) {
        return 1;
    }

    @Override
    public void toggleLocking() {
        super.toggleLocking();
        if (this.isServer()) {
            for (Long connectedDrawer : new ArrayList<Long>(this.connectedDrawers.getConnectedDrawers())) {
                BlockEntity blockEntity = this.level.getBlockEntity(BlockPos.of((long)connectedDrawer));
                if (blockEntity instanceof StorageControllerTile || !(blockEntity instanceof ControllableDrawerTile)) continue;
                ((ControllableDrawerTile)blockEntity).setLocked(this.isLocked());
            }
        }
    }

    @Override
    public void toggleOption(ConfigurationToolItem.ConfigurationAction action) {
        super.toggleOption(action);
        if (this.isServer()) {
            for (Long connectedDrawer : new ArrayList<Long>(this.connectedDrawers.getConnectedDrawers())) {
                BlockEntity blockEntity = this.level.getBlockEntity(BlockPos.of((long)connectedDrawer));
                if (blockEntity instanceof StorageControllerTile || !(blockEntity instanceof ControllableDrawerTile)) continue;
                if (action.getMax() == 1) {
                    ((ControllableDrawerTile)blockEntity).getDrawerOptions().setActive(action, this.getDrawerOptions().isActive(action));
                } else {
                    ((ControllableDrawerTile)blockEntity).getDrawerOptions().setAdvancedValue(action, this.getDrawerOptions().getAdvancedValue(action));
                }
                ((ControllableDrawerTile)blockEntity).markForUpdate();
            }
        }
    }

    public ConnectedDrawers getConnectedDrawers() {
        return this.connectedDrawers;
    }

    @Override
    public int getUtilitySlotAmount() {
        return 0;
    }

    public boolean addConnectedDrawers(LinkingToolItem.ActionMode action, BlockPos ... positions) {
        int extraRange = this.getStorageMultiplier();
        if (extraRange == 1) {
            extraRange = 0;
        }
        boolean didWork = false;
        AABB area = new AABB(this.getBlockPos()).inflate((double)(FunctionalStorageConfig.DRAWER_CONTROLLER_LINKING_RANGE + extraRange));
        for (BlockPos position : positions) {
            BlockEntity blockEntity;
            if (this.level.getBlockState(position).getBlock() instanceof StorageControllerBlock) continue;
            if (area.contains(Vec3.atCenterOf((Vec3i)position)) && (blockEntity = this.getLevel().getBlockEntity(position)) instanceof ControllableDrawerTile) {
                ControllableDrawerTile controllableDrawerTile2 = (ControllableDrawerTile)blockEntity;
                if (action == LinkingToolItem.ActionMode.ADD) {
                    controllableDrawerTile2.setControllerPos(this.getBlockPos());
                    if (!this.connectedDrawers.getConnectedDrawers().contains(position.asLong())) {
                        this.connectedDrawers.getConnectedDrawers().add(position.asLong());
                        didWork = true;
                    }
                }
            }
            if (action != LinkingToolItem.ActionMode.REMOVE) continue;
            this.connectedDrawers.getConnectedDrawers().removeIf(aLong -> aLong.longValue() == position.asLong());
            TileUtil.getTileEntity((BlockGetter)this.level, (BlockPos)position, ControllableDrawerTile.class).ifPresent(controllableDrawerTile -> controllableDrawerTile.clearControllerPos());
            didWork = true;
        }
        this.connectedDrawers.rebuild();
        this.markForUpdate();
        return didWork;
    }

    @Override
    public InventoryComponent<ControllableDrawerTile<T>> getStorageUpgradesConstructor() {
        return new InventoryComponent("storage_upgrades", 10, 70, this.getStorageSlotAmount()).setInputFilter((stack, integer) -> {
            if (stack.getItem().equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) {
                for (int i = 0; i < this.getStorage().getSlots(); ++i) {
                    if (this.getStorage().getStackInSlot(i).getCount() <= 64) continue;
                    return false;
                }
            }
            return stack.getItem() instanceof UpgradeItem && ((UpgradeItem)stack.getItem()).getType() == UpgradeItem.Type.STORAGE;
        }).setOnSlotChanged((stack, integer) -> {
            this.setNeedsUpgradeCache(true);
            this.connectedDrawers.rebuild();
            this.connectedDrawers.rebuildShapes();
            this.markForUpdate();
        }).setSlotLimit(1);
    }
}

