/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.RayTraceUtils;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemControllableDrawerTile<T extends ItemControllableDrawerTile<T>>
extends ControllableDrawerTile<T> {
    private static HashMap<UUID, Long> INTERACTION_LOGGER = new HashMap();
    private int removeTicks = 0;

    public ItemControllableDrawerTile(BasicTileBlock<T> base, BlockEntityType<T> entityType, BlockPos pos, BlockState state) {
        super(base, entityType, pos, state);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        this.removeTicks = Math.max(this.removeTicks - 1, 0);
        if (level.getGameTime() % (long)FunctionalStorageConfig.UPGRADE_TICK == 0L && this.getUtilitySlotAmount() > 0) {
            block0: for (int i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
                ItemStack pulledStack;
                Direction direction;
                ItemStack stack = this.getUtilityUpgrades().getStackInSlot(i);
                if (stack.isEmpty()) continue;
                Item item = stack.getItem();
                if (item.equals(FunctionalStorage.PULLING_UPGRADE.get())) {
                    direction = UpgradeItem.getDirection(stack);
                    IItemHandler iItemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite());
                    if (iItemHandler == null) continue;
                    for (int otherSlot = 0; otherSlot < iItemHandler.getSlots(); ++otherSlot) {
                        pulledStack = iItemHandler.extractItem(otherSlot, FunctionalStorageConfig.UPGRADE_PULL_ITEMS, true);
                        if (pulledStack.isEmpty()) continue;
                        boolean hasWorked = false;
                        for (int ourSlot = 0; ourSlot < this.getStorage().getSlots(); ++ourSlot) {
                            ItemStack simulated = this.getStorage().insertItem(ourSlot, pulledStack, true);
                            if (simulated.equals(pulledStack)) continue;
                            ItemStack extracted = iItemHandler.extractItem(otherSlot, pulledStack.getCount() - simulated.getCount(), false);
                            this.getStorage().insertItem(ourSlot, extracted, false);
                            hasWorked = true;
                            break;
                        }
                        if (hasWorked) continue block0;
                    }
                    continue;
                }
                if (item.equals(FunctionalStorage.PUSHING_UPGRADE.get())) {
                    direction = UpgradeItem.getDirection(stack);
                    IItemHandler otherHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite());
                    if (otherHandler == null) continue;
                    for (int drawerSlot = 0; drawerSlot < this.getStorage().getSlots(); ++drawerSlot) {
                        pulledStack = this.getStorage().extractItem(drawerSlot, FunctionalStorageConfig.UPGRADE_PUSH_ITEMS, true);
                        if (pulledStack.isEmpty()) continue;
                        boolean hasWorked = false;
                        for (int destinationSlot = 0; destinationSlot < otherHandler.getSlots(); ++destinationSlot) {
                            ItemStack simulated;
                            if (otherHandler.getStackInSlot(destinationSlot).getCount() >= otherHandler.getSlotLimit(destinationSlot) || (simulated = otherHandler.insertItem(destinationSlot, pulledStack, true)).getCount() > pulledStack.getCount()) continue;
                            otherHandler.insertItem(destinationSlot, this.getStorage().extractItem(drawerSlot, pulledStack.getCount() - simulated.getCount(), false), false);
                            hasWorked = true;
                            break;
                        }
                        if (hasWorked) continue block0;
                    }
                    continue;
                }
                if (!item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get())) continue;
                direction = UpgradeItem.getDirection(stack);
                AABB box = new AABB(pos.relative(direction));
                for (ItemEntity entitiesOfClass : level.getEntitiesOfClass(ItemEntity.class, box)) {
                    ItemStack pulledStack2 = entitiesOfClass.getItem().copyWithCount(Math.min(entitiesOfClass.getItem().getCount(), FunctionalStorageConfig.UPGRADE_COLLECTOR_ITEMS));
                    if (pulledStack2.isEmpty()) continue;
                    boolean hasWorked = false;
                    for (int ourSlot = 0; ourSlot < this.getStorage().getSlots(); ++ourSlot) {
                        ItemStack simulated = this.getStorage().insertItem(ourSlot, pulledStack2, true);
                        if (simulated.getCount() == pulledStack2.getCount()) continue;
                        this.getStorage().insertItem(ourSlot, entitiesOfClass.getItem().copyWithCount(pulledStack2.getCount() - simulated.getCount()), false);
                        entitiesOfClass.getItem().shrink(pulledStack2.getCount() - simulated.getCount());
                        hasWorked = true;
                        break;
                    }
                    if (!hasWorked) continue;
                    continue block0;
                }
            }
        }
    }

    @Override
    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ItemInteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (slot != -1 && this.isServer()) {
            if (!stack.isEmpty() && this.getStorage().insertItem(slot, stack, true).getCount() != stack.getCount()) {
                playerIn.setItemInHand(hand, this.getStorage().insertItem(slot, stack, false));
                return InteractionResult.SUCCESS;
            }
            if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault(playerIn.getUUID(), System.currentTimeMillis()) < 300L) {
                for (ItemStack itemStack : playerIn.getInventory().items) {
                    if (itemStack.isEmpty() || this.getStorage().insertItem(slot, itemStack, true).getCount() == itemStack.getCount()) continue;
                    itemStack.setCount(this.getStorage().insertItem(slot, itemStack.copy(), false).getCount());
                }
            }
            INTERACTION_LOGGER.put(playerIn.getUUID(), System.currentTimeMillis());
        }
        if (super.onSlotActivated(playerIn, hand, facing, hitX, hitY, hitZ, slot) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public abstract int getStorageSlotAmount();

    @Override
    public void onClicked(Player playerIn, int slot) {
        if (this.isServer() && slot != -1 && this.removeTicks == 0) {
            BlockHitResult blockResult;
            Direction facing;
            this.removeTicks = 3;
            HitResult rayTraceResult = RayTraceUtils.rayTraceSimple((Level)this.level, (LivingEntity)playerIn, (double)16.0, (float)0.0f);
            if (rayTraceResult.getType() == HitResult.Type.BLOCK && (facing = (blockResult = (BlockHitResult)rayTraceResult).getDirection()).equals((Object)this.getFacingDirection())) {
                ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)this.getStorage().extractItem(slot, playerIn.isShiftKeyDown() ? this.getStorage().getStackInSlot(slot).getMaxStackSize() : 1, false));
            }
        }
    }

    public abstract IItemHandler getStorage();

    @Override
    public abstract int getBaseSize(int var1);

    @Override
    public InventoryComponent<ControllableDrawerTile<T>> getStorageUpgradesConstructor() {
        return new InventoryComponent<ControllableDrawerTile<T>>("storage_upgrades", 10, 70, this.getStorageSlotAmount()){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack stack = this.getStackInSlot(slot);
                if (stack.getItem() instanceof StorageUpgradeItem) {
                    int i;
                    int mult = 1;
                    for (i = 0; i < ItemControllableDrawerTile.this.getStorageUpgrades().getSlots(); ++i) {
                        if (!(ItemControllableDrawerTile.this.getStorageUpgrades().getStackInSlot(i).getItem() instanceof StorageUpgradeItem) || i == slot) continue;
                        if (mult == 1) {
                            mult = ((StorageUpgradeItem)ItemControllableDrawerTile.this.getStorageUpgrades().getStackInSlot(i).getItem()).getStorageMultiplier();
                            continue;
                        }
                        mult *= ((StorageUpgradeItem)ItemControllableDrawerTile.this.getStorageUpgrades().getStackInSlot(i).getItem()).getStorageMultiplier();
                    }
                    for (i = 0; i < ItemControllableDrawerTile.this.getStorage().getSlots(); ++i) {
                        if (ItemControllableDrawerTile.this.getStorage().getStackInSlot(i).isEmpty()) continue;
                        double stackSize = (double)ItemControllableDrawerTile.this.getStorage().getStackInSlot(i).getMaxStackSize() / 64.0;
                        if ((int)Math.floor((double)Math.min(Integer.MAX_VALUE, (long)ItemControllableDrawerTile.this.getBaseSize(i) * (long)mult) * stackSize) >= ItemControllableDrawerTile.this.getStorage().getStackInSlot(i).getCount()) continue;
                        return ItemStack.EMPTY;
                    }
                }
                return super.extractItem(slot, amount, simulate);
            }
        }.setInputFilter((stack, integer) -> {
            if (stack.getItem().equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) {
                for (int i = 0; i < this.getStorage().getSlots(); ++i) {
                    if (this.getStorage().getStackInSlot(i).getCount() <= 64) continue;
                    return false;
                }
            }
            return stack.getItem() instanceof UpgradeItem && ((UpgradeItem)stack.getItem()).getType() == UpgradeItem.Type.STORAGE;
        }).setOnSlotChanged((stack, integer) -> this.setNeedsUpgradeCache(true)).setSlotLimit(1);
    }

    @Override
    public boolean isEverythingEmpty() {
        int i;
        for (i = 0; i < this.getStorage().getSlots(); ++i) {
            if (this.getStorage().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        for (i = 0; i < this.getStorageUpgrades().getSlots(); ++i) {
            if (this.getStorageUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        for (i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
            if (this.getUtilityUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isInventoryEmpty() {
        for (int i = 0; i < this.getStorage().getSlots(); ++i) {
            if (this.getStorage().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTitleColor() {
        return ChatFormatting.DARK_GRAY.getColor();
    }

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return this.getStorage();
    }
}

