/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.client.gui.FluidDrawerInfoGuiAddon;
import com.buuz135.functionalstorage.fluid.BigFluidHandler;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.buuz135.functionalstorage.util.Utils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.mojang.authlib.GameProfile;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidDrawerTile
extends ControllableDrawerTile<FluidDrawerTile> {
    public static final GameProfile FP = new GameProfile(UUID.nameUUIDFromBytes("FunctionalStorage-Pickup".getBytes(StandardCharsets.UTF_8)), "FunctionalStorage-Pickp");
    @Save
    public BigFluidHandler fluidHandler;
    private final FunctionalStorage.DrawerType type;

    public FluidDrawerTile(BasicTileBlock<FluidDrawerTile> base, BlockEntityType<FluidDrawerTile> blockEntityType, BlockPos pos, BlockState state, FunctionalStorage.DrawerType type) {
        super(base, blockEntityType, pos, state);
        this.type = type;
        this.fluidHandler = new BigFluidHandler(type.getSlots(), this.getTankCapacity(this.getStorageMultiplier())){

            @Override
            public void onChange() {
                FluidDrawerTile.this.syncObject(FluidDrawerTile.this.fluidHandler);
            }

            @Override
            public boolean isDrawerLocked() {
                return FluidDrawerTile.this.isLocked();
            }

            @Override
            public boolean isDrawerVoid() {
                return FluidDrawerTile.this.isVoid();
            }

            @Override
            public boolean isDrawerCreative() {
                return FluidDrawerTile.this.isCreative();
            }
        };
    }

    private int getTankCapacity(int storageMultiplier) {
        long maxCap = (long)(this.type.getSlotAmount() / 64) * 1000L * (long)storageMultiplier;
        return (int)Math.min(Integer.MAX_VALUE, maxCap);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        String slotName = "";
        if (this.type.getSlots() == 2) {
            slotName = "_2";
        }
        if (this.type.getSlots() == 4) {
            slotName = "_4";
        }
        String finalSlotName = slotName;
        this.addGuiAddonFactory(() -> new FluidDrawerInfoGuiAddon(64, 16, Utils.resourceLocation("functionalstorage", "textures/block/fluid_front" + finalSlotName + ".png"), this.type.getSlots(), this.type.getSlotPosition(), this::getFluidHandler, integer -> this.getFluidHandler().getTankCapacity((int)integer)));
    }

    @Override
    public double getStorageDiv() {
        return FunctionalStorageConfig.FLUID_DIVISOR;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState stateOwn, FluidDrawerTile blockEntity) {
        super.serverTick(level, pos, stateOwn, blockEntity);
        if (level.getGameTime() % (long)FunctionalStorageConfig.UPGRADE_TICK == 0L) {
            block0: for (int i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
                FluidStack drained;
                int insertedAmount;
                FluidStack extracted;
                BigFluidHandler.CustomFluidTank fluidTank;
                int tankId;
                Direction direction;
                IFluidHandler otherFluidHandler;
                ItemStack stack = this.getUtilityUpgrades().getStackInSlot(i);
                if (stack.isEmpty()) continue;
                Item item = stack.getItem();
                if (item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) && (otherFluidHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(direction = UpgradeItem.getDirection(stack)), (Object)direction.getOpposite())) != null) {
                    for (tankId = 0; tankId < this.getFluidHandler().getTanks(); ++tankId) {
                        fluidTank = this.fluidHandler.getTankList()[tankId];
                        if (fluidTank.getFluid().isEmpty() || (extracted = fluidTank.drain(FunctionalStorageConfig.UPGRADE_PUSH_FLUID, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || (insertedAmount = otherFluidHandler.fill(extracted, IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                        fluidTank.drain(insertedAmount, IFluidHandler.FluidAction.EXECUTE);
                        this.fluidHandler.onChange();
                        break;
                    }
                }
                if (item.equals(FunctionalStorage.PULLING_UPGRADE.get()) && (otherFluidHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(direction = UpgradeItem.getDirection(stack)), (Object)direction.getOpposite())) != null) {
                    for (tankId = 0; tankId < this.getFluidHandler().getTanks(); ++tankId) {
                        fluidTank = this.fluidHandler.getTankList()[tankId];
                        extracted = otherFluidHandler.drain(FunctionalStorageConfig.UPGRADE_PULL_FLUID, IFluidHandler.FluidAction.SIMULATE);
                        if (extracted.isEmpty() || (insertedAmount = fluidTank.fill(extracted, IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                        otherFluidHandler.drain(insertedAmount, IFluidHandler.FluidAction.EXECUTE);
                        this.fluidHandler.onChange();
                        break;
                    }
                }
                if (!item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get()) || level.getGameTime() % (long)(FunctionalStorageConfig.UPGRADE_TICK * 3) != 0L) continue;
                direction = UpgradeItem.getDirection(stack);
                FluidState fluidstate = this.level.getFluidState(this.getBlockPos().relative(direction));
                if (fluidstate.isEmpty() || !fluidstate.isSource()) continue;
                BlockState state = level.getBlockState(pos.relative(direction));
                Block block = state.getBlock();
                BucketPickupHandlerWrapper targetFluidHandler = null;
                if (block instanceof BucketPickup) {
                    targetFluidHandler = new BucketPickupHandlerWrapper((Player)FakePlayerFactory.get((ServerLevel)((ServerLevel)level), (GameProfile)FP), (BucketPickup)block, level, pos.relative(direction));
                }
                if (targetFluidHandler == null || (drained = targetFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) continue;
                for (int tankId2 = 0; tankId2 < this.getFluidHandler().getTanks(); ++tankId2) {
                    BigFluidHandler.CustomFluidTank fluidTank2 = this.fluidHandler.getTankList()[tankId2];
                    int insertedAmount2 = fluidTank2.fill(drained, IFluidHandler.FluidAction.SIMULATE);
                    if (insertedAmount2 != drained.getAmount()) continue;
                    fluidTank2.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                    if (!fluidstate.getType().canConvertToSource(fluidstate, level, this.getBlockPos().relative(direction))) {
                        targetFluidHandler.drain(insertedAmount2, IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.fluidHandler.onChange();
                    continue block0;
                }
            }
        }
    }

    @Override
    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        InteractionResult interactionResult;
        ItemStack stack = playerIn.getItemInHand(hand);
        if (stack.getItem().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.getItem().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (slot != -1 && !playerIn.getItemInHand(hand).isEmpty() && (interactionResult = Optional.ofNullable((IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)).map(iFluidHandlerItem -> Optional.ofNullable((IItemHandler)playerIn.getCapability(Capabilities.ItemHandler.ENTITY)).map(iItemHandler -> {
            FluidActionResult result = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)this.fluidHandler.getTankList()[slot], (IItemHandler)iItemHandler, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true);
            if (result.isSuccess()) {
                playerIn.setItemInHand(hand, result.getResult().copy());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS)).orElse(InteractionResult.PASS)) == InteractionResult.SUCCESS) {
            return interactionResult;
        }
        return super.onSlotActivated(playerIn, hand, facing, hitX, hitY, hitZ, slot);
    }

    @Override
    public void onClicked(Player playerIn, int slot) {
        ItemStack stack = playerIn.getItemInHand(InteractionHand.MAIN_HAND);
        if (slot != -1 && !stack.isEmpty()) {
            Optional.ofNullable((IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)).ifPresent(iFluidHandlerItem -> Optional.ofNullable((IItemHandler)playerIn.getCapability(Capabilities.ItemHandler.ENTITY)).ifPresent(iItemHandler -> {
                FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)this.fluidHandler.getTankList()[slot], (IItemHandler)iItemHandler, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true);
                if (result.isSuccess()) {
                    playerIn.setItemInHand(InteractionHand.MAIN_HAND, result.getResult());
                }
            }));
        }
    }

    @NotNull
    public FluidDrawerTile getSelf() {
        return this;
    }

    public FunctionalStorage.DrawerType getDrawerType() {
        return this.type;
    }

    @Override
    public int getStorageSlotAmount() {
        return 4;
    }

    @Override
    public int getBaseSize(int lost) {
        return this.type.getSlotAmount();
    }

    public BigFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        this.fluidHandler.lockHandler();
        this.syncObject(this.fluidHandler);
    }

    @Override
    public boolean isEverythingEmpty() {
        int i;
        for (i = 0; i < this.getFluidHandler().getTanks(); ++i) {
            if (this.getFluidHandler().getFluidInTank(i).isEmpty()) continue;
            return false;
        }
        if (this.isLocked()) {
            return false;
        }
        for (i = 0; i < this.getStorageUpgrades().getSlots(); ++i) {
            if (this.getStorageUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        for (i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
            if (this.getUtilityUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isInventoryEmpty() {
        for (int i = 0; i < this.getFluidHandler().getTanks(); ++i) {
            if (this.getFluidHandler().getFluidInTank(i).isEmpty()) continue;
            return false;
        }
        return false;
    }

    @Override
    public InventoryComponent<ControllableDrawerTile<FluidDrawerTile>> getStorageUpgradesConstructor() {
        return new InventoryComponent<ControllableDrawerTile<FluidDrawerTile>>("storage_upgrades", 10, 70, this.getStorageSlotAmount()){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack stack = this.getStackInSlot(slot);
                if (stack.getItem() instanceof StorageUpgradeItem) {
                    int i;
                    int mult = 1;
                    for (i = 0; i < FluidDrawerTile.this.getStorageUpgrades().getSlots(); ++i) {
                        if (!(FluidDrawerTile.this.getStorageUpgrades().getStackInSlot(i).getItem() instanceof StorageUpgradeItem) || i == slot) continue;
                        double calculated = (double)((StorageUpgradeItem)FluidDrawerTile.this.getStorageUpgrades().getStackInSlot(i).getItem()).getStorageMultiplier() / FluidDrawerTile.this.getStorageDiv();
                        mult = mult == 1 ? (int)calculated : (int)((double)mult * calculated);
                    }
                    for (i = 0; i < FluidDrawerTile.this.getFluidHandler().getTanks(); ++i) {
                        if (FluidDrawerTile.this.getFluidHandler().getFluidInTank(i).isEmpty() || FluidDrawerTile.this.getFluidHandler().getFluidInTank(i).getAmount() <= FluidDrawerTile.this.getTankCapacity(mult)) continue;
                        return ItemStack.EMPTY;
                    }
                }
                return super.extractItem(slot, amount, simulate);
            }
        }.setInputFilter((stack, integer) -> {
            if (stack.getItem().equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) {
                return false;
            }
            return stack.getItem() instanceof UpgradeItem && ((UpgradeItem)stack.getItem()).getType() == UpgradeItem.Type.STORAGE;
        }).setOnSlotChanged((stack, integer) -> {
            this.setNeedsUpgradeCache(true);
            this.fluidHandler.setCapacity(this.getTankCapacity(this.getStorageMultiplier()));
            this.syncObject(this.fluidHandler);
        }).setSlotLimit(1);
    }

    public IFluidHandler getFluidHandler(@Nullable Direction direction) {
        return this.fluidHandler;
    }
}

