/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.CompactingFramedDrawerTile;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.client.gui.DrawerInfoGuiAddon;
import com.buuz135.functionalstorage.inventory.CompactingInventoryHandler;
import com.buuz135.functionalstorage.util.CompactingUtil;
import com.buuz135.functionalstorage.util.Utils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class CompactingDrawerTile
extends ItemControllableDrawerTile<CompactingDrawerTile> {
    @Save
    public CompactingInventoryHandler handler = new CompactingInventoryHandler(3){

        @Override
        public void onChange() {
            CompactingDrawerTile.this.markForUpdate();
        }

        @Override
        public int getMultiplier() {
            return CompactingDrawerTile.this.getStorageMultiplier();
        }

        @Override
        public boolean isVoid() {
            return CompactingDrawerTile.this.isVoid();
        }

        @Override
        public boolean hasDowngrade() {
            return CompactingDrawerTile.this.hasDowngrade();
        }

        @Override
        public boolean isCreative() {
            return CompactingDrawerTile.this.isCreative();
        }

        @Override
        public boolean isLocked() {
            return CompactingDrawerTile.this.isLocked();
        }
    };
    private boolean hasCheckedRecipes = false;

    public CompactingDrawerTile(BasicTileBlock<CompactingDrawerTile> base, BlockEntityType<CompactingDrawerTile> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new DrawerInfoGuiAddon(64, 16, Utils.resourceLocation("functionalstorage", this instanceof CompactingFramedDrawerTile ? "textures/block/framed_front_compacting.png" : "textures/block/compacting_drawer_front.png"), 3, integer -> {
            if (integer == 0) {
                return Pair.of((Object)28, (Object)28);
            }
            if (integer == 1) {
                return Pair.of((Object)4, (Object)28);
            }
            return Pair.of((Object)16, (Object)4);
        }, integer -> this.getStorage().getStackInSlot(integer.intValue()), integer -> this.getStorage().getSlotLimit(integer.intValue())));
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, CompactingDrawerTile blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (!this.hasCheckedRecipes) {
            if (!this.handler.getParent().isEmpty()) {
                CompactingUtil compactingUtil = new CompactingUtil(this.level, 3);
                compactingUtil.setup(this.handler.getParent());
                this.handler.setup(compactingUtil);
            }
            this.hasCheckedRecipes = true;
        }
    }

    @Override
    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (stack.getItem().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.getItem().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (!this.handler.isSetup() && slot != -1 && this.isServer()) {
            stack = playerIn.getItemInHand(hand).copy();
            stack.setCount(1);
            CompactingUtil compactingUtil = new CompactingUtil(this.level, 3);
            compactingUtil.setup(stack);
            this.handler.setup(compactingUtil);
            for (int i = 0; i < this.handler.getResultList().size(); ++i) {
                if (!ItemStack.isSameItem((ItemStack)this.handler.getResultList().get(i).getResult(), (ItemStack)stack)) continue;
                slot = i;
                break;
            }
            this.markForUpdate();
        }
        return super.onSlotActivated(playerIn, hand, facing, hitX, hitY, hitZ, slot);
    }

    @Override
    public int getStorageSlotAmount() {
        return 3;
    }

    @Override
    public IItemHandler getStorage() {
        return this.handler;
    }

    @Override
    public int getBaseSize(int slot) {
        return this.handler.getSlotLimitBase(slot);
    }

    @NotNull
    public CompactingDrawerTile getSelf() {
        return this;
    }

    public CompactingInventoryHandler getHandler() {
        return this.handler;
    }
}

