/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.container.BasicContainer;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.apis.TurtleAPI;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.inventory.TurtleMenu;
import java.util.Collections;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TurtleBlockEntity
extends AbstractComputerBlockEntity
implements BasicContainer {
    public static final int INVENTORY_SIZE = 16;
    public static final int INVENTORY_WIDTH = 4;
    public static final int INVENTORY_HEIGHT = 4;
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)16, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> inventorySnapshot = NonNullList.withSize((int)16, (Object)ItemStack.EMPTY);
    private boolean inventoryChanged = false;
    private final IntSupplier fuelLimit;
    private TurtleBrain brain = new TurtleBrain(this);
    private MoveState moveState = MoveState.NOT_MOVED;
    @Nullable
    private IPeripheral peripheral;

    public TurtleBlockEntity(BlockEntityType<? extends TurtleBlockEntity> type, BlockPos pos, BlockState state, IntSupplier fuelLimit, ComputerFamily family) {
        super(type, pos, state, family);
        this.fuelLimit = fuelLimit;
    }

    boolean hasMoved() {
        return this.moveState == MoveState.MOVED;
    }

    @Override
    protected ServerComputer createComputer(int id) {
        ServerComputer computer = new ServerComputer((ServerLevel)this.getLevel(), this.getBlockPos(), id, this.label, this.getFamily(), 39, 13);
        computer.addAPI(new TurtleAPI(computer, this.brain));
        this.brain.setupComputer(computer);
        return computer;
    }

    @Override
    protected void unload() {
        if (!this.hasMoved()) {
            super.unload();
        }
    }

    @Override
    protected float getInteractRange() {
        return 8.0f;
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        this.brain.update();
        if (this.inventoryChanged) {
            ServerComputer computer = this.getServerComputer();
            if (computer != null) {
                computer.queueEvent("turtle_inventory");
            }
            this.inventoryChanged = false;
        }
    }

    protected void clientTick() {
        this.brain.update();
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
    }

    @Override
    public void neighborChanged(BlockPos neighbour) {
        if (this.moveState == MoveState.NOT_MOVED) {
            super.neighborChanged(neighbour);
        }
    }

    public void notifyMoveStart() {
        if (this.moveState == MoveState.NOT_MOVED) {
            this.moveState = MoveState.IN_PROGRESS;
        }
    }

    public void notifyMoveEnd() {
        if (this.moveState == MoveState.IN_PROGRESS) {
            this.moveState = MoveState.NOT_MOVED;
        }
    }

    @Override
    public void loadServer(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadServer(nbt, registries);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registries);
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventorySnapshot.set(i, (Object)((ItemStack)this.inventory.get(i)).copy());
        }
        this.brain.readFromNBT(nbt, registries);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registries);
        this.brain.writeToNBT(nbt, registries);
        super.saveAdditional(nbt, registries);
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput component) {
        super.applyImplicitComponents(component);
        DyedItemColor colour = (DyedItemColor)component.get(DataComponents.DYED_COLOR);
        if (colour != null) {
            this.brain.setColour(colour.rgb());
        }
        this.brain.setFuelLevel((Integer)component.getOrDefault((DataComponentType)ModRegistry.DataComponents.FUEL.get(), (Object)0));
        this.brain.setOverlay((Holder<TurtleOverlay>)((Holder)component.get((DataComponentType)ModRegistry.DataComponents.OVERLAY.get())));
        this.brain.setUpgrade(TurtleSide.LEFT, (UpgradeData)component.get((DataComponentType)ModRegistry.DataComponents.LEFT_TURTLE_UPGRADE.get()));
        this.brain.setUpgrade(TurtleSide.RIGHT, (UpgradeData)component.get((DataComponentType)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get()));
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.DYED_COLOR, (Object)(this.brain.getColour() == -1 ? null : new DyedItemColor(this.brain.getColour(), false)));
        builder.set((DataComponentType)ModRegistry.DataComponents.OVERLAY.get(), this.brain.getOverlay());
        builder.set((DataComponentType)ModRegistry.DataComponents.FUEL.get(), (Object)this.brain.getFuelLevel());
        builder.set((DataComponentType)ModRegistry.DataComponents.LEFT_TURTLE_UPGRADE.get(), TurtleBlockEntity.withPersistedData(this.brain.getUpgradeWithData(TurtleSide.LEFT)));
        builder.set((DataComponentType)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), TurtleBlockEntity.withPersistedData(this.brain.getUpgradeWithData(TurtleSide.RIGHT)));
    }

    @Nullable
    private static UpgradeData<ITurtleUpgrade> withPersistedData(@Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        return upgrade == null ? null : UpgradeData.of(upgrade.holder(), upgrade.upgrade().getPersistedData(upgrade.data()));
    }

    @Override
    @Deprecated
    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("Color");
        tag.remove("Fuel");
        tag.remove("Overlay");
        tag.remove("LeftUpgrade");
        tag.remove("RightUpgrade");
    }

    @Override
    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return this.hasPeripheralUpgradeOnSide(localSide);
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)TurtleBlock.FACING);
    }

    public void setDirection(Direction dir) {
        if (dir.getAxis() == Direction.Axis.Y) {
            dir = Direction.NORTH;
        }
        this.getLevel().setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)TurtleBlock.FACING, (Comparable)dir));
        this.updateRedstone();
        this.updateInputsImmediately();
        this.onTileEntityChange();
    }

    @Nullable
    public ITurtleUpgrade getUpgrade(TurtleSide side) {
        return this.brain.getUpgrade(side);
    }

    public int getColour() {
        return this.brain.getColour();
    }

    @Nullable
    public TurtleOverlay getOverlay() {
        Holder<TurtleOverlay> overlay = this.brain.getOverlay();
        return overlay == null ? null : (TurtleOverlay)overlay.value();
    }

    public ITurtleAccess getAccess() {
        return this.brain;
    }

    public Vec3 getRenderOffset(float f) {
        return this.brain.getRenderOffset(f);
    }

    public float getRenderYaw(float f) {
        return this.brain.getVisualYaw(f);
    }

    public float getToolRenderAngle(TurtleSide side, float f) {
        return this.brain.getToolRenderAngle(side, f);
    }

    void setOwningPlayer(GameProfile player) {
        this.brain.setOwningPlayer(player);
        this.onTileEntityChange();
    }

    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public ItemStack getItemSnapshot(int slot) {
        return slot >= 0 && slot < this.inventorySnapshot.size() ? (ItemStack)this.inventorySnapshot.get(slot) : ItemStack.EMPTY;
    }

    public void setChanged() {
        super.setChanged();
        for (int slot = 0; slot < this.getContainerSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (ItemStack.matches((ItemStack)item, (ItemStack)((ItemStack)this.inventorySnapshot.get(slot)))) continue;
            this.inventoryChanged = true;
            this.inventorySnapshot.set(slot, (Object)item.copy());
        }
    }

    public boolean stillValid(Player player) {
        return this.isUsable(player);
    }

    public void onTileEntityChange() {
        super.setChanged();
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.brain.writeDescription(nbt, registries);
        return nbt;
    }

    @Override
    public void loadClient(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadClient(nbt, registries);
        this.brain.readDescription(nbt, registries);
    }

    public int getFuelLimit() {
        return this.fuelLimit.getAsInt();
    }

    private boolean hasPeripheralUpgradeOnSide(ComputerSide side) {
        ITurtleUpgrade upgrade;
        switch (side) {
            case RIGHT: {
                upgrade = this.getUpgrade(TurtleSide.RIGHT);
                break;
            }
            case LEFT: {
                upgrade = this.getUpgrade(TurtleSide.LEFT);
                break;
            }
            default: {
                return false;
            }
        }
        return upgrade != null && upgrade.getUpgradeType().isPeripheral();
    }

    public void transferStateFrom(TurtleBlockEntity copy) {
        super.transferStateFrom(copy);
        Collections.copy(this.inventory, copy.inventory);
        Collections.copy(this.inventorySnapshot, copy.inventorySnapshot);
        this.inventoryChanged = copy.inventoryChanged;
        this.brain = copy.brain;
        this.brain.setOwner(this);
        copy.moveState = MoveState.MOVED;
        PlatformHelper.get().invalidateComponent(this);
    }

    @Nullable
    public IPeripheral peripheral() {
        if (this.hasMoved()) {
            return null;
        }
        if (this.peripheral != null) {
            return this.peripheral;
        }
        this.peripheral = new ComputerPeripheral("turtle", this);
        return this.peripheral;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return TurtleMenu.ofBrain(id, inventory, this.brain);
    }

    static enum MoveState {
        NOT_MOVED,
        IN_PROGRESS,
        MOVED;

    }
}

