/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe;

import dan200.computercraft.shared.recipe.BasicRecipeSerialiser;
import dan200.computercraft.shared.recipe.RecipeProperties;
import dan200.computercraft.shared.recipe.ShapedRecipeSpec;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public abstract class CustomShapedRecipe
extends ShapedRecipe {
    private final ShapedRecipePattern pattern;
    private final ItemStack result;

    public CustomShapedRecipe(ShapedRecipeSpec recipe) {
        super(recipe.properties().group(), recipe.properties().category(), recipe.pattern(), recipe.result(), recipe.properties().showNotification());
        this.pattern = recipe.pattern();
        this.result = recipe.result();
    }

    public final ShapedRecipeSpec toSpec() {
        return new ShapedRecipeSpec(RecipeProperties.of((CraftingRecipe)this), this.pattern, this.result);
    }

    public abstract RecipeSerializer<? extends CustomShapedRecipe> getSerializer();

    public static <T extends CustomShapedRecipe> RecipeSerializer<T> serialiser(Function<ShapedRecipeSpec, T> factory) {
        return new BasicRecipeSerialiser(ShapedRecipeSpec.CODEC.xmap(factory, CustomShapedRecipe::toSpec), ShapedRecipeSpec.STREAM_CODEC.map(factory, CustomShapedRecipe::toSpec));
    }
}

