/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.peripherals;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import dan200.computercraft.shared.peripheral.speaker.UpgradeSpeakerPeripheral;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PocketSpeakerPeripheral
extends UpgradeSpeakerPeripheral {
    private final IPocketAccess access;
    @Nullable
    private Level level;
    private Vec3 position = Vec3.ZERO;

    public PocketSpeakerPeripheral(IPocketAccess access) {
        this.access = access;
    }

    @Override
    public SpeakerPosition getPosition() {
        Entity entity = this.access.getEntity();
        return entity == null ? SpeakerPosition.of(this.level, this.position) : SpeakerPosition.of(entity);
    }

    @Override
    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof PocketSpeakerPeripheral;
    }

    @Override
    public void update() {
        Entity entity = this.access.getEntity();
        if (entity != null) {
            this.level = entity.level();
            this.position = entity.position();
        }
        super.update();
        this.access.setLight(this.madeSound() ? 3350780 : -1);
    }
}

