/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.peripherals;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PocketModemPeripheral
extends WirelessModemPeripheral {
    @Nullable
    private Level level = null;
    private Vec3 position = Vec3.ZERO;

    public PocketModemPeripheral(boolean advanced, IPocketAccess access) {
        super(new ModemState(), advanced);
        this.setLocation(access);
    }

    void setLocation(IPocketAccess access) {
        Entity entity = access.getEntity();
        if (entity != null) {
            this.level = entity.level();
            this.position = entity.getEyePosition(1.0f);
        }
    }

    @Override
    public Level getLevel() {
        if (this.level == null) {
            throw new IllegalStateException("Using modem before position has been defined");
        }
        return this.level;
    }

    @Override
    public Vec3 getPosition() {
        return this.position;
    }

    @Override
    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof PocketModemPeripheral;
    }
}

