/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.items.ServerComputerReference;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.pocket.apis.PocketAPI;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.inventory.PocketComputerMenuProvider;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PocketComputerItem
extends Item
implements IMedia {
    private final ComputerFamily family;

    public PocketComputerItem(Item.Properties settings, ComputerFamily family) {
        super(settings);
        this.family = family;
    }

    private boolean tick(ItemStack stack, Entity entity, PocketServerComputer computer) {
        boolean on;
        IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
        computer.updateValues(entity, stack, upgrade);
        boolean changed = false;
        String label = computer.getLabel();
        if (!Objects.equals(label, this.getLabel(stack))) {
            changed = true;
            this.setLabel(stack, label);
        }
        if ((on = computer.isOn()) != PocketComputerItem.isMarkedOn(stack)) {
            changed = true;
            stack.set((DataComponentType)ModRegistry.DataComponents.ON.get(), (Object)on);
        }
        if (upgrade != null) {
            upgrade.update(computer, computer.getPeripheral(ComputerSide.BACK));
        }
        return changed;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slotNum, boolean selected) {
        Inventory inventory;
        if (world.isClientSide) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            inventory = player.getInventory();
        } else {
            inventory = null;
        }
        Inventory inventory2 = inventory;
        PocketServerComputer computer = this.createServerComputer((ServerLevel)world, entity, (Container)inventory2, stack);
        computer.keepAlive();
        boolean changed = this.tick(stack, entity, computer);
        if (changed && inventory2 != null) {
            inventory2.setChanged();
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level level = entity.level();
        if (level.isClientSide || level.getServer() == null) {
            return false;
        }
        PocketServerComputer computer = PocketComputerItem.getServerComputer(level.getServer(), stack);
        if (computer != null && this.tick(stack, (Entity)entity, computer)) {
            entity.setItem(stack.copy());
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            PocketServerComputer computer = this.createServerComputer((ServerLevel)world, (Entity)player, (Container)player.getInventory(), stack);
            computer.turnOn();
            boolean stop = false;
            IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
            if (upgrade != null) {
                computer.updateValues((Entity)player, stack, upgrade);
                stop = upgrade.onRightClick(world, computer, computer.getPeripheral(ComputerSide.BACK));
            }
            if (!stop) {
                boolean isTypingOnly = hand == InteractionHand.OFF_HAND;
                new ComputerContainerData(computer, stack).open(player, new PocketComputerMenuProvider(computer, stack, this, hand, isTypingOnly));
            }
        }
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)world.isClientSide), (Object)stack);
    }

    public Component getName(ItemStack stack) {
        String baseString = this.getDescriptionId(stack);
        IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
        if (upgrade != null) {
            return Component.translatable((String)(baseString + ".upgraded"), (Object[])new Object[]{upgrade.getAdjective()});
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        NonNegativeId id;
        if ((flag.isAdvanced() || this.getLabel(stack) == null) && (id = (NonNegativeId)stack.get((DataComponentType)ModRegistry.DataComponents.COMPUTER_ID.get())) != null) {
            list.add((Component)Component.translatable((String)"gui.computercraft.tooltip.computer_id", (Object[])new Object[]{id.id()}).withStyle(ChatFormatting.GRAY));
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        UpgradeData<IPocketUpgrade> upgrade = PocketComputerItem.getUpgradeWithData(stack);
        return upgrade != null ? PocketUpgrades.instance().getOwner(upgrade.holder()) : "computercraft";
    }

    public PocketServerComputer createServerComputer(ServerLevel level, Entity entity, @Nullable Container inventory, ItemStack stack) {
        ServerComputerRegistry registry = ServerContext.get(level.getServer()).registry();
        PocketServerComputer computer = (PocketServerComputer)ServerComputerReference.get((DataComponentHolder)stack, registry);
        if (computer == null) {
            int computerID = NonNegativeId.getOrCreate(level.getServer(), stack, (DataComponentType<NonNegativeId>)((DataComponentType)ModRegistry.DataComponents.COMPUTER_ID.get()), "computer");
            computer = new PocketServerComputer(level, entity.blockPosition(), computerID, this.getLabel(stack), this.getFamily());
            UUID instanceId = computer.register();
            stack.set((DataComponentType)ModRegistry.DataComponents.COMPUTER.get(), (Object)new ServerComputerReference(registry.getSessionID(), instanceId));
            IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
            computer.updateValues(entity, stack, upgrade);
            computer.addAPI(new PocketAPI(computer));
            if (PocketComputerItem.isMarkedOn(stack) && entity instanceof Player) {
                computer.turnOn();
            }
            if (inventory != null) {
                inventory.setChanged();
            }
        }
        return computer;
    }

    @Nullable
    public static PocketServerComputer getServerComputer(MinecraftServer server, ItemStack stack) {
        return (PocketServerComputer)ServerComputerReference.get((DataComponentHolder)stack, ServerContext.get(server).registry());
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    @Nullable
    private String getLabel(ItemStack stack) {
        return DataComponentUtil.getCustomName((DataComponentHolder)stack);
    }

    @Override
    @Nullable
    public String getLabel(HolderLookup.Provider registries, ItemStack stack) {
        return this.getLabel(stack);
    }

    @Override
    public boolean setLabel(ItemStack stack, @Nullable String label) {
        DataComponentUtil.setCustomName(stack, label);
        return true;
    }

    @Override
    @Nullable
    public Mount createDataMount(ItemStack stack, ServerLevel level) {
        NonNegativeId id = (NonNegativeId)stack.get((DataComponentType)ModRegistry.DataComponents.COMPUTER_ID.get());
        if (id != null) {
            return ComputerCraftAPI.createSaveDirMount(level.getServer(), "computer/" + id.id(), Config.computerSpaceLimit);
        }
        return null;
    }

    private static boolean isMarkedOn(ItemStack stack) {
        return (Boolean)stack.getOrDefault((DataComponentType)ModRegistry.DataComponents.ON.get(), (Object)false);
    }

    @Nullable
    public static IPocketUpgrade getUpgrade(ItemStack stack) {
        UpgradeData<IPocketUpgrade> upgrade = PocketComputerItem.getUpgradeWithData(stack);
        return upgrade == null ? null : upgrade.upgrade();
    }

    @Nullable
    public static UpgradeData<IPocketUpgrade> getUpgradeWithData(ItemStack stack) {
        return (UpgradeData)stack.get((DataComponentType)ModRegistry.DataComponents.POCKET_UPGRADE.get());
    }

    public static void setUpgrade(ItemStack stack, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        stack.set((DataComponentType)ModRegistry.DataComponents.POCKET_UPGRADE.get(), upgrade);
    }
}

