/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import dan200.computercraft.shared.config.ConfigFile;
import dan200.computercraft.shared.util.Trie;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class ForgeConfigFile
implements ConfigFile {
    private final ModConfigSpec spec;
    private final Trie<String, ConfigFile.Entry> entries;

    public ForgeConfigFile(ModConfigSpec spec, Trie<String, ConfigFile.Entry> entries) {
        this.spec = spec;
        this.entries = entries;
    }

    public ModConfigSpec spec() {
        return this.spec;
    }

    @Override
    public Stream<ConfigFile.Entry> entries() {
        return this.entries.stream();
    }

    @Override
    @Nullable
    public ConfigFile.Entry getEntry(String path) {
        return this.entries.getValue(SPLITTER.split((CharSequence)path));
    }

    private static final class ValueImpl<T>
    implements ConfigFile.Value<T> {
        private final ModConfigSpec.ConfigValue<T> value;
        @Nullable
        private ModConfigSpec owner;

        private ValueImpl(ModConfigSpec.ConfigValue<T> value) {
            this.value = value;
        }

        private ModConfigSpec.ValueSpec spec() {
            if (this.owner == null) {
                throw new IllegalStateException("Config has not been built yet");
            }
            return (ModConfigSpec.ValueSpec)this.owner.getSpec().get(this.value.getPath());
        }

        @Override
        public T get() {
            return (T)this.value.get();
        }

        @Override
        public String translationKey() {
            return this.spec().getTranslationKey();
        }

        @Override
        public String comment() {
            return this.spec().getComment();
        }
    }

    private static final class GroupImpl
    implements ConfigFile.Group {
        private final List<String> path;
        @Nullable
        private ModConfigSpec owner;

        private GroupImpl(List<String> path) {
            this.path = path;
        }

        @Override
        public String translationKey() {
            if (this.owner == null) {
                throw new IllegalStateException("Config has not been built yet");
            }
            return this.owner.getLevelTranslationKey(this.path);
        }

        @Override
        public String comment() {
            if (this.owner == null) {
                throw new IllegalStateException("Config has not been built yet");
            }
            return this.owner.getLevelComment(this.path);
        }
    }

    static class Builder
    extends ConfigFile.Builder {
        private final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        private final Trie<String, ConfigFile.Entry> entries = new Trie();

        Builder() {
        }

        private void translation(String name) {
            this.builder.translation(this.getTranslation(name));
        }

        @Override
        public ConfigFile.Builder comment(String comment) {
            this.builder.comment(comment);
            return this;
        }

        @Override
        public void push(String name) {
            this.translation(name);
            this.builder.push(name);
            super.push(name);
        }

        @Override
        public void pop() {
            ArrayList<String> path = new ArrayList<String>(this.groupStack);
            this.entries.setValue(path, new GroupImpl(path));
            this.builder.pop();
            super.pop();
        }

        @Override
        public ConfigFile.Builder worldRestart() {
            this.builder.worldRestart();
            return this;
        }

        private <T> ConfigFile.Value<T> defineValue(ModConfigSpec.ConfigValue<T> value) {
            ValueImpl<T> wrapped = new ValueImpl<T>(value);
            this.entries.setValue(value.getPath(), wrapped);
            return wrapped;
        }

        @Override
        public <T> ConfigFile.Value<T> define(String path, T defaultValue) {
            this.translation(path);
            return this.defineValue(this.builder.define(path, defaultValue));
        }

        @Override
        public ConfigFile.Value<Boolean> define(String path, boolean defaultValue) {
            this.translation(path);
            return this.defineValue((ModConfigSpec.ConfigValue)this.builder.define(path, defaultValue));
        }

        @Override
        public ConfigFile.Value<Integer> defineInRange(String path, int defaultValue, int min, int max) {
            this.translation(path);
            return this.defineValue((ModConfigSpec.ConfigValue)this.builder.defineInRange(path, defaultValue, min, max));
        }

        @Override
        public <T> ConfigFile.Value<List<? extends T>> defineList(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            this.translation(path);
            return this.defineValue(this.builder.defineList(path, defaultValue, elementValidator));
        }

        @Override
        public <V extends Enum<V>> ConfigFile.Value<V> defineEnum(String path, V defaultValue) {
            this.translation(path);
            return this.defineValue((ModConfigSpec.ConfigValue)this.builder.defineEnum(path, defaultValue));
        }

        @Override
        public ConfigFile build(ConfigFile.ConfigListener onChange) {
            ModConfigSpec spec = this.builder.build();
            this.entries.stream().forEach(x -> {
                ConfigFile.Entry value;
                if (x instanceof ValueImpl) {
                    value = (ValueImpl)x;
                    value.owner = spec;
                }
                if (x instanceof GroupImpl) {
                    value = (GroupImpl)x;
                    ((GroupImpl)value).owner = spec;
                }
            });
            return new ForgeConfigFile(spec, this.entries);
        }
    }
}

