/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.GuardedLuaContext;
import dan200.computercraft.shared.peripheral.generic.SaturatedMethod;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class GenericPeripheral
implements IDynamicPeripheral {
    private final BlockEntity tile;
    private final Direction side;
    private final String type;
    private final Set<String> additionalTypes;
    private final List<SaturatedMethod> methods;
    @Nullable
    private GuardedLuaContext contextWrapper;
    private final GuardedLuaContext.Guard guard;

    GenericPeripheral(BlockEntity tile, Direction side, String type, Set<String> additionalTypes, List<SaturatedMethod> methods) {
        this.side = side;
        this.tile = tile;
        this.type = type;
        this.additionalTypes = additionalTypes;
        this.methods = methods;
        this.guard = () -> !tile.isRemoved() && tile.getLevel() != null && tile.getLevel().isLoaded(tile.getBlockPos());
    }

    public Direction side() {
        return this.side;
    }

    @Override
    public String[] getMethodNames() {
        String[] names = new String[this.methods.size()];
        for (int i = 0; i < this.methods.size(); ++i) {
            names[i] = this.methods.get(i).getName();
        }
        return names;
    }

    @Override
    public MethodResult callMethod(IComputerAccess computer, ILuaContext context, int method, IArguments arguments) throws LuaException {
        GuardedLuaContext contextWrapper = this.contextWrapper;
        if (contextWrapper == null || !contextWrapper.wraps(context)) {
            contextWrapper = this.contextWrapper = new GuardedLuaContext(context, this.guard);
        }
        return this.methods.get(method).apply(contextWrapper, computer, arguments);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Set<String> getAdditionalTypes() {
        return this.additionalTypes;
    }

    @Override
    public Object getTarget() {
        return this.tile;
    }

    @Override
    public boolean equals(@Nullable IPeripheral other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GenericPeripheral)) {
            return false;
        }
        GenericPeripheral generic = (GenericPeripheral)other;
        return this.tile == generic.tile && this.methods.equals(generic.methods);
    }
}

