/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.codec.MoreStreamCodecs;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record PocketComputerDataMessage(UUID id, ComputerState state, int lightState, Optional<TerminalState> terminal) implements NetworkMessage<ClientNetworkContext>
{
    public static final StreamCodec<RegistryFriendlyByteBuf, PocketComputerDataMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, PocketComputerDataMessage::id, MoreStreamCodecs.ofEnum(ComputerState.class), PocketComputerDataMessage::state, (StreamCodec)ByteBufCodecs.VAR_INT, PocketComputerDataMessage::lightState, (StreamCodec)ByteBufCodecs.optional(TerminalState.STREAM_CODEC), PocketComputerDataMessage::terminal, PocketComputerDataMessage::new);

    public PocketComputerDataMessage(PocketServerComputer computer, boolean sendTerminal) {
        this(computer.getInstanceUUID(), computer.getState(), computer.getLight(), sendTerminal ? Optional.of(computer.getTerminalState()) : Optional.empty());
    }

    @Override
    public void handle(ClientNetworkContext context) {
        context.handlePocketComputerData(this.id, this.state, this.lightState, this.terminal.orElse(null));
    }

    public CustomPacketPayload.Type<PocketComputerDataMessage> type() {
        return NetworkMessages.POCKET_COMPUTER_DATA;
    }
}

