/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.util.NonNegativeId;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.LevelReader;

public class DiskItem
extends Item
implements IMedia {
    public DiskItem(Item.Properties settings) {
        super(settings);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag options) {
        NonNegativeId id;
        if (options.isAdvanced() && (id = (NonNegativeId)stack.get((DataComponentType)ModRegistry.DataComponents.DISK_ID.get())) != null) {
            list.add((Component)Component.translatable((String)"gui.computercraft.tooltip.disk_id", (Object[])new Object[]{id.id()}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    @Override
    @Nullable
    public String getLabel(HolderLookup.Provider registries, ItemStack stack) {
        Component label = (Component)stack.get(DataComponents.CUSTOM_NAME);
        return label != null ? label.getString() : null;
    }

    @Override
    public boolean setLabel(ItemStack stack, @Nullable String label) {
        stack.set(DataComponents.CUSTOM_NAME, (Object)(label != null ? Component.literal((String)label) : null));
        return true;
    }

    @Override
    @Nullable
    public Mount createDataMount(ItemStack stack, ServerLevel level) {
        int diskID = NonNegativeId.getOrCreate(level.getServer(), stack, (DataComponentType<NonNegativeId>)((DataComponentType)ModRegistry.DataComponents.DISK_ID.get()), "disk");
        return ComputerCraftAPI.createSaveDirMount(level.getServer(), "disk/" + diskID, Config.floppySpaceLimit);
    }

    public static int getDiskID(ItemStack stack) {
        return NonNegativeId.getId((NonNegativeId)stack.get((DataComponentType)ModRegistry.DataComponents.DISK_ID.get()));
    }

    public static int getColour(ItemStack stack) {
        return DyedItemColor.getOrDefault((ItemStack)stack, (int)Colour.WHITE.getARGB());
    }
}

