/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.metrics.basic;

import dan200.computercraft.core.metrics.Metric;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.metrics.basic.Aggregate;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class ComputerMetrics {
    private static final int DEFAULT_LEN = 16;
    private final WeakReference<ServerComputer> computer;
    private final int computerId;
    private long[] counts;
    private long[] totals;
    private long[] max;

    ComputerMetrics(ServerComputer computer) {
        this.computer = new WeakReference<ServerComputer>(computer);
        this.computerId = computer.getID();
        this.counts = new long[16];
        this.totals = new long[16];
        this.max = new long[16];
    }

    ComputerMetrics(ComputerMetrics other) {
        this.computer = other.computer;
        this.computerId = other.computerId;
        this.counts = Arrays.copyOf(other.counts, other.counts.length);
        this.totals = Arrays.copyOf(other.totals, other.totals.length);
        this.max = Arrays.copyOf(other.max, other.max.length);
    }

    @Nullable
    public ServerComputer computer() {
        return (ServerComputer)this.computer.get();
    }

    public int computerId() {
        return this.computerId;
    }

    private static long get(long[] values, Metric metric) {
        return metric.id() >= values.length ? 0L : values[metric.id()];
    }

    private long avg(long total, long count) {
        return count == 0L ? 0L : total / count;
    }

    public long get(Metric metric, Aggregate aggregate) {
        if (metric instanceof Metric.Counter) {
            return ComputerMetrics.get(this.counts, metric);
        }
        if (metric instanceof Metric.Event) {
            return switch (aggregate) {
                default -> throw new MatchException(null, null);
                case Aggregate.NONE -> ComputerMetrics.get(this.totals, metric);
                case Aggregate.COUNT -> ComputerMetrics.get(this.counts, metric);
                case Aggregate.AVG -> this.avg(ComputerMetrics.get(this.totals, metric), ComputerMetrics.get(this.counts, metric));
                case Aggregate.MAX -> ComputerMetrics.get(this.max, metric);
            };
        }
        throw new IllegalArgumentException("Unknown metric " + metric.name());
    }

    public String getFormatted(Metric field, Aggregate aggregate) {
        long value = this.get(field, aggregate);
        return switch (aggregate) {
            default -> throw new MatchException(null, null);
            case Aggregate.COUNT -> Metric.formatDefault(value);
            case Aggregate.NONE, Aggregate.AVG, Aggregate.MAX -> field.format(value);
        };
    }

    private void ensureCapacity(Metric metric) {
        if (metric.id() < this.counts.length) {
            return;
        }
        int newCapacity = Math.max(metric.id(), this.counts.length * 2);
        this.counts = Arrays.copyOf(this.counts, newCapacity);
        this.totals = Arrays.copyOf(this.totals, newCapacity);
        this.max = Arrays.copyOf(this.max, newCapacity);
    }

    void observe(Metric.Counter counter) {
        this.ensureCapacity(counter);
        int n = counter.id();
        this.counts[n] = this.counts[n] + 1L;
    }

    void observe(Metric.Event event, long value) {
        this.ensureCapacity(event);
        int n = event.id();
        this.counts[n] = this.counts[n] + 1L;
        int n2 = event.id();
        this.totals[n2] = this.totals[n2] + value;
        if (value > this.max[event.id()]) {
            this.max[event.id()] = value;
        }
    }
}

