/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlock;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class AbstractComputerItem
extends BlockItem
implements IMedia {
    public AbstractComputerItem(AbstractComputerBlock<?> block, Item.Properties settings) {
        super(block, settings);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag options) {
        NonNegativeId id;
        if ((options.isAdvanced() || !stack.has(DataComponents.CUSTOM_NAME)) && (id = (NonNegativeId)stack.get((DataComponentType)ModRegistry.DataComponents.COMPUTER_ID.get())) != null) {
            list.add((Component)Component.translatable((String)"gui.computercraft.tooltip.computer_id", (Object[])new Object[]{id.id()}).withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    @Nullable
    public String getLabel(HolderLookup.Provider registries, ItemStack stack) {
        return DataComponentUtil.getCustomName((DataComponentHolder)stack);
    }

    @Override
    public boolean setLabel(ItemStack stack, @Nullable String label) {
        DataComponentUtil.setCustomName(stack, label);
        return true;
    }

    @Override
    @Nullable
    public Mount createDataMount(ItemStack stack, ServerLevel level) {
        NonNegativeId id = (NonNegativeId)stack.get((DataComponentType)ModRegistry.DataComponents.COMPUTER_ID.get());
        return id != null ? ComputerCraftAPI.createSaveDirMount(level.getServer(), "computer/" + id.id(), Config.computerSpaceLimit) : null;
    }
}

