/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import com.google.common.annotations.VisibleForTesting;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.network.PacketNetwork;
import dan200.computercraft.core.ComputerContext;
import dan200.computercraft.core.computer.GlobalEnvironment;
import dan200.computercraft.core.computer.mainthread.MainThread;
import dan200.computercraft.core.computer.mainthread.MainThreadConfig;
import dan200.computercraft.core.lua.CobaltLuaMachine;
import dan200.computercraft.core.lua.ILuaMachine;
import dan200.computercraft.core.methods.MethodSupplier;
import dan200.computercraft.core.methods.PeripheralMethod;
import dan200.computercraft.impl.AbstractComputerCraftAPI;
import dan200.computercraft.impl.ApiFactories;
import dan200.computercraft.impl.GenericSources;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.metrics.GlobalMetrics;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessNetwork;
import dan200.computercraft.shared.util.IDAssigner;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerContext {
    private static final Logger LOG = LoggerFactory.getLogger(ServerContext.class);
    private static final LevelResource FOLDER = new LevelResource("computercraft");
    @VisibleForTesting
    public static ILuaMachine.Factory luaMachine = CobaltLuaMachine::new;
    @Nullable
    private static ServerContext instance;
    private final MinecraftServer server;
    private final ServerComputerRegistry registry = new ServerComputerRegistry();
    private final GlobalMetrics metrics = new GlobalMetrics();
    private final ComputerContext context;
    private final MainThread mainThread;
    private final IDAssigner idAssigner;
    private final WirelessNetwork wirelessNetwork = new WirelessNetwork();
    private final Path storageDir;
    private static final MainThreadConfig mainThreadConfig;

    private ServerContext(MinecraftServer server) {
        this.server = server;
        this.storageDir = server.getWorldPath(FOLDER);
        this.mainThread = new MainThread(mainThreadConfig);
        this.context = ComputerContext.builder(new Environment(server)).computerThreads((Integer)ConfigSpec.computerThreads.get()).mainThreadScheduler(this.mainThread).luaFactory(luaMachine).apiFactories(ApiFactories.getAll()).genericMethods(GenericSources.getAllMethods()).build();
        this.idAssigner = new IDAssigner(this.storageDir.resolve("ids.json"));
    }

    public static void create(MinecraftServer server) {
        if (instance != null) {
            throw new IllegalStateException("ServerContext already exists!");
        }
        instance = new ServerContext(server);
    }

    public static void close() {
        ServerContext instance = ServerContext.instance;
        if (instance == null) {
            return;
        }
        instance.registry.close();
        try {
            if (!instance.context.close(1L, TimeUnit.SECONDS)) {
                LOG.error("Failed to stop computers under deadline.");
            }
        }
        catch (InterruptedException e) {
            LOG.error("Failed to stop computers.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        ServerContext.instance = null;
    }

    public static ServerContext get(MinecraftServer server) {
        Objects.requireNonNull(server, "Server cannot be null");
        ServerContext instance = ServerContext.instance;
        if (instance == null) {
            throw new IllegalStateException("ServerContext has not been started yet");
        }
        if (instance.server != server) {
            throw new IllegalStateException("Incorrect server given. Did ServerContext shutdown correctly?");
        }
        return instance;
    }

    ComputerContext computerContext() {
        return this.context;
    }

    public MethodSupplier<PeripheralMethod> peripheralMethods() {
        return this.context.peripheralMethods();
    }

    public void tick() {
        this.registry.update();
        this.mainThread.tick();
    }

    public ServerComputerRegistry registry() {
        return this.registry;
    }

    public int getNextId(String kind) {
        return this.idAssigner.getNextId(kind);
    }

    public Path storageDir() {
        return this.storageDir;
    }

    public GlobalMetrics metrics() {
        return this.metrics;
    }

    public PacketNetwork wirelessNetwork() {
        return this.wirelessNetwork;
    }

    static {
        mainThreadConfig = new MainThreadConfig(){

            @Override
            public long maxGlobalTime() {
                return TimeUnit.MILLISECONDS.toNanos(((Integer)ConfigSpec.maxMainGlobalTime.get()).intValue());
            }

            @Override
            public long maxComputerTime() {
                return TimeUnit.MILLISECONDS.toNanos(((Integer)ConfigSpec.maxMainComputerTime.get()).intValue());
            }
        };
    }

    private record Environment(MinecraftServer server) implements GlobalEnvironment
    {
        @Override
        @Nullable
        public Mount createResourceMount(String domain, String subPath) {
            return ComputerCraftAPI.createResourceMount(this.server, domain, subPath);
        }

        @Override
        @Nullable
        public InputStream createResourceFile(String domain, String subPath) {
            return AbstractComputerCraftAPI.getResourceFile(this.server, domain, subPath);
        }

        @Override
        public String getHostString() {
            String version = SharedConstants.getCurrentVersion().getName();
            return String.format("ComputerCraft %s (Minecraft %s)", ComputerCraftAPI.getInstalledVersion(), version);
        }

        @Override
        public String getUserAgent() {
            return "computercraft/" + ComputerCraftAPI.getInstalledVersion();
        }
    }
}

