/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.WorkMonitor;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerEnvironment;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.shared.computer.apis.CommandAPI;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.InputHandler;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ServerComputer
implements InputHandler,
ComputerEnvironment {
    private final UUID instanceUUID = UUID.randomUUID();
    private ServerLevel level;
    private BlockPos position;
    private final ComputerFamily family;
    private final MetricsObserver metrics;
    private final Computer computer;
    private final NetworkedTerminal terminal;
    private final AtomicBoolean terminalChanged = new AtomicBoolean(false);
    private int ticksSincePing;

    public ServerComputer(ServerLevel level, BlockPos position, int computerID, @Nullable String label, ComputerFamily family, int terminalWidth, int terminalHeight) {
        this.level = level;
        this.position = position;
        this.family = family;
        ServerContext context = ServerContext.get(level.getServer());
        this.terminal = new NetworkedTerminal(terminalWidth, terminalHeight, family != ComputerFamily.NORMAL, this::markTerminalChanged);
        this.metrics = context.metrics().createMetricObserver(this);
        this.computer = new Computer(context.computerContext(), this, this.terminal, computerID);
        this.computer.setLabel(label);
        if (family == ComputerFamily.COMMAND) {
            this.addAPI(new CommandAPI(this));
        }
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void setPosition(ServerLevel level, BlockPos pos) {
        this.level = level;
        this.position = pos.immutable();
    }

    protected void markTerminalChanged() {
        this.terminalChanged.set(true);
    }

    protected void tickServer() {
        ++this.ticksSincePing;
        this.computer.tick();
        if (this.terminalChanged.getAndSet(false)) {
            this.onTerminalChanged();
        }
    }

    protected void onTerminalChanged() {
        this.sendToAllInteracting(c -> new ComputerTerminalClientMessage((AbstractContainerMenu)c, this.getTerminalState()));
    }

    public TerminalState getTerminalState() {
        return new TerminalState(this.terminal);
    }

    public void keepAlive() {
        this.ticksSincePing = 0;
    }

    boolean hasTimedOut() {
        return this.ticksSincePing > 100;
    }

    public int pollAndResetChanges() {
        return this.computer.pollAndResetChanges();
    }

    public UUID register() {
        ServerContext.get(this.level.getServer()).registry().add(this);
        return this.instanceUUID;
    }

    void unload() {
        this.computer.unload();
    }

    public void close() {
        this.unload();
        ServerContext.get(this.level.getServer()).registry().remove(this);
    }

    public final boolean checkUsable(Player player) {
        return ServerContext.get(this.level.getServer()).registry().get(this.instanceUUID) == this && this.getFamily().checkUsable(player);
    }

    private void sendToAllInteracting(Function<AbstractContainerMenu, NetworkMessage<ClientNetworkContext>> createPacket) {
        MinecraftServer server = this.level.getServer();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            if (!(player.containerMenu instanceof ComputerMenu) || ((ComputerMenu)player.containerMenu).getComputer() != this) continue;
            ServerNetworking.sendToPlayer(createPacket.apply(player.containerMenu), player);
        }
    }

    protected void onRemoved() {
    }

    public UUID getInstanceUUID() {
        return this.instanceUUID;
    }

    public int getID() {
        return this.computer.getID();
    }

    @Nullable
    public String getLabel() {
        return this.computer.getLabel();
    }

    public boolean isOn() {
        return this.computer.isOn();
    }

    public ComputerState getState() {
        if (!this.computer.isOn()) {
            return ComputerState.OFF;
        }
        return this.computer.isBlinking() ? ComputerState.BLINKING : ComputerState.ON;
    }

    @Override
    public void turnOn() {
        this.computer.turnOn();
    }

    @Override
    public void shutdown() {
        this.computer.shutdown();
    }

    @Override
    public void reboot() {
        this.computer.reboot();
    }

    @Override
    public void queueEvent(String event, @Nullable Object[] arguments) {
        this.computer.queueEvent(event, arguments);
    }

    public int getRedstoneOutput(ComputerSide side) {
        return this.computer.getEnvironment().getExternalRedstoneOutput(side);
    }

    public void setRedstoneInput(ComputerSide side, int level) {
        this.computer.getEnvironment().setRedstoneInput(side, level);
    }

    public int getBundledRedstoneOutput(ComputerSide side) {
        return this.computer.getEnvironment().getExternalBundledRedstoneOutput(side);
    }

    public void setBundledRedstoneInput(ComputerSide side, int combination) {
        this.computer.getEnvironment().setBundledRedstoneInput(side, combination);
    }

    public void addAPI(ILuaAPI api) {
        this.computer.addApi(api);
    }

    public void setPeripheral(ComputerSide side, @Nullable IPeripheral peripheral) {
        this.computer.getEnvironment().setPeripheral(side, peripheral);
    }

    @Nullable
    public IPeripheral getPeripheral(ComputerSide side) {
        return this.computer.getEnvironment().getPeripheral(side);
    }

    public void setLabel(@Nullable String label) {
        this.computer.setLabel(label);
    }

    @Override
    public double getTimeOfDay() {
        return (double)((this.level.getDayTime() + 6000L) % 24000L) / 1000.0;
    }

    @Override
    public int getDay() {
        return (int)((this.level.getDayTime() + 6000L) / 24000L) + 1;
    }

    @Override
    public MetricsObserver getMetrics() {
        return this.metrics;
    }

    public WorkMonitor getMainThreadMonitor() {
        return this.computer.getMainThreadMonitor();
    }

    @Override
    @Nullable
    public WritableMount createRootMount() {
        return ComputerCraftAPI.createSaveDirMount(this.level.getServer(), "computer/" + this.computer.getID(), Config.computerSpaceLimit);
    }
}

