/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.common;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class HeldItemMenu
extends AbstractContainerMenu {
    private final ItemStack stack;
    private final InteractionHand hand;

    public HeldItemMenu(MenuType<? extends HeldItemMenu> type, int id, Player player, InteractionHand hand) {
        super(type, id);
        this.hand = hand;
        this.stack = player.getItemInHand(hand).copy();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        if (!player.isAlive()) {
            return false;
        }
        ItemStack stack = player.getItemInHand(this.hand);
        return stack == this.stack || !stack.isEmpty() && !this.stack.isEmpty() && stack.getItem() == this.stack.getItem();
    }

    public static class Factory
    implements MenuProvider {
        private final MenuType<HeldItemMenu> type;
        private final Component name;
        private final InteractionHand hand;

        public Factory(MenuType<HeldItemMenu> type, ItemStack stack, InteractionHand hand) {
            this.type = type;
            this.name = stack.getHoverName();
            this.hand = hand;
        }

        public Component getDisplayName() {
            return this.name;
        }

        @Nullable
        public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
            return new HeldItemMenu(this.type, id, player, this.hand);
        }
    }
}

