/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data.recipe;

import com.mojang.serialization.DataResult;
import dan200.computercraft.shared.recipe.RecipeProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public abstract class AbstractRecipeBuilder<S extends AbstractRecipeBuilder<S, O>, O> {
    private final RecipeCategory category;
    protected final ItemStack result;
    private String group = "";
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    protected AbstractRecipeBuilder(RecipeCategory category, ItemStack result) {
        this.category = category;
        this.result = result;
    }

    public final S group(String group) {
        this.group = group;
        return this.self();
    }

    public final S unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this.self();
    }

    protected abstract O build(RecipeProperties var1);

    public final FinishedRecipe build(Function<O, Recipe<?>> factory) {
        RecipeProperties properties = new RecipeProperties(this.group, RecipeBuilder.determineBookCategory((RecipeCategory)this.category), true);
        return new FinishedRecipe(factory.apply(this.build(properties)), this.result.getItem(), this.category, this.criteria);
    }

    public final FinishedRecipe buildOrThrow(Function<O, DataResult<? extends Recipe<?>>> factory) {
        return this.build((O s) -> (Recipe)((DataResult)factory.apply(s)).getOrThrow());
    }

    private S self() {
        return (S)this;
    }

    public static final class FinishedRecipe {
        private final Recipe<?> recipe;
        private final Item result;
        private final RecipeCategory category;
        private final Map<String, Criterion<?>> criteria;

        private FinishedRecipe(Recipe<?> recipe, Item result, RecipeCategory category, Map<String, Criterion<?>> criteria) {
            this.recipe = recipe;
            this.result = result;
            this.category = category;
            this.criteria = criteria;
        }

        public void save(RecipeOutput output, ResourceLocation id) {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
            Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
            for (Map.Entry<String, Criterion<?>> entry : this.criteria.entrySet()) {
                advancement.addCriterion(entry.getKey(), entry.getValue());
            }
            output.accept(id, this.recipe, advancement.build(id.withPrefix("recipes/" + this.category.getFolderName() + "/")));
        }

        public void save(RecipeOutput output) {
            this.save(output, RecipeBuilder.getDefaultRecipeId((ItemLike)this.result));
        }
    }
}

