/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import dan200.computercraft.shared.CommonHooks;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.data.BlockNamedEntityLootCondition;
import dan200.computercraft.shared.data.HasComputerIdLootCondition;
import dan200.computercraft.shared.data.PlayerCreativeLootCondition;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

class LootTableProvider {
    LootTableProvider() {
    }

    public static List<LootTableProvider.SubProviderEntry> getTables() {
        return List.of(new LootTableProvider.SubProviderEntry(r -> LootTableProvider::registerBlocks, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(r -> LootTableProvider::registerGeneric, LootContextParamSets.ALL_PARAMS));
    }

    private static void registerBlocks(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> add) {
        LootTableProvider.namedBlockDrop(add, ModRegistry.Blocks.DISK_DRIVE);
        LootTableProvider.selfDrop(add, ModRegistry.Blocks.MONITOR_NORMAL);
        LootTableProvider.selfDrop(add, ModRegistry.Blocks.MONITOR_ADVANCED);
        LootTableProvider.namedBlockDrop(add, ModRegistry.Blocks.PRINTER);
        LootTableProvider.selfDrop(add, ModRegistry.Blocks.SPEAKER);
        LootTableProvider.selfDrop(add, ModRegistry.Blocks.WIRED_MODEM_FULL);
        LootTableProvider.selfDrop(add, ModRegistry.Blocks.WIRELESS_MODEM_NORMAL);
        LootTableProvider.selfDrop(add, ModRegistry.Blocks.WIRELESS_MODEM_ADVANCED);
        LootTableProvider.computerDrop(add, ModRegistry.Blocks.COMPUTER_NORMAL);
        LootTableProvider.computerDrop(add, ModRegistry.Blocks.COMPUTER_ADVANCED);
        LootTableProvider.computerDrop(add, ModRegistry.Blocks.COMPUTER_COMMAND);
        LootTableProvider.computerDrop(add, ModRegistry.Blocks.TURTLE_NORMAL);
        LootTableProvider.computerDrop(add, ModRegistry.Blocks.TURTLE_ADVANCED);
        add.accept((ResourceKey<LootTable>)((CableBlock)((Object)ModRegistry.Blocks.CABLE.get())).getLootTable(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModRegistry.Items.CABLE.get()))).when(ExplosionCondition.survivesExplosion()).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModRegistry.Blocks.CABLE.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CableBlock.CABLE, true)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModRegistry.Items.WIRED_MODEM.get()))).when(ExplosionCondition.survivesExplosion()).when(LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModRegistry.Blocks.CABLE.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(CableBlock.MODEM, (Comparable)((Object)CableModemVariant.None))).invert())));
    }

    private static void registerGeneric(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> add) {
        add.accept(CommonHooks.TREASURE_DISK_LOOT, LootTable.lootTable());
    }

    private static void selfDrop(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> add, Supplier<? extends Block> wrapper) {
        LootTableProvider.blockDrop(add, wrapper, LootItem.lootTableItem((ItemLike)((ItemLike)wrapper.get())), ExplosionCondition.survivesExplosion());
    }

    private static void namedBlockDrop(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> add, Supplier<? extends Block> wrapper) {
        LootTableProvider.blockDrop(add, wrapper, LootItem.lootTableItem((ItemLike)((ItemLike)wrapper.get())).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)), ExplosionCondition.survivesExplosion());
    }

    private static void computerDrop(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> add, Supplier<? extends Block> block) {
        LootTableProvider.blockDrop(add, block, LootItem.lootTableItem((ItemLike)((ItemLike)block.get())).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY)), (LootItemCondition.Builder)AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{BlockNamedEntityLootCondition.BUILDER, HasComputerIdLootCondition.BUILDER, PlayerCreativeLootCondition.BUILDER.invert()}));
    }

    private static void blockDrop(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> add, Supplier<? extends Block> wrapper, LootPoolEntryContainer.Builder<?> drop, LootItemCondition.Builder condition) {
        Block block = wrapper.get();
        add.accept((ResourceKey<LootTable>)block.getLootTable(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(drop).when(condition)));
    }
}

