/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.core.ComputerContext;
import dan200.computercraft.core.CoreConfig;
import dan200.computercraft.core.apis.FSAPI;
import dan200.computercraft.core.apis.HTTPAPI;
import dan200.computercraft.core.apis.OSAPI;
import dan200.computercraft.core.apis.PeripheralAPI;
import dan200.computercraft.core.apis.RedstoneAPI;
import dan200.computercraft.core.apis.TermAPI;
import dan200.computercraft.core.computer.ApiWrapper;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerEnvironment;
import dan200.computercraft.core.computer.ComputerSystem;
import dan200.computercraft.core.computer.Environment;
import dan200.computercraft.core.computer.LuaContext;
import dan200.computercraft.core.computer.TimeoutState;
import dan200.computercraft.core.computer.computerthread.ComputerScheduler;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import dan200.computercraft.core.lua.ILuaMachine;
import dan200.computercraft.core.lua.MachineEnvironment;
import dan200.computercraft.core.lua.MachineException;
import dan200.computercraft.core.lua.MachineResult;
import dan200.computercraft.core.methods.LuaMethod;
import dan200.computercraft.core.methods.MethodSupplier;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.core.util.Nullability;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ComputerExecutor
implements ComputerScheduler.Worker {
    private static final Logger LOG = LoggerFactory.getLogger(ComputerExecutor.class);
    private static final int QUEUE_LIMIT = 256;
    private final Computer computer;
    private final ComputerEnvironment computerEnvironment;
    private final MetricsObserver metrics;
    private final List<ApiWrapper> apis = new ArrayList<ApiWrapper>();
    private final MethodSupplier<LuaMethod> luaMethods;
    @Nullable
    private FileSystem fileSystem;
    @Nullable
    private ILuaMachine machine;
    private volatile boolean isOn = false;
    private final ReentrantLock isOnLock = new ReentrantLock();
    private final Object queueLock = new Object();
    @Nullable
    @GuardedBy(value="queueLock")
    private volatile StateCommand command;
    @GuardedBy(value="queueLock")
    private final Queue<Event> eventQueue = new ArrayDeque<Event>(4);
    private boolean wasPaused;
    private long timeRemaining = 0L;
    @GuardedBy(value="queueLock")
    private boolean closed;
    @Nullable
    private WritableMount rootMount;
    private final ILuaMachine.Factory luaFactory;
    private final ComputerScheduler.Executor executor;

    ComputerExecutor(Computer computer, ComputerEnvironment computerEnvironment, ComputerContext context) {
        this.computer = computer;
        this.computerEnvironment = computerEnvironment;
        this.metrics = computerEnvironment.getMetrics();
        this.luaFactory = context.luaFactory();
        this.luaMethods = context.luaMethods();
        this.executor = context.computerScheduler().createExecutor(this, this.metrics);
        Environment environment = computer.getEnvironment();
        this.addApi(new TermAPI(environment));
        this.addApi(new RedstoneAPI(environment));
        this.addApi(new FSAPI(environment));
        this.addApi(new PeripheralAPI(environment, context.peripheralMethods()));
        this.addApi(new OSAPI(environment));
        if (CoreConfig.httpEnabled) {
            this.addApi(new HTTPAPI(environment));
        }
        for (ILuaAPIFactory factory : context.apiFactories()) {
            ComputerSystem system;
            ILuaAPI api = factory.create(system = new ComputerSystem(environment));
            if (api == null) continue;
            this.apis.add(new ApiWrapper(api, system));
        }
    }

    @Override
    public int getComputerID() {
        return this.computer.getID();
    }

    boolean isOn() {
        return this.isOn;
    }

    FileSystem getFileSystem() {
        FileSystem fileSystem = this.fileSystem;
        if (fileSystem == null) {
            throw new IllegalStateException("FileSystem has not been created yet");
        }
        return fileSystem;
    }

    void addApi(ILuaAPI api) {
        this.apis.add(new ApiWrapper(api, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueStart() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.closed || this.isOn || this.command != null) {
                return;
            }
            this.command = StateCommand.TURN_ON;
        }
        this.enqueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueStop(boolean reboot, boolean close) {
        Object object = this.queueLock;
        synchronized (object) {
            StateCommand newCommand;
            if (this.closed) {
                return;
            }
            this.closed = close;
            StateCommand stateCommand = newCommand = reboot ? StateCommand.REBOOT : StateCommand.SHUTDOWN;
            if (!this.isOn || this.command != null) {
                if (close) {
                    this.command = newCommand;
                }
                return;
            }
            this.command = newCommand;
        }
        this.enqueue();
    }

    @Override
    public void abortWithTimeout() {
        this.immediateFail(StateCommand.ABORT_WITH_TIMEOUT);
    }

    @Override
    public void abortWithError() {
        this.immediateFail(StateCommand.ABORT_WITH_ERROR);
    }

    @Override
    public void unload() {
        this.queueStop(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void immediateFail(StateCommand command) {
        ILuaMachine machine = this.machine;
        if (machine != null) {
            machine.close();
        }
        Object object = this.queueLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.command = command;
            if (this.isOn) {
                this.enqueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueEvent(String event, @Nullable Object[] args) {
        if (!this.isOn) {
            return;
        }
        Object object = this.queueLock;
        synchronized (object) {
            if (this.closed || this.command != null || this.eventQueue.size() >= 256) {
                return;
            }
            this.eventQueue.offer(new Event(event, args));
        }
        this.enqueue();
    }

    private void enqueue() {
        this.executor.submit();
    }

    void tick() {
        if (this.isOn && this.isOnLock.tryLock()) {
            try {
                if (this.isOn) {
                    for (ApiWrapper api : this.apis) {
                        api.update();
                    }
                }
            }
            finally {
                this.isOnLock.unlock();
            }
        }
    }

    @Nullable
    private Mount getRomMount() {
        return this.computer.getGlobalEnvironment().createResourceMount("computercraft", "lua/rom");
    }

    @Nullable
    private WritableMount getRootMount() {
        if (this.rootMount == null) {
            this.rootMount = this.computerEnvironment.createRootMount();
        }
        return this.rootMount;
    }

    @Nullable
    private FileSystem createFileSystem() {
        FileSystem filesystem = null;
        try {
            WritableMount mount = this.getRootMount();
            if (mount == null) {
                this.displayFailure("Cannot mount computer mount", null);
                return null;
            }
            filesystem = new FileSystem("hdd", mount);
            Mount romMount = this.getRomMount();
            if (romMount == null) {
                this.displayFailure("Cannot mount ROM", null);
                return null;
            }
            filesystem.mount("rom", "rom", romMount);
            return filesystem;
        }
        catch (FileSystemException e) {
            if (filesystem != null) {
                filesystem.close();
            }
            LOG.error("Cannot mount computer filesystem", (Throwable)e);
            this.displayFailure("Cannot mount computer system", null);
            return null;
        }
    }

    @Nullable
    private ILuaMachine createLuaMachine() {
        ILuaMachine iLuaMachine;
        block12: {
            InputStream biosStream = null;
            try {
                biosStream = this.computer.getGlobalEnvironment().createResourceFile("computercraft", "lua/bios.lua");
            }
            catch (Exception e) {
                LOG.error("Failed to load BIOS", (Throwable)e);
            }
            if (biosStream == null) {
                this.displayFailure("Error loading bios.lua", null);
                return null;
            }
            InputStream bios = biosStream;
            try {
                iLuaMachine = this.luaFactory.create(new MachineEnvironment(new LuaContext(this.computer), this.metrics, this.executor.timeoutState(), () -> this.apis.stream().map(ApiWrapper::api).iterator(), this.luaMethods, this.computer.getGlobalEnvironment().getHostString()), bios);
                if (bios == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (bios != null) {
                        try {
                            bios.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Failed to read bios.lua", (Throwable)e);
                    this.displayFailure("Error loading bios.lua", null);
                    return null;
                }
                catch (MachineException e) {
                    this.displayFailure("Error loading bios.lua", e.getMessage());
                    return null;
                }
            }
            bios.close();
        }
        return iLuaMachine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnOn() throws InterruptedException {
        this.isOnLock.lockInterruptibly();
        try {
            this.computer.getTerminal().reset();
            Iterator<ApiWrapper> iterator = this.queueLock;
            synchronized (iterator) {
                this.eventQueue.clear();
            }
            this.fileSystem = this.createFileSystem();
            if (this.fileSystem == null) {
                this.shutdown();
                return;
            }
            this.computer.getEnvironment().reset();
            for (ApiWrapper api : this.apis) {
                api.startup();
            }
            this.machine = this.createLuaMachine();
            if (this.machine == null) {
                this.shutdown();
                return;
            }
            this.isOn = true;
        }
        finally {
            this.isOnLock.unlock();
        }
        this.wasPaused = true;
        this.timeRemaining = TimeoutState.TIMEOUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() throws InterruptedException {
        this.isOnLock.lockInterruptibly();
        try {
            this.wasPaused = false;
            this.isOn = false;
            Iterator<ApiWrapper> iterator = this.queueLock;
            synchronized (iterator) {
                this.eventQueue.clear();
            }
            if (this.machine != null) {
                this.machine.close();
                this.machine = null;
            }
            for (ApiWrapper api : this.apis) {
                api.shutdown();
            }
            this.computer.getEnvironment().reset();
            if (this.fileSystem != null) {
                this.fileSystem.close();
                this.fileSystem = null;
            }
            this.computer.getEnvironment().resetOutput();
        }
        finally {
            this.isOnLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void work() throws InterruptedException {
        this.workImpl();
        Object object = this.queueLock;
        synchronized (object) {
            if (this.wasPaused || this.command != null || !this.eventQueue.isEmpty()) {
                this.enqueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workImpl() throws InterruptedException {
        StateCommand command;
        Event event = null;
        Object object = this.queueLock;
        synchronized (object) {
            command = this.command;
            this.command = null;
            if (command == null && !this.wasPaused) {
                if (!this.isOn) {
                    this.eventQueue.clear();
                    return;
                }
                event = this.eventQueue.poll();
            }
        }
        if (command != null) {
            this.wasPaused = false;
            switch (command.ordinal()) {
                case 0: {
                    if (this.isOn) {
                        return;
                    }
                    this.turnOn();
                    break;
                }
                case 1: {
                    if (!this.isOn) {
                        return;
                    }
                    this.computer.getTerminal().reset();
                    this.shutdown();
                    break;
                }
                case 2: {
                    if (!this.isOn) {
                        return;
                    }
                    this.computer.getTerminal().reset();
                    this.shutdown();
                    this.computer.turnOn();
                    break;
                }
                case 3: {
                    if (!this.isOn) {
                        return;
                    }
                    this.displayFailure("Error running computer", "Too long without yielding");
                    this.shutdown();
                    break;
                }
                case 4: {
                    if (!this.isOn) {
                        return;
                    }
                    this.displayFailure("Error running computer", "An internal error occurred, see logs.");
                    this.shutdown();
                }
            }
        } else if (this.wasPaused) {
            this.executor.setRemainingTime(this.timeRemaining);
            this.resumeMachine(null, null);
        } else if (event != null) {
            this.executor.setRemainingTime(TimeoutState.TIMEOUT);
            this.resumeMachine(event.name, event.args);
        }
    }

    @Override
    public void writeState(StringBuilder out) {
        out.append("Enqueued command: ").append((Object)this.command).append('\n');
        out.append("Enqueued events: ").append(this.eventQueue.size()).append('\n');
        ILuaMachine machine = this.machine;
        if (machine != null) {
            machine.printExecutionState(out);
        }
    }

    private void displayFailure(String message, @Nullable String extra) {
        Terminal terminal = this.computer.getTerminal();
        terminal.reset();
        if (terminal.isColour()) {
            terminal.setTextColour(15 - Colour.RED.ordinal());
        }
        terminal.write(message);
        if (extra != null) {
            terminal.setCursorPos(0, terminal.getCursorY() + 1);
            terminal.write(extra);
        }
        terminal.setCursorPos(0, terminal.getCursorY() + 1);
        if (terminal.isColour()) {
            terminal.setTextColour(15 - Colour.WHITE.ordinal());
        }
        terminal.write("ComputerCraft may be installed incorrectly");
    }

    private void resumeMachine(@Nullable String event, @Nullable Object[] args) throws InterruptedException {
        MachineResult result = Nullability.assertNonNull(this.machine).handleEvent(event, args);
        if (result.isError()) {
            this.displayFailure("Error running computer", result.getMessage());
            this.shutdown();
        } else if (result.isPause()) {
            this.wasPaused = true;
            this.timeRemaining = this.executor.getRemainingTime();
        } else {
            this.wasPaused = false;
        }
    }

    private static enum StateCommand {
        TURN_ON,
        SHUTDOWN,
        REBOOT,
        ABORT_WITH_TIMEOUT,
        ABORT_WITH_ERROR;

    }

    private record Event(String name, @Nullable Object[] args) {
    }
}

