/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.text;

import com.mojang.blaze3d.vertex.VertexFormat;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Palette;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.core.util.Colour;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;

public final class DirectFixedWidthFontRenderer {
    private DirectFixedWidthFontRenderer() {
    }

    private static void drawChar(QuadEmitter emitter, float x, float y, int index, byte[] colour) {
        if (index == 0 || index == 32) {
            return;
        }
        int column = index % 16;
        int row = index / 16;
        int xStart = 1 + column * 8;
        int yStart = 1 + row * 11;
        DirectFixedWidthFontRenderer.quad(emitter, x, y, x + 6.0f, y + 9.0f, 0.0f, colour, (float)xStart / 256.0f, (float)yStart / 256.0f, (float)(xStart + 6) / 256.0f, (float)(yStart + 9) / 256.0f);
    }

    private static void drawQuad(QuadEmitter emitter, float x, float y, float width, float height, Palette palette, char colourIndex) {
        byte[] colour = palette.getRenderColours(FixedWidthFontRenderer.getColour(colourIndex, Colour.BLACK));
        DirectFixedWidthFontRenderer.quad(emitter, x, y, x + width, y + height, 0.0f, colour, 0.9765625f, 0.9765625f, 0.984375f, 0.984375f);
    }

    private static void drawBackground(QuadEmitter emitter, float x, float y, TextBuffer backgroundColour, Palette palette, float leftMarginSize, float rightMarginSize, float height) {
        if (leftMarginSize > 0.0f) {
            DirectFixedWidthFontRenderer.drawQuad(emitter, x - leftMarginSize, y, leftMarginSize, height, palette, backgroundColour.charAt(0));
        }
        if (rightMarginSize > 0.0f) {
            DirectFixedWidthFontRenderer.drawQuad(emitter, x + (float)(backgroundColour.length() * 6), y, rightMarginSize, height, palette, backgroundColour.charAt(backgroundColour.length() - 1));
        }
        int blockStart = 0;
        char blockColour = '\u0000';
        for (int i = 0; i < backgroundColour.length(); ++i) {
            char colourIndex = backgroundColour.charAt(i);
            if (colourIndex == blockColour) continue;
            if (blockColour != '\u0000') {
                DirectFixedWidthFontRenderer.drawQuad(emitter, x + (float)(blockStart * 6), y, 6 * (i - blockStart), height, palette, blockColour);
            }
            blockColour = colourIndex;
            blockStart = i;
        }
        if (blockColour != '\u0000') {
            DirectFixedWidthFontRenderer.drawQuad(emitter, x + (float)(blockStart * 6), y, 6 * (backgroundColour.length() - blockStart), height, palette, blockColour);
        }
    }

    public static void drawString(QuadEmitter emitter, float x, float y, TextBuffer text, TextBuffer textColour, Palette palette) {
        for (int i = 0; i < text.length(); ++i) {
            byte[] colour = palette.getRenderColours(FixedWidthFontRenderer.getColour(textColour.charAt(i), Colour.BLACK));
            int index = text.charAt(i);
            if (index > 255) {
                index = 63;
            }
            DirectFixedWidthFontRenderer.drawChar(emitter, x + (float)(i * 6), y, index, colour);
        }
    }

    public static void drawTerminalForeground(QuadEmitter emitter, float x, float y, Terminal terminal) {
        Palette palette = terminal.getPalette();
        int height = terminal.getHeight();
        for (int i = 0; i < height; ++i) {
            float rowY = y + (float)(9 * i);
            DirectFixedWidthFontRenderer.drawString(emitter, x, rowY, terminal.getLine(i), terminal.getTextColourLine(i), palette);
        }
    }

    public static void drawTerminalBackground(QuadEmitter emitter, float x, float y, Terminal terminal, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        Palette palette = terminal.getPalette();
        int height = terminal.getHeight();
        DirectFixedWidthFontRenderer.drawBackground(emitter, x, y - topMarginSize, terminal.getBackgroundColourLine(0), palette, leftMarginSize, rightMarginSize, topMarginSize);
        DirectFixedWidthFontRenderer.drawBackground(emitter, x, y + (float)(height * 9), terminal.getBackgroundColourLine(height - 1), palette, leftMarginSize, rightMarginSize, bottomMarginSize);
        for (int i = 0; i < height; ++i) {
            float rowY = y + (float)(9 * i);
            DirectFixedWidthFontRenderer.drawBackground(emitter, x, rowY, terminal.getBackgroundColourLine(i), palette, leftMarginSize, rightMarginSize, 9.0f);
        }
    }

    public static void drawCursor(QuadEmitter emitter, float x, float y, Terminal terminal) {
        if (FixedWidthFontRenderer.isCursorVisible(terminal)) {
            byte[] colour = terminal.getPalette().getRenderColours(15 - terminal.getTextColour());
            DirectFixedWidthFontRenderer.drawChar(emitter, x + (float)(terminal.getCursorX() * 6), y + (float)(terminal.getCursorY() * 9), 95, colour);
        }
    }

    public static int getVertexCount(Terminal terminal) {
        return (terminal.getHeight() + 2) * (terminal.getWidth() + 2) * 2;
    }

    private static void quad(QuadEmitter buffer, float x1, float y1, float x2, float y2, float z, byte[] rgba, float u1, float v1, float u2, float v2) {
        buffer.quad(x1, y1, x2, y2, z, rgba, u1, v1, u2, v2);
    }

    static void quad(ByteBuffer buffer, float x1, float y1, float x2, float y2, float z, byte[] rgba, float u1, float v1, float u2, float v2) {
        int position = buffer.position();
        long addr = MemoryUtil.memAddress((ByteBuffer)buffer);
        if (position < 0 || 112 > buffer.limit() - position) {
            throw new IndexOutOfBoundsException();
        }
        if ((addr & 3L) != 0L) {
            throw new IllegalStateException("Memory is not aligned");
        }
        if (rgba.length != 4) {
            throw new IllegalStateException();
        }
        MemoryUtil.memPutFloat((long)(addr + 0L), (float)x1);
        MemoryUtil.memPutFloat((long)(addr + 4L), (float)y1);
        MemoryUtil.memPutFloat((long)(addr + 8L), (float)z);
        MemoryUtil.memPutByte((long)(addr + 12L), (byte)rgba[0]);
        MemoryUtil.memPutByte((long)(addr + 13L), (byte)rgba[1]);
        MemoryUtil.memPutByte((long)(addr + 14L), (byte)rgba[2]);
        MemoryUtil.memPutByte((long)(addr + 15L), (byte)-1);
        MemoryUtil.memPutFloat((long)(addr + 16L), (float)u1);
        MemoryUtil.memPutFloat((long)(addr + 20L), (float)v1);
        MemoryUtil.memPutShort((long)(addr + 24L), (short)240);
        MemoryUtil.memPutShort((long)(addr + 26L), (short)240);
        MemoryUtil.memPutFloat((long)(addr + 28L), (float)x1);
        MemoryUtil.memPutFloat((long)(addr + 32L), (float)y2);
        MemoryUtil.memPutFloat((long)(addr + 36L), (float)z);
        MemoryUtil.memPutByte((long)(addr + 40L), (byte)rgba[0]);
        MemoryUtil.memPutByte((long)(addr + 41L), (byte)rgba[1]);
        MemoryUtil.memPutByte((long)(addr + 42L), (byte)rgba[2]);
        MemoryUtil.memPutByte((long)(addr + 43L), (byte)-1);
        MemoryUtil.memPutFloat((long)(addr + 44L), (float)u1);
        MemoryUtil.memPutFloat((long)(addr + 48L), (float)v2);
        MemoryUtil.memPutShort((long)(addr + 52L), (short)240);
        MemoryUtil.memPutShort((long)(addr + 54L), (short)240);
        MemoryUtil.memPutFloat((long)(addr + 56L), (float)x2);
        MemoryUtil.memPutFloat((long)(addr + 60L), (float)y2);
        MemoryUtil.memPutFloat((long)(addr + 64L), (float)z);
        MemoryUtil.memPutByte((long)(addr + 68L), (byte)rgba[0]);
        MemoryUtil.memPutByte((long)(addr + 69L), (byte)rgba[1]);
        MemoryUtil.memPutByte((long)(addr + 70L), (byte)rgba[2]);
        MemoryUtil.memPutByte((long)(addr + 71L), (byte)-1);
        MemoryUtil.memPutFloat((long)(addr + 72L), (float)u2);
        MemoryUtil.memPutFloat((long)(addr + 76L), (float)v2);
        MemoryUtil.memPutShort((long)(addr + 80L), (short)240);
        MemoryUtil.memPutShort((long)(addr + 82L), (short)240);
        MemoryUtil.memPutFloat((long)(addr + 84L), (float)x2);
        MemoryUtil.memPutFloat((long)(addr + 88L), (float)y1);
        MemoryUtil.memPutFloat((long)(addr + 92L), (float)z);
        MemoryUtil.memPutByte((long)(addr + 96L), (byte)rgba[0]);
        MemoryUtil.memPutByte((long)(addr + 97L), (byte)rgba[1]);
        MemoryUtil.memPutByte((long)(addr + 98L), (byte)rgba[2]);
        MemoryUtil.memPutByte((long)(addr + 99L), (byte)-1);
        MemoryUtil.memPutFloat((long)(addr + 100L), (float)u2);
        MemoryUtil.memPutFloat((long)(addr + 104L), (float)v1);
        MemoryUtil.memPutShort((long)(addr + 108L), (short)240);
        MemoryUtil.memPutShort((long)(addr + 110L), (short)240);
        buffer.position(position + 112);
    }

    public static interface QuadEmitter {
        public VertexFormat format();

        public ByteBuffer buffer();

        public void quad(float var1, float var2, float var3, float var4, float var5, byte[] var6, float var7, float var8, float var9, float var10);
    }

    public record ByteBufferEmitter(ByteBuffer buffer) implements QuadEmitter
    {
        @Override
        public VertexFormat format() {
            return RenderTypes.TERMINAL.format();
        }

        @Override
        public void quad(float x1, float y1, float x2, float y2, float z, byte[] rgba, float u1, float v1, float u2, float v2) {
            DirectFixedWidthFontRenderer.quad(this.buffer, x1, y1, x2, y2, z, rgba, u1, v1, u2, v2);
        }
    }
}

