/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.common.HeldItemMenu;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.media.items.PrintoutItem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PrintoutScreen
extends AbstractContainerScreen<HeldItemMenu> {
    private final boolean book;
    private final int pages;
    private final TextBuffer[] text;
    private final TextBuffer[] colours;
    private int page;

    public PrintoutScreen(HeldItemMenu container, Inventory player, Component title) {
        super((AbstractContainerMenu)container, player, title);
        this.imageHeight = 209;
        PrintoutData printout = (PrintoutData)container.getStack().getOrDefault((DataComponentType)ModRegistry.DataComponents.PRINTOUT.get(), (Object)PrintoutData.EMPTY);
        this.text = new TextBuffer[printout.lines().size()];
        this.colours = new TextBuffer[printout.lines().size()];
        for (int i = 0; i < this.text.length; ++i) {
            PrintoutData.Line line = printout.lines().get(i);
            this.text[i] = new TextBuffer(line.text());
            this.colours[i] = new TextBuffer(line.foreground());
        }
        this.page = 0;
        this.pages = Math.max(this.text.length / 21, 1);
        this.book = ((PrintoutItem)container.getStack().getItem()).getType() == PrintoutItem.Type.BOOK;
    }

    public boolean keyPressed(int key, int scancode, int modifiers) {
        if (key == 262) {
            if (this.page < this.pages - 1) {
                ++this.page;
            }
            return true;
        }
        if (key == 263) {
            if (this.page > 0) {
                --this.page;
            }
            return true;
        }
        return super.keyPressed(key, scancode, modifiers);
    }

    public boolean mouseScrolled(double x, double y, double deltaX, double deltaY) {
        if (super.mouseScrolled(x, y, deltaX, deltaY)) {
            return true;
        }
        if (deltaY < 0.0) {
            if (this.page < this.pages - 1) {
                ++this.page;
            }
            return true;
        }
        if (deltaY > 0.0) {
            if (this.page > 0) {
                --this.page;
            }
            return true;
        }
        return false;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 1.0f);
        PrintoutRenderer.drawBorder(graphics.pose(), (MultiBufferSource)graphics.bufferSource(), this.leftPos, this.topPos, 0.0f, this.page, this.pages, this.book, 0xF000F0);
        PrintoutRenderer.drawText(graphics.pose(), (MultiBufferSource)graphics.bufferSource(), this.leftPos + 13, this.topPos + 11, 21 * this.page, 0xF000F0, this.text, this.colours);
        graphics.pose().popPose();
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
    }
}

