/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.client.turtle;

import com.mojang.math.Transformation;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModeller;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.impl.client.ClientPlatformHelper;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

final class TurtleUpgradeModellers {
    private static final Transformation leftTransform = TurtleUpgradeModellers.getMatrixFor(-0.4065f);
    private static final Transformation rightTransform = TurtleUpgradeModellers.getMatrixFor(0.4065f);
    static final TurtleUpgradeModeller<ITurtleUpgrade> UPGRADE_ITEM = new UpgradeItemModeller();

    TurtleUpgradeModellers() {
    }

    private static Transformation getMatrixFor(float offset) {
        Matrix4f matrix = new Matrix4f();
        matrix.set(new float[]{0.0f, 0.0f, -1.0f, 1.0f + offset, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        matrix.transpose();
        return new Transformation(matrix);
    }

    private static final class UpgradeItemModeller
    implements TurtleUpgradeModeller<ITurtleUpgrade> {
        private UpgradeItemModeller() {
        }

        @Override
        public TransformedModel getModel(ITurtleUpgrade upgrade, @Nullable ITurtleAccess turtle, TurtleSide side, DataComponentPatch data) {
            ItemStack stack = upgrade.getUpgradeItem(data);
            BakedModel model = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(stack);
            if (stack.hasFoil()) {
                model = ClientPlatformHelper.get().createdFoiledModel(model);
            }
            return new TransformedModel(model, side == TurtleSide.LEFT ? leftTransform : rightTransform);
        }
    }
}

