/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.diggusmaximus;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.kyrptonaught.diggusmaximus.DiggusMaximusMod;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3503;

public class ExcavateHelper {
    static int maxMined = Math.min(DiggusMaximusMod.getOptions().maxMinedBlocks, 2048);
    private static double maxDistance = Math.min(DiggusMaximusMod.getOptions().maxMineDistance + 1, 128);

    public static void resetMaximums() {
        maxMined = Math.min(DiggusMaximusMod.getOptions().maxMinedBlocks, 2048);
        maxDistance = Math.min(DiggusMaximusMod.getOptions().maxMineDistance + 1, 128);
    }

    static void pickupDrops(class_1937 world, class_2338 pos, class_1657 player) {
        List drops = world.method_8390(class_1542.class, new class_238(pos), null);
        drops.forEach(item -> {
            class_1799 stack = item.method_6983();
            player.field_7514.method_7394(stack);
            if (stack.method_7947() <= 0) {
                item.method_5650();
            }
        });
    }

    static boolean isTheSameBlock(class_2960 startID, class_2960 newID, class_1937 world) {
        if (DiggusMaximusMod.getGrouping().tagGrouping) {
            class_2248 newBlock = (class_2248)class_2378.field_11146.method_10223(newID);
            for (class_2960 tagID : ExcavateHelper.getTagsFor((class_3503<class_2248>)world.method_8514().method_15202(), (class_2248)class_2378.field_11146.method_10223(startID))) {
                if (!TagRegistry.block((class_2960)tagID).method_15141((Object)newBlock)) continue;
                newID = startID;
                break;
            }
        }
        if (DiggusMaximusMod.getGrouping().customGrouping) {
            newID = DiggusMaximusMod.getIDFromConfigLookup(newID);
            startID = DiggusMaximusMod.getIDFromConfigLookup(startID);
        }
        return startID.equals((Object)newID);
    }

    static Collection<class_2960> getTagsFor(class_3503<class_2248> container, class_2248 object) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry identifierTagEntry : container.method_15196().entrySet()) {
            if (!((class_3494)identifierTagEntry.getValue()).method_15141((Object)object)) continue;
            list.add(identifierTagEntry.getKey());
        }
        return list;
    }

    static boolean configAllowsMining(String blockID) {
        return DiggusMaximusMod.getBlackList().isWhitelist == DiggusMaximusMod.getBlackList().blacklistedBlocks.contains(blockID);
    }

    static boolean isValidPos(class_2338 pos) {
        return Math.abs(pos.method_10263()) + Math.abs(pos.method_10264()) + Math.abs(pos.method_10260()) != 0;
    }

    static class_2248 getBlockAt(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_11614();
    }

    static boolean canMine(class_1657 player, class_1792 tool, class_2338 startPos, class_2338 pos) {
        return ExcavateHelper.isWithinDistance(startPos, pos) && ExcavateHelper.checkTool(player, tool);
    }

    private static boolean isWithinDistance(class_2338 startPos, class_2338 pos) {
        return pos.method_19771((class_2382)startPos, maxDistance);
    }

    private static boolean checkTool(class_1657 player, class_1792 tool) {
        if (player.method_7337()) {
            return true;
        }
        class_1799 heldItem = player.method_6047();
        if (DiggusMaximusMod.getOptions().dontBreakTool && heldItem.method_7919() + 1 == tool.method_7841()) {
            return false;
        }
        if (heldItem.method_7909() != tool && (DiggusMaximusMod.getOptions().stopOnToolBreak || DiggusMaximusMod.getOptions().requiresTool)) {
            return false;
        }
        return ExcavateHelper.isTool(heldItem.method_7909()) || !DiggusMaximusMod.getOptions().requiresTool;
    }

    private static boolean isTool(class_1792 isTool) {
        return isTool.method_7846() || DiggusMaximusMod.getOptions().tools.contains(class_2378.field_11142.method_10221((Object)isTool).toString());
    }
}

