function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/world/server/ServerWorld',
		'methodName' : resolveName('func_217393_a'), // onBlockStateChange
		'methodDesc' : '(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/BlockState;)V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/forge/events/BlockStateChangeEvent',
		'methodName' : 'onBlockStateChange',
		'methodDesc' : '(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/BlockState;)V'
	}

	var instructions = [ 
		insnLoadObj(0, "world"), 
		insnLoadObj(1, "pos"),
		insnLoadObj(2, "oldState"),
		insnLoadObj(3, "newState"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions);
				return method;
			}
		}
	}
}