/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.fluid;

import com.blakebr0.cucumber.iface.IFluidHolder;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BaseFluidHolderItem
extends FluidTank
implements IFluidHandlerItem {
    private final IFluidHolder holder;
    private final ItemStack stack;

    public BaseFluidHolderItem(ItemStack stack, IFluidHolder holder) {
        super(holder.getCapacity(stack));
        this.stack = stack;
        this.holder = holder;
    }

    public ItemStack getContainer() {
        return this.stack;
    }

    public FluidStack getFluid() {
        return this.holder.getFluid(this.stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.holder.fill(this.stack, resource, action.execute());
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.holder.drain(this.stack, maxDrain, action.execute());
    }
}

