/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.world.GameWorld;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HopperBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class WorldSearch {

    public static abstract class VertCylinder
    extends BlockChain {
        protected final IntBounds heightBounds;
        protected final int maxRadius;

        protected VertCylinder(IWorld level, BlockPos startPos, IntBounds heightBounds, int maxRadius) {
            super(level, startPos, MathHelper.func_76143_f((double)(Math.PI * (double)MathHelper.func_233022_k_((float)maxRadius) * (double)(heightBounds.length() + 1))));
            this.heightBounds = heightBounds;
            this.maxRadius = maxRadius;
        }

        @Override
        protected Collection<Direction> getDirections() {
            return GameWorld.Directions.of().all().shuffle().toList();
        }

        @Override
        protected boolean isOutsideBounds(BlockPos pos) {
            if (!this.heightBounds.encloses(pos.func_177956_o())) {
                return true;
            }
            int dx = pos.func_177958_n() - this.startPos.func_177958_n();
            int dz = pos.func_177952_p() - this.startPos.func_177952_p();
            if (MathHelper.func_233022_k_((float)dx) + MathHelper.func_233022_k_((float)dz) > MathHelper.func_233022_k_((float)this.maxRadius)) {
                return true;
            }
            return super.isOutsideBounds(pos);
        }
    }

    public static class Column
    extends BlockChain {
        private static final List<Direction> DIRECTIONS = GameWorld.Directions.of().up().down().toList();
        private final BlockState validState;
        private BlockPos top;
        private BlockPos bottom;

        public static Column from(IWorld world, BlockPos pos) {
            Column column = new Column(world, pos, world.func_234938_ad_());
            column.build();
            return column;
        }

        protected Column(IWorld world, BlockPos pos, int maxLength) {
            super(world, pos, maxLength);
            this.validState = world.func_180495_p(pos);
            this.top = pos;
            this.bottom = pos;
        }

        @Override
        protected Collection<Direction> getDirections() {
            return DIRECTIONS;
        }

        @Override
        protected boolean isValidPath(BlockPos pos) {
            return this.isValidBlock(pos);
        }

        @Override
        protected boolean isValidBlock(BlockPos pos) {
            BlockState state = this.world.func_180495_p(pos);
            return this.validState.func_177230_c() == state.func_177230_c();
        }

        @Override
        protected boolean onValidFound(BlockPos pos) {
            if (pos.func_177956_o() > this.top.func_177956_o()) {
                this.top = pos;
            }
            if (pos.func_177956_o() < this.bottom.func_177956_o()) {
                this.bottom = pos;
            }
            return true;
        }

        public BlockPos getTop() {
            return this.top;
        }

        public BlockPos getBottom() {
            return this.bottom;
        }
    }

    public static abstract class VentPipe
    extends BlockChain {
        public static final BlockChain.BlockFunc VALID_CHIMNEY_BLOCK = GameWorld.SmokeContainers::isChimney;
        protected int count = 0;

        protected VentPipe(IWorld level, BlockPos startPos) {
            super(level, startPos, (Integer)GameWorld.SmokeContainers.maxVentPipeLength.get() + 1);
        }

        public int getCount() {
            return this.count;
        }

        @Override
        protected Collection<Direction> getDirections() {
            return GameWorld.Directions.of().horizontals().shuffle().toList();
        }

        @Override
        protected boolean isValidPath(BlockPos pos) {
            return GameWorld.SmokeContainers.isVent((IWorldReader)this.getWorld(), pos);
        }

        @Override
        public void build() {
            this.count = 0;
            super.build();
        }

        public static int pump(final IWorld level, List<BlockPos> startPositions, int maxAmount, final BlockChain.BlockFunc validOutlet, final PumpFunc onPump) {
            int count = 0;
            if (count >= maxAmount) {
                return count;
            }
            ArrayList<1> ventPipes = new ArrayList<1>();
            block0: for (BlockPos pos : startPositions) {
                for (VentPipe ventPipe : ventPipes) {
                    if (!ventPipe.getChain().contains(pos)) continue;
                    continue block0;
                }
                Output pipe = new Output(level, pos, maxAmount){

                    @Override
                    protected boolean isValidOutlet(BlockPos pos) {
                        return validOutlet.apply(level, pos);
                    }

                    @Override
                    protected int onPump(BlockPos pos, int max) {
                        return onPump.apply(level, pos, max);
                    }
                };
                pipe.build();
                ventPipes.add(pipe);
                if ((count += pipe.getCount()) < maxAmount) continue;
                return count;
            }
            return count;
        }

        public static int suck(IWorld level, BlockPos pumpPos) {
            return VentPipe.suck(level, pumpPos, pumpPos);
        }

        public static int suck(IWorld level, BlockPos startPos, BlockPos pumpPos) {
            Input pipe = new Input(level, startPos, pumpPos);
            pipe.build();
            return pipe.getCount();
        }

        @FunctionalInterface
        public static interface PumpFunc {
            public int apply(IWorld var1, BlockPos var2, int var3);
        }

        public static abstract class Output
        extends VentPipe {
            protected final int maxAmount;

            protected Output(IWorld level, BlockPos startPos, int maxAmount) {
                super(level, startPos);
                this.maxAmount = maxAmount;
            }

            @Override
            protected boolean isValidBlock(BlockPos pos) {
                if (this.lastUsedDirection != null && this.getWorld().func_180495_p(pos).func_224755_d((IBlockReader)this.getWorld(), pos, this.lastUsedDirection.func_176734_d())) {
                    return false;
                }
                return this.isValidOutlet(pos);
            }

            @Override
            protected boolean onValidFound(BlockPos pos) {
                if (this.count >= this.maxAmount) {
                    return false;
                }
                this.count += this.onPump(pos, this.maxAmount - this.count);
                return this.count < this.maxAmount;
            }

            protected abstract boolean isValidOutlet(BlockPos var1);

            protected abstract int onPump(BlockPos var1, int var2);
        }

        public static class Input
        extends VentPipe {
            protected final BlockPos pumpPos;

            protected Input(IWorld level, BlockPos startPos, BlockPos pumpPos) {
                super(level, startPos);
                this.pumpPos = pumpPos;
            }

            @Override
            protected boolean isValidPath(BlockPos pos) {
                return super.isValidPath(pos) || this.getStartPos().equals((Object)pos) && GameWorld.SmokeContainers.isPump((IWorldReader)this.getWorld(), pos);
            }

            @Override
            protected boolean isValidBlock(BlockPos pos) {
                return GameWorld.SmokeContainers.isVentOrPump((IWorldReader)this.getWorld(), pos);
            }

            @Override
            protected boolean onValidFound(BlockPos foundPos) {
                ArrayList<Direction> directions = new ArrayList<Direction>();
                directions.add(Direction.DOWN);
                directions.addAll(GameWorld.Directions.of().horizontals().shuffle().toList());
                IWorld level = this.getWorld();
                block0: for (Direction facing : directions) {
                    for (int dist = 1; !(dist > (Integer)GameWorld.SmokeContainers.ventReachDistance.get() || level.func_180495_p(foundPos).func_224755_d((IBlockReader)level, foundPos, facing) || facing == Direction.DOWN && dist > 1); ++dist) {
                        IPollutant pollutant;
                        BlockPos pos = foundPos.func_177967_a(facing, dist);
                        BlockState state = level.func_180495_p(pos);
                        if (state.func_196958_f()) continue;
                        if (state.func_224755_d((IBlockReader)level, pos, facing.func_176734_d())) continue block0;
                        if (state.func_177230_c() instanceof IPollutant && (pollutant = (IPollutant)state.func_177230_c()).getPollutantType() == IPollutant.Type.AIR) {
                            List<BlockPos> pumps = Collections.singletonList(this.pumpPos);
                            int maxAmount = pollutant.getCarriedPollutionAmount(state);
                            this.count = GameWorld.SmokeContainers.pumpPollutionThrough(pumps, level, pollutant, maxAmount);
                            if (this.count > 0) {
                                pollutant.spend(level, pos, this.count);
                            }
                            return false;
                        }
                        if (state.func_224755_d((IBlockReader)level, pos, facing)) continue block0;
                    }
                }
                return true;
            }
        }
    }

    public static class TileNeighbors
    extends BlockChain {
        protected final List<BlockPos> aboveBlocks = new ArrayList<BlockPos>();
        protected final List<BlockPos> sideBlocks = new ArrayList<BlockPos>();
        protected final List<BlockPos> underBlocks = new ArrayList<BlockPos>();
        protected final Set<BlockState> relatedBlocks;
        protected BlockState masterState;

        protected TileNeighbors(IWorld world, BlockPos startPos, int maxBlocksInTile, Set<BlockState> relatedBlocks) {
            super(world, startPos, maxBlocksInTile);
            this.relatedBlocks = relatedBlocks;
        }

        public static TileNeighbors from(TileEntity tile, Set<BlockState> relatedBlocks) {
            TileNeighbors neighbours = new TileNeighbors((IWorld)tile.func_145831_w(), tile.func_174877_v(), (Integer)GameWorld.SmokeContainers.maxBlocksInMultiblock.get(), relatedBlocks);
            neighbours.build();
            return neighbours;
        }

        public static TileNeighbors from(IWorld world, BlockPos startPos, Set<BlockState> relatedBlocks) {
            TileNeighbors neighbours = new TileNeighbors(world, startPos, (Integer)GameWorld.SmokeContainers.maxBlocksInMultiblock.get(), relatedBlocks);
            neighbours.build();
            return neighbours;
        }

        @Override
        public void build() {
            this.masterState = this.world.func_180495_p(this.startPos);
            this.aboveBlocks.clear();
            this.sideBlocks.clear();
            this.underBlocks.clear();
            super.build();
        }

        public boolean isMultiblockHollow(BlockPos pos) {
            int minSideLen = 3;
            int maxSideLen = this.maxLength / 9;
            if (maxSideLen < 3) {
                return false;
            }
            int maxHollowLen = maxSideLen - 2;
            block0: for (Direction facing : this.getDirections()) {
                for (int n = 1; n <= maxHollowLen; ++n) {
                    if (this.getChain().contains(pos.func_177967_a(facing, n))) continue block0;
                }
                return false;
            }
            return true;
        }

        @Override
        protected boolean isValidPath(BlockPos pos) {
            if (this.lastUsedDirection == null) {
                return true;
            }
            BlockState state = this.world.func_180495_p(pos);
            if (this.relatedBlocks.contains(state)) {
                return true;
            }
            TileEntity tile = this.world.func_175625_s(pos);
            return tile != null && this.masterState == state;
        }

        @Override
        protected boolean isValidBlock(BlockPos pos) {
            return !this.isValidPath(pos);
        }

        @Override
        protected boolean onValidFound(BlockPos pos) {
            if (this.lastUsedDirection != null) {
                switch (this.lastUsedDirection) {
                    case DOWN: {
                        this.underBlocks.add(pos);
                        break;
                    }
                    case UP: {
                        this.aboveBlocks.add(pos);
                        break;
                    }
                    default: {
                        this.sideBlocks.add(pos);
                    }
                }
            }
            return true;
        }

        public List<BlockPos> getAboveBlocks() {
            return this.aboveBlocks;
        }

        public List<BlockPos> getSideBlocks() {
            return this.sideBlocks;
        }

        public List<BlockPos> getUnderBlocks() {
            return this.underBlocks;
        }

        @Deprecated
        public List<BlockPos> getActivePumps() {
            IWorld level = this.getWorld();
            ArrayList<BlockPos> activePumps = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getUnderBlocks()) {
                Block block;
                if (GameWorld.SmokeContainers.isChimney((IWorldReader)level, pos)) {
                    pos = GameWorld.SmokeContainers.getBottommostChimney((IWorldReader)level, pos).func_177977_b();
                }
                if (level.func_180495_p(pos).func_177230_c() instanceof HopperBlock && (block = level.func_180495_p(pos = pos.func_177977_b()).func_177230_c()) instanceof IPole) {
                    pos = ((IPole)block).getBottom((IWorldReader)level, pos).func_177977_b();
                }
                if (!GameWorld.SmokeContainers.isActivePump((IWorldReader)level, pos)) continue;
                activePumps.add(pos);
            }
            return activePumps;
        }

        @Deprecated
        public List<BlockPos> getActiveVents() {
            ArrayList<BlockPos> activeVents = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getActivePumps()) {
                activeVents.addAll(GameWorld.SmokeContainers.getVentsAround((IWorldReader)this.getWorld(), pos));
            }
            return activeVents;
        }

        public List<BlockPos> getTopActivePumps(int maxGapLength) {
            ArrayList<BlockPos> startPositions = new ArrayList<BlockPos>();
            startPositions.addAll(this.getTopPipeOutlets(true, GameWorld.SmokeContainers::isVentOrChimney));
            startPositions.addAll(this.getAboveBlocks(GameWorld.SmokeContainers::isVentOrChimney, maxGapLength));
            return GameWorld.SmokeContainers.getClosestActiveExhaustPumps(this.getWorld(), startPositions);
        }

        public List<BlockPos> getSideActivePumps() {
            return GameWorld.SmokeContainers.getClosestActiveExhaustPumps(this.getWorld(), GameWorld.SmokeContainers.getOnly((IWorldReader)this.getWorld(), this.getSideBlocks(), GameWorld.SmokeContainers::isVentOrPump));
        }

        public List<BlockPos> getBottomActivePumps() {
            return this.getUnderBlocks().stream().map(pos -> GameWorld.SmokeContainers.getConnectedActiveReversedPump((IWorldReader)this.getWorld(), pos)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }

        public List<BlockPos> getAboveBlocks(BiPredicate<IWorldReader, BlockPos> filter, int maxGapLength) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            block0: for (BlockPos startPos : this.getAboveBlocks()) {
                for (int i = 0; i <= maxGapLength; ++i) {
                    BlockPos pos = startPos.func_177981_b(i);
                    if (filter.test((IWorldReader)this.getWorld(), pos)) {
                        blocks.add(pos);
                        continue block0;
                    }
                    if (!this.getWorld().func_175623_d(pos)) continue block0;
                }
            }
            return blocks;
        }

        public List<BlockPos> getTopPassableChimneys(int maxGapLength) {
            return this.getAboveBlocks((lev, pos) -> GameWorld.SmokeContainers.isChimney(lev, pos) && GameWorld.SmokeContainers.hasWayOut(lev, pos), maxGapLength);
        }

        public List<BlockPos> getTopPipeOutlets(boolean onlyWithHopper, BiPredicate<IWorldReader, BlockPos> filter) {
            IWorld level = this.getWorld();
            return this.getAboveBlocks(GameWorld.SmokeContainers::isPipe, 0).stream().map(pos -> GameWorld.SmokeContainers.getTopmostPipe((IWorldReader)level, pos)).map(pos -> GameWorld.SmokeContainers.getConnectedHopper((IWorldReader)level, pos).orElse((BlockPos)pos)).filter(pos -> !onlyWithHopper || GameWorld.SmokeContainers.isHopper((IWorldReader)level, pos)).map(pos -> pos.func_177984_a()).filter(pos -> filter.test((IWorldReader)level, (BlockPos)pos)).collect(Collectors.toList());
        }

        @Deprecated
        public List<BlockPos> getTopChimneys() {
            ArrayList<BlockPos> chimneys = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getAboveBlocks()) {
                if (!GameWorld.SmokeContainers.isChimney((IWorldReader)this.getWorld(), pos)) continue;
                chimneys.add(pos);
            }
            return chimneys;
        }

        @Deprecated
        public List<BlockPos> getSideChimneys() {
            ArrayList<BlockPos> chimneys = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getSideBlocks()) {
                if (!GameWorld.SmokeContainers.isChimney((IWorldReader)this.getWorld(), pos)) continue;
                chimneys.add(pos);
            }
            return chimneys;
        }

        @Deprecated
        public List<BlockPos> getPassiveVents() {
            ArrayList<BlockPos> passiveVents = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getSideBlocks()) {
                if (!GameWorld.SmokeContainers.isVent((IWorldReader)this.getWorld(), pos)) continue;
                passiveVents.add(pos);
            }
            return passiveVents;
        }
    }

    public static abstract class BlockChain {
        private static final List<Direction> DIRECTIONS = ImmutableList.copyOf((Object[])Direction.values());
        protected final IWorld world;
        protected final BlockPos startPos;
        protected final List<BlockPos> blockChain;
        protected final List<BlockPos> foundBlocks;
        protected final int maxLength;
        protected boolean breakSearch = false;
        @Nullable
        protected Direction lastUsedDirection = null;

        public BlockChain(IWorld level, BlockPos startPos, int maxLength) {
            this.world = level;
            this.startPos = startPos;
            this.maxLength = maxLength;
            this.blockChain = new ArrayList<BlockPos>();
            this.foundBlocks = new ArrayList<BlockPos>();
        }

        public static BlockChain simple(IWorld level, BlockPos startPos, int maxLength, final Supplier<Collection<Direction>> directions, final BlockFunc validPath, final BlockFunc validBlock, final BlockFunc validFound) {
            BlockChain chain = new BlockChain(level, startPos, maxLength){

                @Override
                protected Collection<Direction> getDirections() {
                    return (Collection)directions.get();
                }

                @Override
                protected boolean onValidFound(BlockPos pos) {
                    return validFound.apply(this.world, pos);
                }

                @Override
                protected boolean isValidPath(BlockPos pos) {
                    return validPath.apply(this.world, pos);
                }

                @Override
                protected boolean isValidBlock(BlockPos pos) {
                    return validBlock.apply(this.world, pos);
                }
            };
            chain.build();
            return chain;
        }

        protected abstract boolean isValidPath(BlockPos var1);

        protected abstract boolean isValidBlock(BlockPos var1);

        protected abstract boolean onValidFound(BlockPos var1);

        public void build() {
            this.lastUsedDirection = null;
            this.breakSearch = false;
            this.blockChain.clear();
            this.foundBlocks.clear();
            this.search();
        }

        protected boolean isOutsideBounds(BlockPos pos) {
            return World.func_189509_E((BlockPos)pos) || !GameWorld.isBlockLoaded((IWorldReader)this.getWorld(), pos);
        }

        protected Collection<Direction> getDirections() {
            return DIRECTIONS;
        }

        public BlockPos getStartPos() {
            return this.startPos;
        }

        public IWorld getWorld() {
            return this.world;
        }

        public List<BlockPos> getChain() {
            return this.blockChain;
        }

        public List<BlockPos> getFound() {
            return this.foundBlocks;
        }

        public int length() {
            return this.blockChain.size();
        }

        protected void search() {
            ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
            stack.push(new StackEntry(this.startPos));
            while (!stack.isEmpty()) {
                if (this.length() >= this.maxLength) {
                    return;
                }
                StackEntry entry = (StackEntry)stack.peek();
                BlockPos pos = entry.getPos();
                if (!entry.isChecked()) {
                    if (this.isOutsideBounds(pos)) {
                        stack.pop();
                        continue;
                    }
                    if (this.isValidBlock(pos) && !this.foundBlocks.contains(pos)) {
                        this.foundBlocks.add(pos);
                        boolean bl = this.breakSearch = !this.onValidFound(pos);
                    }
                    if (!this.isValidPath(pos) || this.blockChain.contains(pos)) {
                        stack.pop();
                        continue;
                    }
                    this.blockChain.add(pos);
                    entry.setChecked();
                }
                if (this.breakSearch) {
                    return;
                }
                Direction direction = entry.getNextDirection().orElse(null);
                if (direction != null) {
                    stack.push(new StackEntry(pos.func_177972_a(direction)));
                    this.lastUsedDirection = direction;
                    continue;
                }
                stack.pop();
            }
        }

        @FunctionalInterface
        public static interface BlockFunc {
            public boolean apply(IWorld var1, BlockPos var2);
        }

        protected class StackEntry {
            protected final BlockPos pos;
            protected Deque<Direction> directions;
            protected boolean checked = false;

            public StackEntry(BlockPos pos) {
                this.pos = pos;
            }

            public BlockPos getPos() {
                return this.pos;
            }

            public Optional<Direction> getNextDirection() {
                if (this.directions == null) {
                    this.directions = new ArrayDeque<Direction>(BlockChain.this.getDirections());
                }
                if (this.directions.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(this.directions.pop());
            }

            public boolean isChecked() {
                return this.checked;
            }

            public void setChecked() {
                this.checked = true;
            }
        }
    }
}

