/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.events.ChunkFullyLoadedEvent;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

public final class GameWorld {
    public static boolean isWeather2Loaded = false;

    public static boolean isBlockLoaded(IWorldReader world, BlockPos pos) {
        return world.func_175667_e(pos);
    }

    public static boolean isAirBlock(IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos).isAir((IBlockReader)world, pos);
    }

    public static boolean isWaterBlock(IWorldReader world, BlockPos pos) {
        return world.func_204610_c(pos).func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a);
    }

    public static boolean isWaterSource(IWorldReader world, BlockPos pos) {
        FluidState state = world.func_204610_c(pos);
        return state.func_206889_d() && state.func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a);
    }

    public static boolean isLavaBlock(IWorldReader world, BlockPos pos) {
        return world.func_204610_c(pos).func_206886_c().func_207185_a((ITag)FluidTags.field_206960_b);
    }

    public static boolean isLavaSource(IWorldReader world, BlockPos pos) {
        FluidState state = world.func_204610_c(pos);
        return state.func_206889_d() && state.func_206886_c().func_207185_a((ITag)FluidTags.field_206960_b);
    }

    public static boolean isOreBlock(IWorldReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return Tags.Blocks.ORES.func_230235_a_((Object)state.func_177230_c());
    }

    public static IWind getWindAt(World world, BlockPos pos) {
        WorldData data = GameWorld.getData((IWorld)world);
        BiomeId biome = BiomeId.from((IWorld)world, pos);
        return data.getWind(biome);
    }

    public static void explodeBlock(ServerWorld world, BlockPos pos, float explosionSize, boolean causesFire, Explosion.Mode mode, boolean dropBlock, @Nullable Entity exploder) {
        BlockState state = world.func_180495_p(pos);
        if (dropBlock) {
            TileEntity tileentity = state.hasTileEntity() ? world.func_175625_s(pos) : null;
            Block.func_220059_a((BlockState)state, (IWorld)world, (BlockPos)pos, (TileEntity)tileentity);
        }
        world.func_217398_a(exploder, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), explosionSize, causesFire, mode);
        world.func_217377_a(pos, false);
    }

    public static void scheduleBlockExplosion(ServerWorld world, BlockPos pos, CommonTime.Interval delay, float size, boolean fire, Explosion.Mode mode, boolean dropAsItem, @Nullable Entity exploder) {
        WorldData data = GameWorld.getData((IWorld)world);
        ScheduledExplosion explosion = new ScheduledExplosion(world, pos, delay, size, fire, mode, dropAsItem, exploder);
        data.scheduledExplosions.put(pos, explosion);
    }

    public static boolean isServerSide(IWorldReader world) {
        return !world.func_201670_d();
    }

    public static boolean isClientSide(IWorldReader world) {
        return world.func_201670_d();
    }

    public static Optional<Entity> getEntity(World world, int id) {
        return world != null ? Optional.ofNullable(world.func_73045_a(id)) : Optional.empty();
    }

    public static Vect3d getBlockCenter(BlockPos pos) {
        return Vect3d.from(pos).add(GameMath.getBBCenter(ForgeBlock.FULL_BLOCK_AABB));
    }

    public static Chunk getChunk(World world, ChunkPos pos) {
        return world.func_212866_a_(pos.field_77276_a, pos.field_77275_b);
    }

    public static boolean isForgeBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof ForgeBlock;
    }

    public static boolean setBlockState(IWorldWriter world, BlockPos pos, BlockState state) {
        return world.func_180501_a(pos, state, 3);
    }

    public static void spawnParticle(World world, Vect3d pos, Vect3d motion, IParticleData particleData) {
        world.func_195594_a(particleData, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
    }

    public static Optional<BlockRayTraceResult> rayTraceBlocks(World world, Vect3d start, Vect3d end, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode, Entity entity) {
        RayTraceContext context = new RayTraceContext(start.toVector3d(), end.toVector3d(), blockMode, fluidMode, entity);
        BlockRayTraceResult hit = world.func_217299_a(context);
        return hit != null && hit.func_216346_c() != RayTraceResult.Type.MISS ? Optional.of(hit) : Optional.empty();
    }

    @Nonnull
    public static WorldData getData(IWorld world) {
        WorldData data = WorldData.DATA_MAP.get(world);
        if (data == null) {
            data = new WorldData(world);
            WorldData.DATA_MAP.put(world, data);
        }
        return data;
    }

    @Mod.EventBusSubscriber
    public static class WorldData {
        static final Map<IWorld, WorldData> DATA_MAP = new ConcurrentHashMap<IWorld, WorldData>();
        public int smokeParticlesCount = 0;
        protected final Map<BiomeId, Wind> biomeWindMap = new ConcurrentHashMap<BiomeId, Wind>();
        protected final Map<BlockPos, ScheduledExplosion> scheduledExplosions = new ConcurrentHashMap<BlockPos, ScheduledExplosion>();
        protected final Deque<Chunk> freshlyLoadedChunks = new ConcurrentLinkedDeque<Chunk>();
        private final IWorld world;

        public WorldData(IWorld world) {
            this.world = world;
        }

        public IWorld getWorld() {
            return this.world;
        }

        @SubscribeEvent
        public static void onWorldLoad(WorldEvent.Load event) {
            IWorld world = event.getWorld();
            if (GameWorld.isServerSide((IWorldReader)world)) {
                WorldData data = GameWorld.getData(world);
                data.initBiomesWinds();
            }
        }

        @SubscribeEvent
        public static void onWorldUnload(WorldEvent.Unload event) {
            IWorld world = event.getWorld();
            DATA_MAP.remove(world);
        }

        @SubscribeEvent
        public static void onWorldTick(TickEvent.WorldTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            World world = event.world;
            WorldData data = GameWorld.getData((IWorld)world);
            Wind.defaultWind.update(world);
            for (Wind wind : data.biomeWindMap.values()) {
                wind.update(world);
            }
            if (world instanceof ServerWorld) {
                Iterator<Object> iterator = data.freshlyLoadedChunks.iterator();
                while (iterator.hasNext()) {
                    Chunk chunk = iterator.next();
                    ChunkPos chunkPos = chunk.func_76632_l();
                    if (!world.func_72863_F().func_73149_a(chunkPos.field_77276_a, chunkPos.field_77275_b)) continue;
                    ChunkFullyLoadedEvent.onChunkFullyLoaded((ServerWorld)world, chunk);
                    iterator.remove();
                }
                iterator = data.scheduledExplosions.values().iterator();
                while (iterator.hasNext()) {
                    ScheduledExplosion explosion = (ScheduledExplosion)iterator.next();
                    if (!explosion.timePast()) continue;
                    GameWorld.explodeBlock((ServerWorld)world, explosion.pos, explosion.size, explosion.fire, explosion.mode, explosion.dropAsItem, explosion.exploder);
                    iterator.remove();
                    break;
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            PlayerEntity player = event.getPlayer();
            World world = player.field_70170_p;
            if (GameWorld.isServerSide((IWorldReader)world) && player instanceof ServerPlayerEntity) {
                WorldData data = GameWorld.getData((IWorld)world);
                for (Wind wind : data.biomeWindMap.values()) {
                    Wind.WindMsg message = new Wind.WindMsg(wind);
                    ForgeEndertech.getInstance().getConnection().sendToPlayer(message, (ServerPlayerEntity)player);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            World world = event.player.field_70170_p;
            if (GameWorld.isClientSide((IWorldReader)world)) {
                Wind.defaultWind.update(world);
                WorldData data = GameWorld.getData((IWorld)world);
                for (Wind wind : data.biomeWindMap.values()) {
                    wind.update(world);
                }
            }
        }

        @SubscribeEvent
        public static void onChunkLoad(ChunkEvent.Load event) {
            Chunk chunk;
            World world;
            if (event.getChunk() instanceof Chunk && (world = (chunk = (Chunk)event.getChunk()).func_177412_p()) instanceof ServerWorld) {
                GameWorld.getData((IWorld)world).freshlyLoadedChunks.addLast(chunk);
            }
        }

        @SubscribeEvent
        public static void onChunkUnload(ChunkEvent.Unload event) {
            Chunk chunk;
            World world;
            if (event.getChunk() instanceof Chunk && (world = (chunk = (Chunk)event.getChunk()).func_177412_p()) instanceof ServerWorld) {
                GameWorld.getData((IWorld)world).freshlyLoadedChunks.removeAll(Collections.singleton(chunk));
            }
        }

        protected void initBiomesWinds() {
            ForgeRegistries.BIOMES.getEntries().stream().findFirst().map(entry -> BiomeId.from((RegistryKey<Biome>)((RegistryKey)entry.getKey()))).ifPresent(biome -> Wind.from(Biomes.createConfigFor(ForgeEndertech.getInstance(), biome, false), biome));
            for (Path path : UnitConfig.listCustomConfigs(Biomes.getConfigsBaseDir(ForgeEndertech.getInstance()), null)) {
                UnitConfig config = new UnitConfig(path.toFile());
                BiomeId biome2 = Biomes.readBiomeId(config);
                boolean enabled = Biomes.isConfigEnabled(config);
                Wind wind = Wind.from(config, biome2);
                if (!enabled || biome2.isEmpty() || wind.equalsDefault()) continue;
                this.biomeWindMap.put(biome2, wind);
            }
        }

        @Nonnull
        public Wind getWind(BiomeId biome) {
            return this.biomeWindMap.getOrDefault(biome, Wind.defaultWind);
        }
    }

    public static class ScheduledExplosion {
        public final ServerWorld world;
        public final BlockPos pos;
        public final CommonTime.Interval delay;
        public final float size;
        public final boolean fire;
        public final boolean dropAsItem;
        public final Explosion.Mode mode;
        @Nullable
        public final Entity exploder;
        protected final CommonTime.Stamp stamp = CommonTime.Stamp.now();

        public ScheduledExplosion(ServerWorld world, BlockPos pos, CommonTime.Interval delay, float size, boolean fire, Explosion.Mode mode, boolean dropAsItem, Entity exploder) {
            this.world = world;
            this.pos = pos;
            this.delay = delay;
            this.size = size;
            this.fire = fire;
            this.dropAsItem = dropAsItem;
            this.exploder = exploder;
            this.mode = mode;
        }

        public boolean timePast() {
            return CommonTime.Interval.passedFrom(this.stamp).moreThan(this.delay);
        }
    }

    public static class SmokeContainers<C extends ISmokeContainer> {
        public static ForgeConfigSpec.ConfigValue<Integer> maxVentPipeLength;
        public static ForgeConfigSpec.ConfigValue<Integer> ventReachDistance;
        public static ForgeConfigSpec.ConfigValue<Integer> maxBlocksInMultiblock;
        public static ForgeConfigSpec.ConfigValue<Integer> pumpedChimneyAirflow;
        public static ForgeConfigSpec.ConfigValue<List<? extends String>> suctionHoppersList;
        public static BlockStatesMap<Integer> suctionHoppers;

        public static boolean isChimney(IWorldReader world, BlockPos pos) {
            Block block = world.func_180495_p(pos).func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.CHIMNEY);
        }

        public static boolean isOpaqueChimney(IWorldReader level, BlockPos pos) {
            return SmokeContainers.isChimney(level, pos) && level.func_180495_p(pos).func_185904_a().func_76218_k();
        }

        public static boolean isVent(IWorldReader level, BlockPos pos) {
            Block block = level.func_180495_p(pos).func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.VENT);
        }

        public static boolean isPump(IWorldReader level, BlockPos pos) {
            Block block = level.func_180495_p(pos).func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.PUMP);
        }

        public static boolean isPipe(IWorldReader level, BlockPos pos) {
            Block block = level.func_180495_p(pos).func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.PIPE) || block instanceof IPole;
        }

        public static boolean isVentOrPump(IWorldReader level, BlockPos pos) {
            return SmokeContainers.isVent(level, pos) || SmokeContainers.isPump(level, pos);
        }

        public static boolean isVentOrChimney(IWorldReader level, BlockPos pos) {
            return SmokeContainers.isVent(level, pos) || SmokeContainers.isChimney(level, pos);
        }

        public static boolean isActive(IWorldReader world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).isActive((IBlockReader)world, pos);
        }

        public static boolean isActivePump(IWorldReader level, BlockPos pos) {
            return SmokeContainers.isPump(level, pos) && SmokeContainers.isActive(level, pos);
        }

        public static boolean isActiveExhaustPump(IWorldReader level, BlockPos pos) {
            return SmokeContainers.isExhaustPump(level, pos) && SmokeContainers.isActive(level, pos);
        }

        public static boolean isActiveReversedPump(IWorldReader level, BlockPos pos) {
            return SmokeContainers.isReversedPump(level, pos) && SmokeContainers.isActive(level, pos);
        }

        public static boolean isExhaustPump(IWorldReader level, BlockPos pos) {
            return SmokeContainers.isPump(level, pos) && !SmokeContainers.getConnectedHopper(level, pos).isPresent();
        }

        public static boolean isReversedPump(IWorldReader level, BlockPos pos) {
            return SmokeContainers.isPump(level, pos) && SmokeContainers.getConnectedHopper(level, pos).isPresent();
        }

        public static boolean isHopper(IWorldReader level, BlockPos pos) {
            return suctionHoppers.containsKey(level.func_180495_p(pos));
        }

        public static int getHopperSuctionRange(IWorldReader level, BlockPos pos) {
            return Optional.ofNullable(suctionHoppers.get(level.func_180495_p(pos))).orElse(0);
        }

        public static Optional<BlockPos> getConnectedHopper(IWorldReader level, BlockPos pos) {
            if (SmokeContainers.isVent(level, pos)) {
                pos = pos.func_177977_b();
            }
            if (SmokeContainers.isChimney(level, pos)) {
                pos = SmokeContainers.getBottommostChimney(level, pos).func_177977_b();
            }
            if (SmokeContainers.isPump(level, pos)) {
                pos = pos.func_177984_a();
            }
            if (SmokeContainers.isPipe(level, pos)) {
                pos = SmokeContainers.getTopmostPipe(level, pos).func_177984_a();
            }
            return SmokeContainers.isHopper(level, pos) ? Optional.of(pos) : Optional.empty();
        }

        public static Optional<BlockPos> getConnectedReversedPump(IWorldReader level, BlockPos pos) {
            if (SmokeContainers.isHopper(level, pos = SmokeContainers.getConnectedHopper(level, pos).orElse(pos))) {
                pos = pos.func_177977_b();
            }
            if (SmokeContainers.isPipe(level, pos)) {
                pos = SmokeContainers.getBottommostPipe(level, pos).func_177977_b();
            }
            return SmokeContainers.isReversedPump(level, pos) ? Optional.of(pos) : Optional.empty();
        }

        public static Optional<BlockPos> getConnectedActiveReversedPump(IWorldReader level, BlockPos pos) {
            return SmokeContainers.getConnectedReversedPump(level, pos).filter(p -> SmokeContainers.isActive(level, p));
        }

        public static boolean isCoveredByChimney(IWorldReader world, BlockPos pos) {
            return SmokeContainers.isChimney(world, pos.func_177984_a());
        }

        public static boolean canPassThrough(IBlockReader level, BlockPos pos, Direction from, Direction to) {
            return SmokeContainers.canPassThrough(level, pos, from) && SmokeContainers.canPassThrough(level, pos, to);
        }

        public static boolean canPassThrough(IBlockReader level, BlockPos pos, Direction face) {
            return !level.func_180495_p(pos).func_224755_d(level, pos, face);
        }

        public static boolean hasWayOut(IWorldReader level, BlockPos startPos) {
            BlockPos pos = startPos;
            if (SmokeContainers.isChimney(level, pos)) {
                if (SmokeContainers.getTopmostVent(level, pos).isPresent()) {
                    return false;
                }
                pos = SmokeContainers.getTopmostChimney(level, pos);
            } else if (SmokeContainers.isPump(level, pos)) {
                return false;
            }
            if (!SmokeContainers.canPassThrough((IBlockReader)level, pos, Direction.UP)) {
                return false;
            }
            if (!SmokeContainers.canPassThrough((IBlockReader)level, pos = pos.func_177984_a(), Direction.DOWN)) {
                return false;
            }
            if (SmokeContainers.canPassThrough((IBlockReader)level, pos, Direction.UP)) {
                return true;
            }
            for (Direction dir : Directions.of().up().horizontals().toList()) {
                if (!SmokeContainers.canPassThrough((IBlockReader)level, pos, dir) || !SmokeContainers.canPassThrough((IBlockReader)level, pos.func_177972_a(dir), dir.func_176734_d(), Direction.UP)) continue;
                return true;
            }
            return false;
        }

        static List<BlockPos> getClosestActiveExhaustPumps(final IWorld level, List<BlockPos> startPositions) {
            ArrayList<BlockPos> pumps = new ArrayList<BlockPos>();
            if (startPositions.isEmpty()) {
                return pumps;
            }
            ArrayList<BlockPos> vents = new ArrayList<BlockPos>();
            for (BlockPos pos : startPositions) {
                if (SmokeContainers.isActiveExhaustPump((IWorldReader)level, pos)) {
                    pumps.add(pos);
                    continue;
                }
                if (SmokeContainers.isChimney((IWorldReader)level, pos)) {
                    SmokeContainers.getTopmostVent((IWorldReader)level, pos).ifPresent(vents::add);
                }
                if (!SmokeContainers.isVent((IWorldReader)level, pos)) continue;
                vents.add(pos);
            }
            final HashMap found = new HashMap();
            ArrayList<1> ventPipes = new ArrayList<1>();
            block1: for (BlockPos pos : vents) {
                for (WorldSearch.VentPipe ventPipe : ventPipes) {
                    if (!ventPipe.getChain().contains(pos)) continue;
                    continue block1;
                }
                WorldSearch.VentPipe pipe = new WorldSearch.VentPipe(level, pos){

                    @Override
                    protected boolean isValidBlock(BlockPos pos) {
                        return SmokeContainers.isActiveExhaustPump((IWorldReader)level, pos) || SmokeContainers.isVent((IWorldReader)level, pos) && SmokeContainers.getConnectedActiveReversedPump((IWorldReader)level, pos).isPresent();
                    }

                    @Override
                    protected boolean onValidFound(BlockPos pos) {
                        if (SmokeContainers.isVent((IWorldReader)level, pos)) {
                            pos = SmokeContainers.getConnectedActiveReversedPump((IWorldReader)level, pos).orElse(pos);
                        }
                        found.put(pos, this.getStartPos().func_218139_n((Vector3i)pos));
                        return true;
                    }
                };
                pipe.build();
                ventPipes.add(pipe);
            }
            ArrayList entries = new ArrayList(found.entrySet());
            Collections.shuffle(entries);
            entries.stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).filter(p -> !pumps.contains(p)).forEach(pumps::add);
            return pumps;
        }

        public static List<BlockPos> getClosestActiveExhaustPumps(IWorld level, BlockPos pos) {
            List<Object> startPositions = Collections.singletonList(pos);
            if (SmokeContainers.isPump((IWorldReader)level, pos)) {
                if (SmokeContainers.isExhaustPump((IWorldReader)level, pos)) {
                    startPositions = SmokeContainers.getVentOrChimneyAbove((IWorldReader)level, pos).map(Collections::singletonList).orElse(Collections.emptyList());
                } else if (SmokeContainers.isReversedPump((IWorldReader)level, pos)) {
                    startPositions = SmokeContainers.getVentsAndPumpsAround((IWorldReader)level, pos);
                    Collections.shuffle(startPositions);
                }
            }
            return SmokeContainers.getClosestActiveExhaustPumps(level, startPositions);
        }

        public static int pumpPollutionThrough(List<BlockPos> startingPumps, IWorld level, IPollutant pollutant, int maxAmount) {
            return SmokeContainers.pumpThrough(startingPumps, level, maxAmount, (lev, pos) -> SmokeContainers.isVent((IWorldReader)level, pos.func_177984_a()) || SmokeContainers.isReversedPump((IWorldReader)level, pos), (lev, pos, max) -> SmokeContainers.pumpPollutionThroughActivePump(lev, pos, pollutant, max));
        }

        public static int pumpSmokeThrough(List<BlockPos> startingPumps, IWorld level, int maxAmount, WorldSearch.VentPipe.PumpFunc onPump) {
            return SmokeContainers.pumpThrough(startingPumps, level, maxAmount, (lev, pos) -> true, (lev, pos, max) -> SmokeContainers.pumpSmokeThroughActivePump(lev, pos, max, SmokeContainers::hasWayOut, onPump));
        }

        static int pumpThrough(List<BlockPos> startingPumps, IWorld level, int maxAmount, WorldSearch.BlockChain.BlockFunc shouldSearchForClosestPumps, WorldSearch.VentPipe.PumpFunc pumpFunc) {
            BlockPos pos2;
            if (maxAmount <= 0) {
                return 0;
            }
            int count = 0;
            HashSet<BlockPos> used = new HashSet<BlockPos>();
            ArrayDeque<BlockPos> transit = new ArrayDeque<BlockPos>();
            ArrayDeque pumps = new ArrayDeque();
            Lists.reverse(startingPumps).stream().filter(pos -> SmokeContainers.isActivePump((IWorldReader)level, pos)).forEach(pumps::push);
            while (!pumps.isEmpty()) {
                List closest;
                Block block;
                pos2 = (BlockPos)pumps.pop();
                if (used.contains(pos2) || !((block = level.func_180495_p(pos2).func_177230_c()) instanceof ISmokeContainer)) continue;
                List list = closest = shouldSearchForClosestPumps.apply(level, pos2) ? ((ISmokeContainer)block).getClosestActiveExhaustPumps(level, pos2).stream().filter(pump -> !transit.contains(pump)).collect(Collectors.toList()) : Collections.emptyList();
                if (closest.isEmpty()) {
                    used.add(pos2);
                    if ((count += pumpFunc.apply(level, pos2, maxAmount)) < maxAmount) continue;
                    return count;
                }
                transit.push(pos2);
                Lists.reverse(closest).forEach(pumps::push);
            }
            while (!transit.isEmpty()) {
                pos2 = (BlockPos)transit.pop();
                if ((count += pumpFunc.apply(level, pos2, maxAmount)) < maxAmount) continue;
                return count;
            }
            return count;
        }

        static int pumpSmokeThroughActivePump(IWorld level, BlockPos pump, int maxAmount, WorldSearch.BlockChain.BlockFunc validOutlet, WorldSearch.VentPipe.PumpFunc onPump) {
            if (maxAmount <= 0) {
                return 0;
            }
            int count = 0;
            if (SmokeContainers.isActiveExhaustPump((IWorldReader)level, pump)) {
                BlockPos pos = pump.func_177984_a();
                if (SmokeContainers.isChimney((IWorldReader)level, pos)) {
                    pos = SmokeContainers.getTopmostOpaqueChimney((IWorldReader)level, pos);
                    pos = SmokeContainers.getTopmostVent((IWorldReader)level, pos).orElse(pos);
                }
                if (SmokeContainers.isVent((IWorldReader)level, pos)) {
                    return WorldSearch.VentPipe.pump(level, Collections.singletonList(pos), maxAmount, validOutlet, onPump);
                }
                if (validOutlet.apply(level, pos)) {
                    return onPump.apply(level, pos, maxAmount);
                }
            } else {
                count += SmokeContainers.pumpThroughReversedPump(level, pump, maxAmount - count, validOutlet, onPump);
            }
            return count;
        }

        static int pumpPollutionThroughActivePump(IWorld level, BlockPos pump, IPollutant pollutant, int maxAmount) {
            if (maxAmount <= 0) {
                return 0;
            }
            if (SmokeContainers.isActiveExhaustPump((IWorldReader)level, pump)) {
                BlockPos pos = pump.func_177984_a();
                if (SmokeContainers.isVent((IWorldReader)level, pos)) {
                    return WorldSearch.VentPipe.pump(level, Collections.singletonList(pos), maxAmount, (l, p) -> true, pollutant::pump);
                }
                if (pollutant.canPassThrough((IWorldReader)level, pos, Direction.DOWN, Direction.UP)) {
                    return pollutant.pumpEntitiesAt(level, pos, maxAmount);
                }
                return 0;
            }
            return SmokeContainers.pumpThroughReversedPump(level, pump, maxAmount, (l, p) -> true, pollutant::pump);
        }

        static int pumpThroughReversedPump(IWorld level, BlockPos pump, int maxAmount, WorldSearch.BlockChain.BlockFunc validOutlet, WorldSearch.VentPipe.PumpFunc onPump) {
            if (maxAmount <= 0) {
                return 0;
            }
            int count = 0;
            if (SmokeContainers.isActiveReversedPump((IWorldReader)level, pump)) {
                for (Direction dir : Directions.of().horizontals().shuffle().toList()) {
                    BlockPos pos = pump.func_177972_a(dir);
                    if (level.func_180495_p(pos).func_224755_d((IBlockReader)level, pos, dir.func_176734_d()) || !validOutlet.apply(level, pos) || (count += onPump.apply(level, pos, maxAmount - count)) < maxAmount) continue;
                    return count;
                }
                List<BlockPos> vents = SmokeContainers.getVentsAround((IWorldReader)level, pump);
                Collections.shuffle(vents);
                count += WorldSearch.VentPipe.pump(level, vents, maxAmount - count, validOutlet, onPump);
            }
            return count;
        }

        public static Optional<Float> getPumpedChimneyAirflow(IWorldReader level, BlockPos pos) {
            BlockPos above;
            if (SmokeContainers.isChimney(level, pos) && SmokeContainers.canPassThrough((IBlockReader)level, above = SmokeContainers.getTopmostChimney(level, pos).func_177984_a(), Direction.DOWN) && SmokeContainers.isActiveExhaustPump(level, pos = SmokeContainers.getBottommostChimney(level, pos).func_177977_b())) {
                return Optional.ofNullable(pumpedChimneyAirflow).map(value -> Float.valueOf((float)((Integer)value.get()).intValue() * 0.1f));
            }
            return Optional.empty();
        }

        public static Optional<BlockPos> getTopmostVent(IWorldReader level, BlockPos pos) {
            if (SmokeContainers.isChimney(level, pos)) {
                pos = SmokeContainers.getTopmostChimney(level, pos).func_177984_a();
            }
            if (SmokeContainers.isVent(level, pos)) {
                return Optional.of(pos);
            }
            return Optional.empty();
        }

        public static BlockPos getTopmostChimney(IWorldReader world, BlockPos startPos) {
            return Positions.getLastInLine(world, startPos, SmokeContainers::isChimney, Direction.UP);
        }

        public static BlockPos getTopmostOpaqueChimney(IWorldReader level, BlockPos startPos) {
            return Positions.getLastInLine(level, startPos, SmokeContainers::isOpaqueChimney, Direction.UP);
        }

        public static BlockPos getBottommostChimney(IWorldReader world, BlockPos startPos) {
            return Positions.getLastInLine(world, startPos, SmokeContainers::isChimney, Direction.DOWN);
        }

        public static BlockPos getTopmostPipe(IWorldReader level, BlockPos startPos) {
            return Positions.getLastInLine(level, startPos, SmokeContainers::isPipe, Direction.UP);
        }

        public static BlockPos getBottommostPipe(IWorldReader level, BlockPos startPos) {
            return Positions.getLastInLine(level, startPos, SmokeContainers::isPipe, Direction.DOWN);
        }

        public static List<BlockPos> getVentsAround(IWorldReader level, BlockPos centerPos) {
            return SmokeContainers.getAround(level, centerPos, SmokeContainers::isVent);
        }

        public static List<BlockPos> getVentsAndPumpsAround(IWorldReader level, BlockPos centerPos) {
            return SmokeContainers.getAround(level, centerPos, SmokeContainers::isVentOrPump);
        }

        public static Optional<BlockPos> getVentOrChimneyAbove(IWorldReader level, BlockPos startPos) {
            BlockPos pos = startPos.func_177984_a();
            return SmokeContainers.isVent(level, pos) || SmokeContainers.isChimney(level, pos) ? Optional.of(pos) : Optional.empty();
        }

        public static List<BlockPos> getAround(IWorldReader level, BlockPos centerPos, BiPredicate<IWorldReader, BlockPos> filter) {
            return SmokeContainers.getOnly(level, Positions.getAroundHoriz(centerPos, false, new BlockPos[0]), filter);
        }

        public static List<BlockPos> getOnly(IWorldReader level, List<BlockPos> positions, BiPredicate<IWorldReader, BlockPos> filter) {
            ArrayList<BlockPos> accepted = new ArrayList<BlockPos>();
            for (BlockPos pos : positions) {
                if (!filter.test(level, pos)) continue;
                accepted.add(pos);
            }
            return accepted;
        }
    }

    public static class Positions {
        public static List<BlockPos> getAroundHoriz(BlockPos centerPos, boolean includeCorners, BlockPos ... positions) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            blocks.add(centerPos.func_177976_e());
            blocks.add(centerPos.func_177974_f());
            blocks.add(centerPos.func_177978_c());
            blocks.add(centerPos.func_177968_d());
            if (includeCorners) {
                blocks.add(centerPos.func_177976_e().func_177978_c());
                blocks.add(centerPos.func_177976_e().func_177968_d());
                blocks.add(centerPos.func_177974_f().func_177978_c());
                blocks.add(centerPos.func_177974_f().func_177968_d());
            }
            blocks.addAll(Arrays.asList(positions));
            return blocks;
        }

        public static List<ChunkPos> getAroundHoriz(ChunkPos centerPos, boolean includeCorners, ChunkPos ... positions) {
            List<BlockPos> blocks = Positions.getAroundHoriz(new BlockPos(centerPos.field_77276_a, 0, centerPos.field_77275_b), includeCorners, new BlockPos[0]);
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            for (BlockPos pos : blocks) {
                chunks.add(new ChunkPos(pos.func_177958_n(), pos.func_177952_p()));
            }
            chunks.addAll(Arrays.asList(positions));
            return chunks;
        }

        public static List<BlockPos> getAroundHoriz(BlockPos centerPos, int radius, boolean includeCorners) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            if (radius > 0) {
                int diameter = radius * 2 + (!includeCorners ? 1 : 0);
                blocks.addAll(Positions.getLine(centerPos.func_177985_f(radius).func_177964_d(radius), Direction.EAST, diameter, !includeCorners));
                blocks.addAll(Positions.getLine(centerPos.func_177964_d(radius).func_177965_g(radius), Direction.SOUTH, diameter, !includeCorners));
                blocks.addAll(Positions.getLine(centerPos.func_177965_g(radius).func_177970_e(radius), Direction.WEST, diameter, !includeCorners));
                blocks.addAll(Positions.getLine(centerPos.func_177970_e(radius).func_177985_f(radius), Direction.NORTH, diameter, !includeCorners));
            } else {
                blocks.add(centerPos);
            }
            return blocks;
        }

        public static List<ChunkPos> getAroundHoriz(ChunkPos centerPos, int radius, boolean includeCorners) {
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            List<BlockPos> blocks = Positions.getAroundHoriz(new BlockPos(centerPos.field_77276_a, 0, centerPos.field_77275_b), radius, includeCorners);
            for (BlockPos pos : blocks) {
                chunks.add(new ChunkPos(pos.func_177958_n(), pos.func_177952_p()));
            }
            return chunks;
        }

        public static List<BlockPos> getLine(BlockPos startPos, Direction direction, int length, boolean excludeEnds) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int i = 0; i < length; ++i) {
                if (excludeEnds && (i == 0 || i == length - 1)) continue;
                BlockPos pos = startPos.func_177967_a(direction, i);
                blocks.add(pos);
            }
            return blocks;
        }

        public static List<BlockPos> getHorizPlane(BlockPos centerPos, int radius, boolean includeCorners) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int r = radius; r >= 1; --r) {
                blocks.addAll(Positions.getAroundHoriz(centerPos, r, includeCorners));
            }
            blocks.add(centerPos);
            return blocks;
        }

        public static List<BlockPos> getAroundCube(BlockPos startPos) {
            return Positions.getAroundHoriz(startPos, false, startPos.func_177984_a(), startPos.func_177977_b());
        }

        public static List<BlockPos> getAroundCube(World world, BlockPos centerPos, BiPredicate<World, BlockPos> validPos) {
            ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
            for (BlockPos pos : Positions.getAroundCube(centerPos)) {
                if (!validPos.test(world, pos)) continue;
                validPositions.add(pos);
            }
            return validPositions;
        }

        public static List<BlockPos> getAroundCube(BlockPos centerPos, int radius, boolean includeEdges) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int offset = -radius; offset <= radius; ++offset) {
                BlockPos pos = centerPos.func_177967_a(Direction.UP, offset);
                if (Math.abs(offset) == Math.abs(radius)) {
                    blocks.addAll(Positions.getHorizPlane(pos, radius, includeEdges));
                    continue;
                }
                blocks.addAll(Positions.getAroundHoriz(pos, radius, includeEdges));
            }
            return blocks;
        }

        public static double getDistance(BlockPos posA, BlockPos posB) {
            return Vect3d.distance(Vect3d.from(posA), Vect3d.from(posB));
        }

        public static BlockPos getLastInLine(IWorldReader level, BlockPos startPos, BiPredicate<IWorldReader, BlockPos> validation, Direction direction) {
            int offset = 0;
            while (validation.test(level, startPos.func_177967_a(direction, offset))) {
                ++offset;
            }
            return offset > 0 ? startPos.func_177967_a(direction, offset - 1) : startPos;
        }

        public static BlockPos withY(BlockPos pos, int y) {
            return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
        }

        public static BlockPos withY(BlockPos pos, double y) {
            return new BlockPos((double)pos.func_177958_n(), y, (double)pos.func_177952_p());
        }
    }

    public static class Directions {
        public static final Direction[] CLOCKWISE_HORIZONTALS = new Direction[]{Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH};
        protected final List<Direction> directions = new ArrayList<Direction>();

        public static Directions of() {
            return new Directions();
        }

        public Directions add(Direction direction) {
            this.directions.add(direction);
            return this;
        }

        public Directions add(Direction ... directions) {
            this.directions.addAll(Arrays.asList(directions));
            return this;
        }

        public Directions remove(Direction ... directions) {
            for (Direction dir : directions) {
                this.directions.remove(dir);
            }
            return this;
        }

        public Directions all() {
            return this.add(Direction.values());
        }

        public Directions up() {
            return this.add(Direction.UP);
        }

        public Directions down() {
            return this.add(Direction.DOWN);
        }

        public Directions east() {
            return this.add(Direction.EAST);
        }

        public Directions west() {
            return this.add(Direction.WEST);
        }

        public Directions north() {
            return this.add(Direction.NORTH);
        }

        public Directions south() {
            return this.add(Direction.SOUTH);
        }

        public Directions shuffle() {
            Collections.shuffle(this.directions);
            return this;
        }

        public Directions horizontals() {
            return this.add(CLOCKWISE_HORIZONTALS);
        }

        public Directions verticals() {
            return this.add(Direction.UP, Direction.DOWN);
        }

        public List<Direction> toList() {
            return new ArrayList<Direction>(this.directions);
        }

        public Stream<Direction> toStream() {
            return this.directions.stream();
        }

        public Direction[] toArray() {
            return this.directions.toArray(new Direction[0]);
        }
    }
}

