/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.UnitsInit;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryEntriesInit<E extends IForgeRegistryEntry<E>>
extends UnitsInit<E> {
    public RegistryEntriesInit(ForgeMod mod, Class<? super E> entryClass) {
        super(mod);
        mod.getModEventBus().addGenericListener(entryClass, this::registerEntries);
    }

    public <U extends E> Lazy<U> register(String name, Function<String, U> nameToUnit) {
        return this.register(name, () -> (IForgeRegistryEntry)nameToUnit.apply(name));
    }

    public <U extends E> Lazy<U> register(String name, Supplier<U> supplier) {
        IForgeRegistryEntry entry = (IForgeRegistryEntry)supplier.get();
        if (entry.getRegistryName() == null) {
            ResourceLocation registryName = new ResourceLocation(this.getMod().getId(), name);
            entry.setRegistryName(registryName);
        }
        this.addNew(entry);
        return Lazy.of(() -> entry);
    }

    public <U extends E> U addNew(String name, U unit) {
        ResourceLocation registryName = new ResourceLocation(this.getMod().getId(), name);
        unit.setRegistryName(registryName);
        return (U)((IForgeRegistryEntry)this.addNew(unit));
    }

    protected void registerEntries(RegistryEvent.Register<E> event) {
        this.getAll().forEach(entry -> this.registerEntry(event.getRegistry(), entry));
    }

    protected void registerEntry(IForgeRegistry<E> registry, E entry) {
        if (entry.getRegistryName() == null) {
            throw new NullPointerException("No registry name for " + entry.getClass().getSimpleName());
        }
        registry.register(entry);
    }

    public Map<String, E> mapAll() {
        return this.units.stream().collect(Collectors.toMap(block -> block.getRegistryName().func_110623_a(), block -> block));
    }
}

