/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitVariant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeItem
extends Item
implements IForgeUnit<Item> {
    private final UnitEnabled unitEnabled;
    private final UnitConfig config;
    private Map<Object, UnitVariant> variants = new HashMap<Object, UnitVariant>();
    private final UnitVariant defaultVariant;

    public ForgeItem(ForgeMod mod, UnitConfig config, Item.Properties properties) {
        this(mod, config, "", properties);
    }

    public ForgeItem(ForgeMod mod, UnitConfig config, String name, Item.Properties properties) {
        super(properties);
        this.setRegistryName(new ResourceLocation(mod.getId(), name));
        this.config = config;
        this.unitEnabled = new UnitEnabled(config, this.getUnitCategory(), true);
        this.defaultVariant = UnitVariant.from(this.getRegistryName(), IForgeUnit.Variants.INVENTORY);
    }

    public static ResourceLocation getRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
    }

    public static UUID getAttackDamageModifierUUID() {
        return field_111210_e;
    }

    public static UUID getAttackSpeedModifierUUID() {
        return field_185050_h;
    }

    public static String getStringId(Item item) {
        return item.getRegistryName().toString();
    }

    protected boolean func_194125_a(ItemGroup group) {
        return this.isEnabled() ? super.func_194125_a(group) : false;
    }

    @Override
    public boolean isEnabled() {
        return this.unitEnabled.isEnabled();
    }

    @Override
    public UnitConfig getConfig() {
        return this.config;
    }

    public static <T extends LivingEntity> void damageItem(int damage, ItemStack stack, boolean destroyBroken, @Nullable T damager, @Nullable Consumer<T> onBroken) {
        ServerPlayerEntity player;
        ServerPlayerEntity serverPlayerEntity = player = damager instanceof ServerPlayerEntity ? (ServerPlayerEntity)damager : null;
        if (player == null || player.func_184812_l_()) {
            return;
        }
        Item item = stack.func_77973_b();
        if (item instanceof DamageableItem) {
            ((DamageableItem)item).updateDurability(stack, player);
        }
        if (stack != null && stack.func_77984_f()) {
            if (stack.func_96631_a(damage, (Random)CommonMath.RANDOM, player)) {
                stack.func_196085_b(stack.func_77958_k());
            }
            if (ForgeItem.isBroken(stack)) {
                if (damager != null && onBroken != null) {
                    onBroken.accept(damager);
                }
                if (destroyBroken) {
                    stack.func_190918_g(1);
                    stack.func_196085_b(0);
                }
                if (player != null) {
                    player.func_71029_a(Stats.field_199088_e.func_199076_b((Object)item));
                }
            }
        }
    }

    public static Optional<Integer> indexIn(PlayerInventory inventory, Predicate<ItemStack> predicate) {
        int size = inventory.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(inventory.func_70301_a(i))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.func_77984_f() && stack.func_77952_i() >= stack.func_77958_k();
    }

    public static boolean notBroken(ItemStack stack) {
        return !ForgeItem.isBroken(stack);
    }

    public static boolean isRegistered(Item item) {
        return ForgeRegistries.ITEMS.containsValue((IForgeRegistryEntry)item);
    }

    @Override
    public Map<Object, UnitVariant> getUnitVariants() {
        return this.variants;
    }

    @Override
    public UnitVariant getDefaultVariant() {
        return this.defaultVariant;
    }

    @Override
    public <E extends Enum<E>> void setUnitVariants(Class<E> clazz) {
        this.variants = this.createUnitVariants(clazz);
    }
}

