/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.math.AABB;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ForgeEntity
extends Entity {
    public ForgeEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public ForgeEntity(FMLPlayMessages.SpawnEntity entity, World world) {
        super(entity.getEntity().func_200600_R(), world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Vect3d getBBCenter() {
        return GameMath.getBBCenter(this.getBB());
    }

    public static boolean isHostileMob(Entity entity) {
        return entity instanceof IMob;
    }

    public static Vect3d getCenteredPosTo(BlockPos pos) {
        return GameWorld.getBlockCenter(pos).withY(pos.func_177956_o());
    }

    public static Vect3d getCenterPosition(Entity entity) {
        return GameMath.getBBCenter(ForgeEntity.getBB(entity));
    }

    public static Vect3d getCenterPosition(Entity entity, float tickProgress) {
        return GameMath.getBBCenter(ForgeEntity.getBB(entity, ForgeEntity.getCurPosition(entity, tickProgress)));
    }

    @Nullable
    public static Entity findEntity(World world, int id) {
        return world.func_73045_a(id);
    }

    public static Hand otherHand(Hand hand) {
        return hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
    }

    public static ResourceLocation getRegistryName(Entity entity) {
        return ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entity.func_200600_R());
    }

    public static Vect3d getMotion(Entity entity) {
        return Vect3d.from(entity.func_213322_ci());
    }

    public static void setMotion(Entity entity, Vect3d vec) {
        entity.func_213293_j(vec.x, vec.y, vec.z);
    }

    public void setMotion(Vect3d vec) {
        ForgeEntity.setMotion(this, vec);
    }

    public void move() {
        this.setPrevPosition(this.getCurPosition());
        this.setCurPosition(this.getCurPosition().add(this.getCurMotion()));
    }

    public Vect3d getCurMotion() {
        return Vect3d.from(this.func_213322_ci());
    }

    public static void addMotion(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            ForgeEntity.setMotion(entity, ForgeEntity.getMotion(entity).add(vec));
        }
    }

    public void addMotion(Vect3d vec) {
        ForgeEntity.addMotion(this, vec);
    }

    public void addMotion(double dx, double dy, double dz) {
        this.addMotion(Vect3d.from(dx, dy, dz));
    }

    public static void copyAllPositionsWithOffset(Entity source, Entity target, Vect3d offset) {
        if (source != null && target != null) {
            ForgeEntity.setPrevPosition(target, ForgeEntity.getPrevPosition(source).add(offset));
            ForgeEntity.setLastTickPosition(target, ForgeEntity.getLastTickPosition(source).add(offset));
            ForgeEntity.setCurPosition(target, ForgeEntity.getCurPosition(source).add(offset));
        }
    }

    public static BlockPos getPosition(Entity entity) {
        return new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    public static Vect3d getCurPosition(Entity entity) {
        return entity != null ? Vect3d.from(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()) : Vect3d.ZERO;
    }

    public static Vect3d getCurPosition(Entity entity, float tickProgress) {
        return Vect3d.approx(tickProgress, ForgeEntity.getLastTickPosition(entity), ForgeEntity.getCurPosition(entity));
    }

    public Vect3d getCurPosition() {
        return ForgeEntity.getCurPosition(this);
    }

    public Vect3d getCurPosition(float tickProgress) {
        return ForgeEntity.getCurPosition(this, tickProgress);
    }

    public static BlockPos getPositionEyes(Entity entity) {
        double y = entity.func_226278_cu_() + (double)entity.func_70047_e();
        BlockPos pos = new BlockPos(entity.func_226277_ct_(), y, entity.func_226281_cx_());
        return pos;
    }

    public static BlockPos getPositionTop(Entity entity) {
        double y = entity.func_226278_cu_() + (double)entity.func_213302_cg();
        BlockPos pos = new BlockPos(entity.func_226277_ct_(), y, entity.func_226281_cx_());
        return pos;
    }

    public static Rotation getPrevRotation(Entity entity) {
        return entity != null ? new Rotation(entity.field_70127_C, entity.field_70126_B) : Rotation.ZERO;
    }

    public static Rotation getRotation(Entity entity) {
        return entity != null ? new Rotation(entity.field_70125_A, entity.field_70177_z) : Rotation.ZERO;
    }

    public static Rotation getRotation(Entity entity, float tickProgress) {
        return ForgeEntity.getPrevRotation(entity).approx(tickProgress, ForgeEntity.getRotation(entity));
    }

    public Rotation getRotation(float tickProgress) {
        return ForgeEntity.getRotation(this, tickProgress);
    }

    public Rotation getPrevRotation() {
        return ForgeEntity.getPrevRotation(this);
    }

    public Rotation getCurRotation() {
        return ForgeEntity.getRotation(this);
    }

    public static Vect3d getLastTickPosition(Entity entity) {
        return entity != null ? Vect3d.from(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U) : Vect3d.ZERO;
    }

    public Vect3d getLastTickPosition() {
        return ForgeEntity.getLastTickPosition(this);
    }

    public static Vect3d getPrevPosition(Entity entity) {
        return entity != null ? Vect3d.from(entity.field_70169_q, entity.field_70167_r, entity.field_70166_s) : Vect3d.ZERO;
    }

    public Vect3d getPrevPosition() {
        return ForgeEntity.getPrevPosition(this);
    }

    public static Vect3d getNextPosition(Entity entity) {
        return entity != null ? ForgeEntity.getCurPosition(entity).add(ForgeEntity.getMotion(entity)) : Vect3d.ZERO;
    }

    @Deprecated
    public static void swapPositionsOf(Entity entA, Entity entB) {
        if (entA != null && entB != null) {
            Vect3d prev = ForgeEntity.getPrevPosition(entA);
            Vect3d lastTick = ForgeEntity.getLastTickPosition(entA);
            Vect3d cur = ForgeEntity.getCurPosition(entA);
            ForgeEntity.setPrevPosition(entA, ForgeEntity.getPrevPosition(entB));
            ForgeEntity.setLastTickPosition(entA, ForgeEntity.getLastTickPosition(entB));
            ForgeEntity.setCurPosition(entA, ForgeEntity.getCurPosition(entB));
            ForgeEntity.setPrevPosition(entB, prev);
            ForgeEntity.setLastTickPosition(entB, lastTick);
            ForgeEntity.setCurPosition(entB, cur);
        }
    }

    @Deprecated
    public void swapPositionWith(Entity entity) {
        ForgeEntity.swapPositionsOf(this, entity);
    }

    public Vect3d getNextPosition() {
        return ForgeEntity.getNextPosition(this);
    }

    public static void setCurPosition(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.func_70107_b(vec.x, vec.y, vec.z);
        }
    }

    public static void setPosition_NoBB(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.func_226288_n_(vec.x, vec.y, vec.z);
        }
    }

    public static void setLastTickPosition(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.field_70142_S = vec.x;
            entity.field_70137_T = vec.y;
            entity.field_70136_U = vec.z;
        }
    }

    public void setLastTickPosition(Vect3d vec) {
        ForgeEntity.setLastTickPosition(this, vec);
    }

    public static void setPrevPosition(Entity entity, Vect3d vec) {
        ForgeEntity.setLastTickPosition(entity, vec);
        if (entity != null && vec != null) {
            entity.field_70169_q = vec.x;
            entity.field_70167_r = vec.y;
            entity.field_70166_s = vec.z;
        }
    }

    public void setPrevPosition(Vect3d vec) {
        ForgeEntity.setPrevPosition(this, vec);
    }

    public void setCurPosition(Vect3d vec) {
        ForgeEntity.setCurPosition(this, vec);
    }

    public static void setPrevRotation(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.field_70127_C = rotation.pitch;
            entity.field_70126_B = rotation.yaw;
        }
    }

    public void setPrevRotation(Rotation rotation) {
        ForgeEntity.setPrevRotation(this, rotation);
    }

    public static void setRotation(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.field_70125_A = rotation.pitch;
            entity.field_70177_z = rotation.yaw;
        }
    }

    public void setCurRotation(Rotation rotation) {
        ForgeEntity.setRotation(this, rotation);
    }

    public static void setAllPositions(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.field_70142_S = entity.field_70169_q = vec.x;
            entity.field_70137_T = entity.field_70167_r = vec.y;
            entity.field_70136_U = entity.field_70166_s = vec.z;
            ForgeEntity.setCurPosition(entity, vec);
        }
    }

    public void setAllPositions(Vect3d vec) {
        ForgeEntity.setAllPositions(this, vec);
    }

    public static void setAllRotations(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.field_70127_C = entity.field_70125_A = rotation.pitch;
            entity.field_70126_B = entity.field_70177_z = rotation.yaw;
        }
    }

    public void setAllRotations(Rotation rotation) {
        ForgeEntity.setAllRotations(this, rotation);
    }

    public static float getSize(Entity entity) {
        if (entity != null) {
            return entity.func_213311_cf() * entity.func_213302_cg();
        }
        return 0.0f;
    }

    public static Collection<Entity> getLowestRidingWithAllPassengers(Entity entity) {
        Collection<Object> collection = Collections.emptySet();
        if (entity != null) {
            Entity lowestRiding = entity.func_184208_bv();
            collection = lowestRiding.func_184182_bu();
            collection.add(lowestRiding);
        }
        return collection;
    }

    public static float getWeight(Entity entity, boolean includeAllConnected) {
        float weight = 0.0f;
        if (entity != null) {
            if (includeAllConnected) {
                for (Entity connected : ForgeEntity.getLowestRidingWithAllPassengers(entity)) {
                    weight += ForgeEntity.getWeight(connected, false);
                }
            } else {
                weight += ForgeEntity.getSize(entity);
            }
        }
        return weight;
    }

    public static Direction getFacingTo(BlockPos targetPos, LivingEntity entity) {
        double dist = 2.0;
        if (Math.abs(entity.func_226277_ct_() - (double)targetPos.func_177958_n()) < 2.0 && Math.abs(entity.func_226281_cx_() - (double)targetPos.func_177952_p()) < 2.0) {
            double eyeY = entity.func_226278_cu_() + (double)entity.func_70047_e();
            if (eyeY - (double)targetPos.func_177956_o() > 2.0) {
                return Direction.DOWN;
            }
            if ((double)targetPos.func_177956_o() - eyeY > 0.0) {
                return Direction.UP;
            }
        }
        return entity.func_174811_aO();
    }

    public static void setFallDistance(Entity entity, float distance, boolean includeAllConnected) {
        if (entity != null) {
            if (includeAllConnected) {
                for (Entity connected : ForgeEntity.getLowestRidingWithAllPassengers(entity)) {
                    ForgeEntity.setFallDistance(connected, distance, false);
                }
            } else {
                entity.field_70143_R = distance;
            }
        }
    }

    public static void updateBB(Entity entity) {
        if (entity != null) {
            entity.func_174826_a(ForgeEntity.getBB(entity, ForgeEntity.getCurPosition(entity)));
        }
    }

    public static AxisAlignedBB getBB(Entity entity, Vect3d position) {
        if (entity != null && position != null) {
            double widthHalf = (double)entity.func_213311_cf() / 2.0;
            return new AxisAlignedBB(position.x - widthHalf, position.y, position.z - widthHalf, position.x + widthHalf, position.y + (double)entity.func_213302_cg(), position.z + widthHalf);
        }
        return AABB.ZERO;
    }

    public static AxisAlignedBB getBB(Entity entity) {
        return ForgeEntity.getBB(entity, ForgeEntity.getCurPosition(entity));
    }

    public AxisAlignedBB getBB(Vect3d position) {
        return ForgeEntity.getBB(this, position);
    }

    public AxisAlignedBB getBB() {
        return ForgeEntity.getBB(this, this.getCurPosition());
    }

    public void updateBB() {
        ForgeEntity.updateBB(this);
    }

    public static void stopMoving(Entity entity) {
        if (entity != null) {
            ForgeEntity.setMotion(entity, Vect3d.ZERO);
        }
    }

    public void stopMoving() {
        ForgeEntity.stopMoving(this);
    }

    public static boolean isUnderRain(Entity entity) {
        BlockPos pos = ForgeEntity.getPositionTop(entity);
        return ForgeBlock.isUnderRain(entity.field_70170_p, pos);
    }

    public static boolean isUnderOpenSky(Entity entity) {
        BlockPos pos = ForgeEntity.getPositionTop(entity);
        return ForgeBlock.isUnderOpenSky(entity.field_70170_p, pos);
    }

    public static boolean isServerSide(Entity entity) {
        if (entity != null) {
            return GameWorld.isServerSide((IWorldReader)entity.field_70170_p);
        }
        return false;
    }

    public boolean isServerSide() {
        return ForgeEntity.isServerSide(this);
    }

    public static boolean isClientSide(Entity entity) {
        if (entity != null) {
            return GameWorld.isClientSide((IWorldReader)entity.field_70170_p);
        }
        return false;
    }

    public boolean isClientSide() {
        return ForgeEntity.isClientSide(this);
    }

    public List<Entity> getEntitiesWithinAABB(AxisAlignedBB aaBB) {
        if (this.field_70170_p != null) {
            return new ArrayList<Entity>(this.field_70170_p.func_225317_b(Entity.class, aaBB));
        }
        return Collections.emptyList();
    }

    @Deprecated
    public List<Entity> getCollidedEntitiesIfMove(Vect3d motion) {
        List<Entity> collidedEntities = this.getEntitiesWithinAABB(this.getBB(this.getNextPosition()));
        collidedEntities.remove((Object)this);
        return collidedEntities;
    }

    public <E extends Entity> List<E> getCollidedWithIfMove(Class<E> clazz, Vect3d motion, Predicate<? super E> filter) {
        return this.field_70170_p.func_175647_a(clazz, this.getBB(this.getNextPosition()), filter.and(e -> !e.equals((Object)this)));
    }

    public static void setBB(Entity entity, Vect3d minPoint, Vect3d maxPoint) {
        if (entity != null && minPoint != null && maxPoint != null) {
            entity.func_174826_a(new AxisAlignedBB(minPoint.x, minPoint.y, minPoint.z, maxPoint.x, maxPoint.y, maxPoint.z));
        }
    }

    public void setBB(Vect3d minPoint, Vect3d maxPoint) {
        ForgeEntity.setBB(this, minPoint, maxPoint);
    }

    public static boolean hasSwingingPlayerPassenger(Entity entity) {
        if (entity != null) {
            for (Entity passenger : entity.func_184188_bt()) {
                if (!(passenger instanceof PlayerEntity) || !((PlayerEntity)passenger).field_82175_bq) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSwingingPlayerPassenger() {
        return ForgeEntity.hasSwingingPlayerPassenger(this);
    }

    public static boolean hasStack(Entity entity, ItemStack stack) {
        if (entity instanceof ItemEntity) {
            return ((ItemEntity)entity).func_92059_d().equals(stack);
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            return player.field_71071_by.func_70431_c(stack);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (ItemStack equiped : living.func_184209_aF()) {
                if (!equiped.equals(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static Optional<BlockRayTraceResult> rayTraceBlockBeingLookedAt(Entity entity, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode, float partialTicks, float reachDistance) {
        Vector3d lookVec;
        Vector3d endVec;
        World world = entity.field_70170_p;
        Vector3d startVec = entity.func_174824_e(partialTicks);
        RayTraceContext context = new RayTraceContext(startVec, endVec = startVec.func_178787_e(lookVec = entity.func_70676_i(partialTicks).func_186678_a((double)reachDistance)), blockMode, fluidMode, entity);
        BlockRayTraceResult hit = world.func_217299_a(context);
        return hit != null && hit.func_216346_c() != RayTraceResult.Type.MISS ? Optional.of(hit) : Optional.empty();
    }

    public static Optional<EntityRayTraceResult> rayTraceEntityBeingLookedAt(Entity entity, float partialTicks, float reachDistance) {
        Vector3d startVec = entity.func_174824_e(partialTicks);
        Vector3d lookVec = entity.func_70676_i(partialTicks).func_186678_a((double)reachDistance);
        Vector3d endVec = startVec.func_178787_e(lookVec);
        AxisAlignedBB boundingBox = entity.func_174813_aQ().func_216361_a(lookVec).func_72314_b(1.0, 1.0, 1.0);
        double minDistance = Double.MAX_VALUE;
        Entity closestTarget = null;
        Vector3d closestHit = null;
        for (Entity target : entity.field_70170_p.func_225316_b(Entity.class, boundingBox, ent -> ent != entity && !ent.func_175149_v())) {
            double distance;
            AxisAlignedBB aabb = target.func_174813_aQ().func_186662_g(0.3);
            Vector3d hit = aabb.func_216365_b(startVec, endVec).orElse(null);
            if (hit == null || !((distance = startVec.func_72436_e(hit)) < minDistance)) continue;
            closestTarget = target;
            closestHit = hit;
            minDistance = distance;
        }
        return closestTarget != null && closestHit != null ? Optional.of(new EntityRayTraceResult(closestTarget, closestHit)) : Optional.empty();
    }

    public static Iterable<ItemStack> getEquipmentOn(Entity entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : entity.func_184193_aE()) {
            if (stack.func_190926_b()) continue;
            list.add(stack);
        }
        if (!(entity instanceof PlayerEntity) || ModList.get().isLoaded("baubles")) {
            // empty if block
        }
        return list;
    }

    public static Percentage getAirShortage(Entity entity) {
        int supply = entity.func_70086_ai();
        int max = entity.func_205010_bg();
        int shortage = max - supply;
        return Percentage.from(shortage, max);
    }
}

