/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.units.UnitId;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.tuple.Pair;

public class ServerCommand {
    protected final LiteralArgumentBuilder<CommandSource> builder;
    protected final CommandDispatcher<CommandSource> dispatcher;
    protected final List<Task> tasks = new ArrayList<Task>();

    public ServerCommand(String name, CommandDispatcher<CommandSource> dispatcher) {
        this.builder = Commands.func_197057_a((String)name);
        this.dispatcher = dispatcher;
    }

    public static ServerCommand createFor(ForgeMod mod, CommandDispatcher<CommandSource> dispatcher) {
        String commandName = mod.getId().replaceFirst("^ad", "");
        return new ServerCommand(commandName, dispatcher);
    }

    @Deprecated
    public static ServerCommand createFor(ForgeMod mod, MinecraftServer server) {
        return ServerCommand.createFor(mod, (CommandDispatcher<CommandSource>)server.func_195571_aL().func_197054_a());
    }

    public Task task(String name) {
        Task task = new Task(name);
        this.tasks.add(task);
        return task;
    }

    public ServerCommand requires(OpLevel level) {
        this.builder.requires(src -> src.func_197034_c(level.ordinal() + 1));
        return this;
    }

    public void register() {
        for (Task task : this.tasks) {
            this.builder.then(task.builder);
        }
        this.dispatcher.register(this.builder);
    }

    public static class Task {
        protected final LiteralArgumentBuilder<CommandSource> builder;

        public Task(String name) {
            this.builder = Commands.func_197057_a((String)name);
        }

        protected Command<CommandSource> asCommand(Consumer<Context> method) {
            return context -> {
                method.accept(new Context((CommandContext<CommandSource>)context));
                return 1;
            };
        }

        public Task executes(Consumer<Context> method, Arg<?> ... arguments) {
            RequiredArgumentBuilder argumentBuilder = null;
            for (int i = arguments.length - 1; i >= 0; --i) {
                Arg<?> arg = arguments[i];
                RequiredArgumentBuilder builder = Commands.func_197056_a((String)arg.getName(), arg.getType());
                if (arg.getCustomSuggestions().isPresent()) {
                    builder.suggests(arg.getCustomSuggestions().get());
                } else {
                    builder.suggests((arg_0, arg_1) -> arg.getType().listSuggestions(arg_0, arg_1));
                }
                if (argumentBuilder != null) {
                    builder.then(argumentBuilder);
                } else {
                    builder.executes(this.asCommand(method));
                }
                argumentBuilder = builder;
            }
            if (argumentBuilder != null) {
                this.builder.then(argumentBuilder);
            } else {
                this.builder.executes(this.asCommand(method));
            }
            return this;
        }

        public Task executes(Consumer<Context> method, String argName) {
            this.builder.then(Commands.func_197057_a((String)argName).executes(this.asCommand(method)));
            return this;
        }
    }

    public static enum OpLevel {
        NOOB,
        NORMAL,
        KICKASS,
        GOD;

    }

    public static class Arg<T> {
        private final String name;
        private final ArgumentType<T> type;
        private final SuggestionProvider<CommandSource> customSuggestions;

        protected Arg(String name, ArgumentType<T> type) {
            this(name, type, null);
        }

        protected Arg(String name, ArgumentType<T> type, SuggestionProvider<CommandSource> customSuggestions) {
            this.name = name;
            this.type = type;
            this.customSuggestions = customSuggestions;
        }

        public static <T> Arg<T> of(String name, ArgumentType<T> type) {
            return new Arg<T>(name, type);
        }

        public static <T> Arg<T> of(String name, ArgumentType<T> type, SuggestionProvider<CommandSource> customSuggestions) {
            return new Arg<T>(name, type, customSuggestions);
        }

        public static Arg<Integer> integer(String name, IntBounds bounds) {
            return Arg.of(name, IntegerArgumentType.integer((int)bounds.min, (int)bounds.max));
        }

        public static Arg<Float> floatt(String name, FloatBounds bounds) {
            return Arg.of(name, FloatArgumentType.floatArg((float)bounds.min.floatValue(), (float)bounds.max.floatValue()));
        }

        public static Arg<String> string(String name) {
            return Arg.of(name, StringArgumentType.string());
        }

        public static Arg<String> string(String name, SuggestionProvider<CommandSource> customSuggestions) {
            return Arg.of(name, StringArgumentType.string(), customSuggestions);
        }

        public static Arg<String> word(String name) {
            return Arg.of(name, StringArgumentType.word());
        }

        public static Arg<String> word(String name, SuggestionProvider<CommandSource> customSuggestions) {
            return Arg.of(name, StringArgumentType.word(), customSuggestions);
        }

        public static Arg<IntBounds> bounds(String name, IntBounds bounds) {
            return Arg.of(name, IntBoundsArgument.bounded(bounds));
        }

        public static Arg<FloatBounds> bounds(String name, FloatBounds bounds) {
            return Arg.of(name, FloatBoundsArgument.bounded(bounds));
        }

        public static Arg<ColorARGB> color(String name) {
            return Arg.of(name, new ColorARGBArgument());
        }

        public String getName() {
            return this.name;
        }

        public ArgumentType<T> getType() {
            return this.type;
        }

        public Optional<SuggestionProvider<CommandSource>> getCustomSuggestions() {
            return Optional.ofNullable(this.customSuggestions);
        }
    }

    public static class ColorARGBArgument
    implements ArgumentType<ColorARGB> {
        static final Collection<String> EXAMPLES = Arrays.asList("0xaarrggbb", "0x11223344");

        public static ColorARGB getValue(CommandContext<CommandSource> context, String name) {
            return (ColorARGB)context.getArgument(name, ColorARGB.class);
        }

        public ColorARGB parse(StringReader reader) throws CommandSyntaxException {
            int start = reader.getCursor();
            String argument = reader.readString();
            try {
                return ColorARGB.parse(argument);
            }
            catch (NumberFormatException ex) {
                reader.setCursor(start);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)reader, (Object)argument);
            }
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }

    public static class FloatBoundsArgument
    implements ArgumentType<FloatBounds> {
        static final Collection<String> EXAMPLES = Arrays.asList("min_max", "number1_number2", "0.5_100.5");
        protected final FloatArgumentType min;
        protected final FloatArgumentType max;

        protected FloatBoundsArgument(FloatBounds bounds) {
            this.min = FloatArgumentType.floatArg((float)bounds.min.floatValue(), (float)bounds.max.floatValue());
            this.max = FloatArgumentType.floatArg((float)bounds.min.floatValue(), (float)bounds.max.floatValue());
        }

        public static FloatBoundsArgument unbounded() {
            return new FloatBoundsArgument(FloatBounds.FLOAT);
        }

        public static FloatBoundsArgument positive() {
            return new FloatBoundsArgument(FloatBounds.FLOAT_POSITIVE);
        }

        public static FloatBoundsArgument bounded(FloatBounds bounds) {
            return new FloatBoundsArgument(bounds);
        }

        public FloatBounds parse(StringReader reader) throws CommandSyntaxException {
            float min = this.min.parse(reader).floatValue();
            reader.expect('_');
            float max = this.max.parse(reader).floatValue();
            return FloatBounds.from(Float.valueOf(min), Float.valueOf(max));
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }

    public static class IntBoundsArgument
    implements ArgumentType<IntBounds> {
        protected static final Collection<String> EXAMPLES = Arrays.asList("min_max", "number1_number2", "0_100");
        protected final IntegerArgumentType min;
        protected final IntegerArgumentType max;

        protected IntBoundsArgument(IntBounds bounds) {
            this.min = IntegerArgumentType.integer((int)bounds.min, (int)bounds.max);
            this.max = IntegerArgumentType.integer((int)bounds.min, (int)bounds.max);
        }

        public static IntBoundsArgument integer() {
            return new IntBoundsArgument(IntBounds.INTEGER);
        }

        public static IntBoundsArgument positive() {
            return new IntBoundsArgument(IntBounds.INTEGER_POSITIVE);
        }

        public static IntBoundsArgument bounded(IntBounds bounds) {
            return new IntBoundsArgument(bounds);
        }

        public IntBounds parse(StringReader reader) throws CommandSyntaxException {
            int min = this.min.parse(reader);
            reader.expect('_');
            int max = this.max.parse(reader);
            return IntBounds.from(min, max);
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }

    public static class Msg {
        protected final String text;

        public Msg(String text) {
            this.text = text;
        }

        public static Msg of(String text) {
            return new Msg(text);
        }

        public static Msg noUnitInSight(String unit) {
            return Msg.colored("No " + unit + " in sight", TextFormatting.RED);
        }

        public static Msg error(String error) {
            return Msg.colored(error, TextFormatting.RED);
        }

        public static Msg colored(String text, TextFormatting color) {
            return Msg.of(color + text + TextFormatting.RESET);
        }

        public static Msg bool(boolean value) {
            return Msg.colored(String.valueOf(value), value ? TextFormatting.GREEN : TextFormatting.RED);
        }

        public static Msg unit(String title, TextFormatting color, UnitId id) {
            return Msg.of(Msg.colored(title, color) + " -> " + Msg.colored(id.toString(), color));
        }

        public static Msg emitter(String name, IEmitter emitter, boolean active) {
            return Msg.of(name + Msg.colored(" is ", TextFormatting.WHITE) + (active ? Msg.colored("Active", TextFormatting.RED) : Msg.colored("Inactive", TextFormatting.GRAY)) + " " + Msg.colored(emitter.toString(), TextFormatting.DARK_AQUA));
        }

        public static Msg clazz(Class<?> clazz, boolean fullName) {
            return Msg.colored("Class<" + (fullName ? clazz.getTypeName() : clazz.getSimpleName()) + ">", TextFormatting.DARK_PURPLE);
        }

        public static Msg nbt(INBTSerializable<CompoundNBT> nbtSource, Predicate<String> tagNameFilter) {
            CompoundNBT compound = (CompoundNBT)nbtSource.serializeNBT();
            ArrayList<String> tags = new ArrayList<String>();
            for (String key : compound.func_150296_c()) {
                ForgeNBT.Types type = ForgeNBT.getType(compound, key);
                if (!tagNameFilter.test(key) || !type.isOrdinal() && type != ForgeNBT.Types.STRING) continue;
                tags.add(key);
            }
            return Msg.colored("NbtTags: " + tags, TextFormatting.DARK_AQUA);
        }

        public String toString() {
            return this.text;
        }
    }

    public static class Context {
        protected final CommandContext<CommandSource> context;
        public final CommandSource source;
        protected float reachDistance = 5.0f;

        public Context(CommandContext<CommandSource> context) {
            this.context = context;
            this.source = (CommandSource)context.getSource();
        }

        public ServerWorld getWorld() {
            return this.source.func_197023_e();
        }

        public BlockPos getBlockPos() {
            return new BlockPos(this.source.func_197036_d());
        }

        public void sendMessage(String text) {
            this.sendMessage(Msg.of(text));
        }

        public void sendMessage(Msg msg) {
            this.source.func_197030_a((ITextComponent)new StringTextComponent(msg.toString()), false);
        }

        public void setReachDistance(float value) {
            this.reachDistance = value;
        }

        @Nullable
        public Entity getEntity() {
            return this.source.func_197022_f();
        }

        public <V> V getArgument(String name, Class<V> type) {
            return (V)this.context.getArgument(name, type);
        }

        public Optional<Pair<BlockPos, Msg>> getTargetBlockInfo(boolean showErrorMessages) {
            Optional<BlockRayTraceResult> result = this.rayTraceBlockBeingLookedAt(showErrorMessages);
            if (result.isPresent()) {
                BlockPos pos = result.get().func_216350_a();
                BlockState state = this.getWorld().func_180495_p(pos);
                return Optional.of(Pair.of((Object)pos, (Object)Msg.unit("Target block", TextFormatting.GREEN, UnitId.from(state))));
            }
            return Optional.empty();
        }

        public Optional<Pair<BlockPos, Msg>> getTargetTileInfo(Predicate<String> nbtNameFilter, boolean showErrorMessages) {
            ServerWorld world = this.getWorld();
            Optional<Pair<BlockPos, Msg>> info = this.getTargetBlockInfo(true);
            if (info.isPresent()) {
                BlockPos pos = (BlockPos)info.get().getKey();
                TileEntity tile = world.func_175625_s(pos);
                if (tile != null) {
                    UnitId id = UnitId.from(tile.func_200662_C().getRegistryName());
                    Msg msg = Msg.of(Msg.unit("Target tile", TextFormatting.BLUE, id) + " of " + Msg.clazz(tile.getClass(), true) + " with " + Msg.nbt((INBTSerializable<CompoundNBT>)tile, nbtNameFilter));
                    return Optional.of(Pair.of((Object)pos, (Object)msg));
                }
                if (showErrorMessages) {
                    this.sendMessage(info.get().getValue() + " " + Msg.error("has no tile"));
                }
            }
            return Optional.empty();
        }

        public Optional<Pair<Entity, Msg>> getTargetEntityInfo(boolean showErrorMessages, boolean includeClass, Optional<Predicate<String>> nbtNameFilter) {
            EntityRayTraceResult result = ForgeEntity.rayTraceEntityBeingLookedAt(this.getEntity(), 1.0f, this.reachDistance).orElse(null);
            if (result != null) {
                Entity entity = result.func_216348_a();
                UnitId id = UnitId.from(entity.func_200600_R().getRegistryName());
                String text = Msg.unit("Target entity", TextFormatting.YELLOW, id) + (includeClass ? " of " + Msg.clazz(entity.getClass(), true) : "") + (nbtNameFilter.isPresent() ? " with " + Msg.nbt((INBTSerializable<CompoundNBT>)entity, nbtNameFilter.get()) : "");
                return Optional.of(Pair.of((Object)entity, (Object)Msg.of(text)));
            }
            if (showErrorMessages) {
                this.sendMessage(Msg.noUnitInSight("entity"));
            }
            return Optional.empty();
        }

        public Optional<Pair<BlockPos, Msg>> getTargetFluidInfo(boolean showErrorMessages) {
            Optional<BlockRayTraceResult> result = this.rayTraceBlockBeingLookedAt(showErrorMessages);
            if (result.isPresent()) {
                BlockPos pos = result.get().func_216350_a();
                FluidState state = this.getWorld().func_204610_c(pos);
                if (!state.func_206888_e()) {
                    return Optional.of(Pair.of((Object)pos, (Object)Msg.unit("Target fluid", TextFormatting.AQUA, UnitId.from(state))));
                }
            }
            if (showErrorMessages) {
                this.sendMessage(Msg.noUnitInSight("fluid"));
            }
            return Optional.empty();
        }

        public Optional<Pair<Item, Msg>> getHeldItemInfo(Hand hand, boolean showErrorMessages) {
            if (this.getEntity() instanceof LivingEntity) {
                Optional<ItemStack> stack = Optional.of(((LivingEntity)this.getEntity()).func_184586_b(hand));
                if (stack.isPresent()) {
                    Item item = stack.get().func_77973_b();
                    return Optional.of(Pair.of((Object)item, (Object)Msg.unit("Held item", TextFormatting.DARK_PURPLE, UnitId.from(item))));
                }
                if (showErrorMessages) {
                    this.sendMessage(Msg.error("Hand is empty"));
                }
            } else if (showErrorMessages) {
                this.sendMessage(Msg.error("Entity is not living"));
            }
            return Optional.empty();
        }

        public Optional<BlockRayTraceResult> rayTraceBlockBeingLookedAt(boolean showErrorMessages) {
            Entity entity = this.getEntity();
            if (entity == null) {
                if (showErrorMessages) {
                    this.sendMessage(Msg.error("Sender entity is null"));
                }
                return Optional.empty();
            }
            ArrayList<BlockRayTraceResult> results = new ArrayList<BlockRayTraceResult>();
            for (RayTraceContext.BlockMode blockmod : RayTraceContext.BlockMode.values()) {
                ForgeEntity.rayTraceBlockBeingLookedAt(entity, blockmod, RayTraceContext.FluidMode.ANY, 1.0f, this.reachDistance).ifPresent(results::add);
            }
            results.removeIf(result -> result.func_216346_c() != RayTraceResult.Type.BLOCK);
            double minDistance = Double.MAX_VALUE;
            BlockRayTraceResult closestResult = null;
            for (BlockRayTraceResult result2 : results) {
                double distance = entity.func_174824_e(1.0f).func_72436_e(result2.func_216347_e());
                if (!(distance < minDistance)) continue;
                closestResult = result2;
                minDistance = distance;
            }
            if (closestResult != null) {
                return Optional.of(closestResult);
            }
            if (showErrorMessages) {
                this.sendMessage(Msg.noUnitInSight("block"));
            }
            return Optional.empty();
        }
    }
}

