/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.core;

import com.endertech.common.CommonTime;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CacheCleaner {
    protected static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    protected final Runnable task;
    protected final CommonTime.Interval minRunInterval;
    protected Future<?> activeTask;
    protected CommonTime.Stamp lastRun;

    public CacheCleaner(Runnable task, CommonTime.Interval minRunInterval) {
        this.task = task;
        this.minRunInterval = minRunInterval;
        this.lastRun = null;
    }

    protected boolean isTimeToRun() {
        if (this.activeTask == null || this.activeTask.isDone()) {
            return true;
        }
        return this.lastRun == null || CommonTime.Interval.passedFrom(this.lastRun).moreThan(this.minRunInterval);
    }

    public void tryExecute() {
        if (this.isTimeToRun()) {
            this.activeTask = EXECUTOR.submit(this.task);
            this.lastRun = CommonTime.Stamp.now();
        }
    }
}

