/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.math.Vect3d;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.math.BlockPos;

public final class ForgeNBT {
    public static boolean hasCompoundTag(CompoundNBT compound, String tagName) {
        return compound.func_150297_b(tagName, Types.COMPOUND.id);
    }

    @Nullable
    public static CompoundNBT getNestedCompound(CompoundNBT compound, String path) {
        String[] split;
        if (path.isEmpty()) {
            return compound;
        }
        for (String key : split = path.split("/")) {
            INBT tag = compound.func_74781_a(key);
            if (!(tag instanceof CompoundNBT)) {
                return null;
            }
            compound = (CompoundNBT)tag;
        }
        return compound;
    }

    @Nullable
    public static INBT getTag(CompoundNBT compound, KeyPathPair pair) {
        return (compound = ForgeNBT.getNestedCompound(compound, pair.path)) != null ? compound.func_74781_a(pair.key) : null;
    }

    public static Types getType(CompoundNBT compound, String key) {
        byte id = compound.func_150299_b(key);
        for (Types type : Types.values()) {
            if (type.id != id) continue;
            return type;
        }
        return Types.NULL;
    }

    public static void putVect3d(CompoundNBT compound, String key, Vect3d vec) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74780_a(Vec3Keys.x.name(), vec.x);
        tag.func_74780_a(Vec3Keys.y.name(), vec.y);
        tag.func_74780_a(Vec3Keys.z.name(), vec.z);
        compound.func_218657_a(key, (INBT)tag);
    }

    public static Vect3d getVect3d(CompoundNBT compound, String key) {
        CompoundNBT tag = compound.func_74775_l(key);
        return Vect3d.from(tag.func_74769_h(Vec3Keys.x.name()), tag.func_74769_h(Vec3Keys.y.name()), tag.func_74769_h(Vec3Keys.z.name()));
    }

    public static void putBlockPos(CompoundNBT compound, String key, BlockPos pos) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(Vec3Keys.x.name(), pos.func_177958_n());
        tag.func_74768_a(Vec3Keys.y.name(), pos.func_177956_o());
        tag.func_74768_a(Vec3Keys.z.name(), pos.func_177952_p());
        compound.func_218657_a(key, (INBT)tag);
    }

    public static BlockPos getBlockPos(CompoundNBT compound, String key) {
        CompoundNBT tag = compound.func_74775_l(key);
        return new BlockPos(tag.func_74762_e(Vec3Keys.x.name()), tag.func_74762_e(Vec3Keys.y.name()), tag.func_74762_e(Vec3Keys.z.name()));
    }

    @Nullable
    public static <T extends Enum<T>> T getEnumValue(CompoundNBT compound, Class<T> enumClass) {
        String name = compound.func_74779_i(enumClass.getSimpleName());
        return name.isEmpty() ? null : (T)Enum.valueOf(enumClass, name);
    }

    public static <T extends Enum<T>> void putEnumValue(CompoundNBT compound, T enumValue) {
        compound.func_74778_a(enumValue.getClass().getSimpleName(), enumValue.name());
    }

    public static String[] getStringArray(CompoundNBT compound, String key) {
        ListNBT list = compound.func_150295_c(key, Types.STRING.id);
        int count = list.size();
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            strings[i] = list.func_150307_f(i);
        }
        return strings;
    }

    public static void putStringArray(CompoundNBT compound, String key, String ... strings) {
        ListNBT list = new ListNBT();
        for (String str : strings) {
            StringNBT tag = StringNBT.func_229705_a_((String)str);
            list.add((Object)tag);
        }
        compound.func_218657_a(key, (INBT)list);
    }

    public static enum Types {
        NULL(0),
        BYTE(1),
        SHORT(2),
        INT(3),
        LONG(4),
        FLOAT(5),
        DOUBLE(6),
        BYTE$$(7),
        STRING(8),
        LIST(9),
        COMPOUND(10),
        INT$$(11),
        LONG$$(12),
        ORDINAL(99);

        public final int id;

        private Types(int id) {
            this.id = id;
        }

        public boolean isOrdinal() {
            return this.id == 99 || this.id >= 1 && this.id <= 6;
        }

        public String toString() {
            String string = this.name().toLowerCase(Locale.ROOT);
            return this.isOrdinal() ? string : CommonString.capitalizeFirstChar(string).replace("$$", "[]");
        }
    }

    public static class KeyPathPair {
        public final String path;
        public final String key;

        public KeyPathPair(String path, String key) {
            this.path = path;
            this.key = key;
        }

        public static KeyPathPair from(String str) {
            int pos = str.lastIndexOf("/");
            if (pos < 0) {
                return new KeyPathPair("", str);
            }
            return new KeyPathPair(str.substring(0, pos), str.substring(pos + 1));
        }
    }

    static enum Vec3Keys {
        x,
        y,
        z;

    }

    static enum UUIDKeys {
        m,
        l;

    }
}

