/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.Args;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import java.awt.Color;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public class ColorARGB {
    public static final int MAX_BYTE_VALUE = 255;
    public static final ColorARGB DEFAULT = ColorARGB.from(0);
    public static final String HEX_FORMAT = "ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)";
    public static final String DESCRIPTION_COMMON = "Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)";
    public static final String DESCRIPTION_FOR_SMOKE = "Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb) which will be applied to the smoke.\nThe alpha channel of this color (aa) determines probability of applying (ff - always, 7f - 1/2, 00 - never).\n";
    private final Channel alpha;
    private final Channel red;
    private final Channel green;
    private final Channel blue;

    protected ColorARGB(Channel alpha, Channel red, Channel green, Channel blue) {
        this.alpha = alpha;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public static ColorARGB from(int argb) {
        return new ColorARGB(Channel.from(argb >> 24 & 0xFF), Channel.from(argb >> 16 & 0xFF), Channel.from(argb >> 8 & 0xFF), Channel.from(argb >> 0 & 0xFF));
    }

    public static ColorARGB from(String hexARGB) {
        try {
            return ColorARGB.parse(hexARGB);
        }
        catch (NumberFormatException e) {
            ForgeEndertech.getInstance().getLogger().error("'{}' is not a valid hex ARGBcolor definition!", (Object)hexARGB);
            return DEFAULT;
        }
    }

    public static ColorARGB from(Color color) {
        return ColorARGB.from(color.getRGB());
    }

    public static ColorARGB parse(String hexARGB) throws NumberFormatException {
        hexARGB = hexARGB.toLowerCase().trim();
        int offset = 0;
        if (hexARGB.startsWith("#")) {
            offset = 1;
        }
        if (hexARGB.startsWith("0x")) {
            offset = 2;
        }
        int argb = Integer.parseUnsignedInt(hexARGB.substring(offset), 16);
        return ColorARGB.from(argb);
    }

    public static ColorARGB blend(Map<ColorARGB, Integer> weightedColors) {
        long totalWeight = 0L;
        for (int weight : weightedColors.values()) {
            totalWeight += (long)weight;
        }
        if (totalWeight <= 0L) {
            return DEFAULT;
        }
        int alpha = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        for (Map.Entry<ColorARGB, Integer> entry : weightedColors.entrySet()) {
            float ratio = (float)entry.getValue().intValue() / (float)totalWeight;
            ColorARGB color = entry.getKey();
            alpha = (int)((float)alpha + (float)color.getAlpha().value * ratio);
            red = (int)((float)red + (float)color.getRed().value * ratio);
            green = (int)((float)green + (float)color.getGreen().value * ratio);
            blue = (int)((float)blue + (float)color.getBlue().value * ratio);
        }
        return new ColorARGB(Channel.from(alpha), Channel.from(red), Channel.from(green), Channel.from(blue));
    }

    protected static String getHexARGB(int intARGB) {
        return String.format("%#010x", intARGB);
    }

    public Channel getAlpha() {
        return this.alpha;
    }

    public Channel getRed() {
        return this.red;
    }

    public Channel getGreen() {
        return this.green;
    }

    public Channel getBlue() {
        return this.blue;
    }

    public int getARGB() {
        return this.alpha.value << 24 | this.red.value << 16 | this.green.value << 8 | this.blue.value << 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Args.group(Args.get("a", this.getAlpha().value), Args.get("r", this.getRed().value), Args.get("g", this.getGreen().value), Args.get("b", this.getBlue().value));
    }

    public String getHexARGB() {
        return ColorARGB.getHexARGB(this.getARGB());
    }

    public boolean isOpaque() {
        return this.getAlpha().value == 255;
    }

    public boolean isCompletelyTransparent() {
        return this.getAlpha().value == 0;
    }

    public ColorARGB maxOpaque() {
        return new ColorARGB(Channel.from(255), this.getRed(), this.getGreen(), this.getBlue());
    }

    public ColorARGB approxTo(ColorARGB color, float factor) {
        BiFunction<Channel, Channel, Channel> approx = (from, to) -> from.value <= to.value ? Channel.from(IntBounds.from(from.value, to.value).approxUp(factor)) : Channel.from(IntBounds.from(from.value, to.value).approxDown(factor));
        return new ColorARGB(approx.apply(this.getAlpha(), color.getAlpha()), approx.apply(this.getRed(), color.getRed()), approx.apply(this.getGreen(), color.getGreen()), approx.apply(this.getBlue(), color.getBlue()));
    }

    public ColorARGB withAlpha(Channel alpha) {
        return new ColorARGB(alpha, this.getRed(), this.getGreen(), this.getBlue());
    }

    public ColorARGB withRed(Channel red) {
        return new ColorARGB(this.getAlpha(), red, this.getGreen(), this.getBlue());
    }

    public ColorARGB withGreen(Channel green) {
        return new ColorARGB(this.getAlpha(), this.getRed(), green, this.getBlue());
    }

    public ColorARGB withBlue(Channel blue) {
        return new ColorARGB(this.getAlpha(), this.getRed(), this.getGreen(), blue);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColorARGB) {
            ColorARGB argb = (ColorARGB)obj;
            return argb.getARGB() == this.getARGB();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getARGB());
    }

    public static class Channel {
        public final int value;

        protected Channel(int value) {
            this.value = value;
        }

        public static Channel from(int value) {
            return new Channel(value);
        }

        public static Channel fromFloat(float value) {
            return Channel.from((int)(value * 255.0f + 0.5f));
        }

        public float toFloat() {
            return (float)this.value / 255.0f;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Channel) {
                return ((Channel)obj).value == this.value;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

